/*
 * Decompiled with CFR 0.152.
 */
package dev.vortex.api;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.vortex.api.Expression;
import dev.vortex.api.ScanOptions;
import dev.vortex.relocated.com.google.common.base.MoreObjects;
import dev.vortex.relocated.com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="ScanOptions", generator="Immutables")
public final class ImmutableScanOptions
implements ScanOptions {
    private final ImmutableList<String> columns;
    private final Expression predicate;
    private final long[] rowRange;
    private final long[] rowIndices;

    private ImmutableScanOptions(ImmutableList<String> columns, Expression predicate, long[] rowRange, long[] rowIndices) {
        this.columns = columns;
        this.predicate = predicate;
        this.rowRange = rowRange;
        this.rowIndices = rowIndices;
    }

    public ImmutableList<String> columns() {
        return this.columns;
    }

    @Override
    public Optional<Expression> predicate() {
        return Optional.ofNullable(this.predicate);
    }

    @Override
    public Optional<long[]> rowRange() {
        return Optional.ofNullable(this.rowRange);
    }

    @Override
    public Optional<long[]> rowIndices() {
        return Optional.ofNullable(this.rowIndices);
    }

    public final ImmutableScanOptions withColumns(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableScanOptions(newValue, this.predicate, this.rowRange, this.rowIndices);
    }

    public final ImmutableScanOptions withColumns(Iterable<String> elements) {
        if (this.columns == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableScanOptions(newValue, this.predicate, this.rowRange, this.rowIndices);
    }

    public final ImmutableScanOptions withPredicate(Expression value) {
        Expression newValue = Objects.requireNonNull(value, "predicate");
        if (Objects.equals(this.predicate, newValue)) {
            return this;
        }
        return new ImmutableScanOptions(this.columns, newValue, this.rowRange, this.rowIndices);
    }

    public final ImmutableScanOptions withPredicate(Optional<? extends Expression> optional) {
        Expression value = optional.orElse(null);
        if (Objects.equals(this.predicate, value)) {
            return this;
        }
        return new ImmutableScanOptions(this.columns, value, this.rowRange, this.rowIndices);
    }

    public final ImmutableScanOptions withRowRange(long[] value) {
        long[] newValue = Objects.requireNonNull(value, "rowRange");
        if (Objects.equals(this.rowRange, newValue)) {
            return this;
        }
        return new ImmutableScanOptions(this.columns, this.predicate, newValue, this.rowIndices);
    }

    public final ImmutableScanOptions withRowRange(Optional<? extends long[]> optional) {
        long[] value = optional.orElse(null);
        if (Objects.equals(this.rowRange, value)) {
            return this;
        }
        return new ImmutableScanOptions(this.columns, this.predicate, value, this.rowIndices);
    }

    public final ImmutableScanOptions withRowIndices(long[] value) {
        long[] newValue = Objects.requireNonNull(value, "rowIndices");
        if (Objects.equals(this.rowIndices, newValue)) {
            return this;
        }
        return new ImmutableScanOptions(this.columns, this.predicate, this.rowRange, newValue);
    }

    public final ImmutableScanOptions withRowIndices(Optional<? extends long[]> optional) {
        long[] value = optional.orElse(null);
        if (Objects.equals(this.rowIndices, value)) {
            return this;
        }
        return new ImmutableScanOptions(this.columns, this.predicate, this.rowRange, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableScanOptions && this.equalsByValue((ImmutableScanOptions)another);
    }

    private boolean equalsByValue(ImmutableScanOptions another) {
        return this.columns.equals(another.columns) && Objects.equals(this.predicate, another.predicate) && Objects.equals(this.rowRange, another.rowRange) && Objects.equals(this.rowIndices, another.rowIndices);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.columns.hashCode();
        h += (h << 5) + Objects.hashCode(this.predicate);
        h += (h << 5) + Objects.hashCode(this.rowRange);
        h += (h << 5) + Objects.hashCode(this.rowIndices);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ScanOptions").omitNullValues().add("columns", this.columns).add("predicate", this.predicate).add("rowRange", this.rowRange).add("rowIndices", this.rowIndices).toString();
    }

    public static ImmutableScanOptions copyOf(ScanOptions instance) {
        if (instance instanceof ImmutableScanOptions) {
            return (ImmutableScanOptions)instance;
        }
        return ImmutableScanOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ScanOptions", generator="Immutables")
    public static final class Builder {
        private ImmutableList.Builder<String> columns = ImmutableList.builder();
        private Expression predicate;
        private long[] rowRange;
        private long[] rowIndices;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ScanOptions instance) {
            Optional<long[]> rowIndicesOptional;
            Optional<long[]> rowRangeOptional;
            Objects.requireNonNull(instance, "instance");
            this.addAllColumns(instance.columns());
            Optional<Expression> predicateOptional = instance.predicate();
            if (predicateOptional.isPresent()) {
                this.predicate(predicateOptional);
            }
            if ((rowRangeOptional = instance.rowRange()).isPresent()) {
                this.rowRange(rowRangeOptional);
            }
            if ((rowIndicesOptional = instance.rowIndices()).isPresent()) {
                this.rowIndices(rowIndicesOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addColumns(String element) {
            this.columns.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addColumns(String ... elements) {
            this.columns.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder columns(Iterable<String> elements) {
            this.columns = ImmutableList.builder();
            return this.addAllColumns(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllColumns(Iterable<String> elements) {
            this.columns.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder predicate(Expression predicate) {
            this.predicate = Objects.requireNonNull(predicate, "predicate");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder predicate(Optional<? extends Expression> predicate) {
            this.predicate = predicate.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rowRange(long[] rowRange) {
            this.rowRange = Objects.requireNonNull(rowRange, "rowRange");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rowRange(Optional<? extends long[]> rowRange) {
            this.rowRange = rowRange.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rowIndices(long[] rowIndices) {
            this.rowIndices = Objects.requireNonNull(rowIndices, "rowIndices");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rowIndices(Optional<? extends long[]> rowIndices) {
            this.rowIndices = rowIndices.orElse(null);
            return this;
        }

        public ImmutableScanOptions build() {
            return new ImmutableScanOptions((ImmutableList<String>)this.columns.build(), this.predicate, this.rowRange, this.rowIndices);
        }
    }
}

