/*
 * Decompiled with CFR 0.152.
 */
package dev.vortex.api.expressions;

import dev.vortex.api.Expression;
import dev.vortex.api.expressions.Literal;
import java.util.Objects;
import java.util.stream.Stream;

public final class Binary
implements Expression {
    private final BinaryOp operator;
    private final Expression left;
    private final Expression right;

    private Binary(BinaryOp operator, Expression left, Expression right) {
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    public static Binary of(BinaryOp operator, Expression left, Expression right) {
        return new Binary(operator, left, right);
    }

    public static Binary and(Expression first, Expression ... rest) {
        Expression rhs = Stream.of(rest).reduce((x$0, xva$1) -> Binary.and(x$0, xva$1)).orElse(Literal.bool(true));
        return new Binary(BinaryOp.AND, first, rhs);
    }

    public static Binary or(Expression first, Expression ... rest) {
        Expression rhs = Stream.of(rest).reduce((x$0, xva$1) -> Binary.or(x$0, xva$1)).orElse(Literal.bool(false));
        return new Binary(BinaryOp.OR, first, rhs);
    }

    public static Binary eq(Expression left, Expression right) {
        return new Binary(BinaryOp.EQ, left, right);
    }

    public static Binary notEq(Expression left, Expression right) {
        return new Binary(BinaryOp.NOT_EQ, left, right);
    }

    public static Binary gt(Expression left, Expression right) {
        return new Binary(BinaryOp.GT, left, right);
    }

    public static Binary gtEq(Expression left, Expression right) {
        return new Binary(BinaryOp.GT_EQ, left, right);
    }

    public static Binary lt(Expression left, Expression right) {
        return new Binary(BinaryOp.LT, left, right);
    }

    public static Binary ltEq(Expression left, Expression right) {
        return new Binary(BinaryOp.LT_EQ, left, right);
    }

    @Override
    public String type() {
        return "binary";
    }

    public String toString() {
        return "(" + String.valueOf(this.left) + " " + String.valueOf((Object)this.operator) + " " + String.valueOf(this.right) + ")";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Binary binary = (Binary)o;
        return this.operator == binary.operator && Objects.equals(this.left, binary.left) && Objects.equals(this.right, binary.right);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.left, this.right});
    }

    @Override
    public <T> T accept(Expression.Visitor<T> visitor) {
        return visitor.visitBinary(this);
    }

    public BinaryOp getOperator() {
        return this.operator;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public static enum BinaryOp {
        EQ,
        NOT_EQ,
        GT,
        GT_EQ,
        LT,
        LT_EQ,
        AND,
        OR;


        public String toString() {
            switch (this) {
                case EQ: {
                    return "==";
                }
                case NOT_EQ: {
                    return "!=";
                }
                case GT: {
                    return ">";
                }
                case GT_EQ: {
                    return ">=";
                }
                case LT: {
                    return "<";
                }
                case LT_EQ: {
                    return "<=";
                }
                case AND: {
                    return "&&";
                }
                case OR: {
                    return "||";
                }
            }
            throw new IllegalStateException("Unknown Operator: " + String.valueOf((Object)this));
        }
    }
}

