/*
 * Decompiled with CFR 0.152.
 */
package dev.vortex.api.expressions;

import dev.vortex.api.Expression;
import dev.vortex.relocated.com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

public abstract class Literal<T>
implements Expression {
    private final T value;

    private Literal(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public String type() {
        return "literal";
    }

    public int hashCode() {
        return Objects.hashCode(this.getValue());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Literal)) {
            return false;
        }
        Literal literal = (Literal)o;
        return Objects.equals(this.value, literal.value);
    }

    public static Literal<Void> nullLit() {
        return NullLiteral.INSTANCE;
    }

    public static Literal<Boolean> bool(Boolean value) {
        return new BooleanLiteral(value);
    }

    public static Literal<Byte> int8(Byte value) {
        return new Int8Literal(value);
    }

    public static Literal<Short> int16(Short value) {
        return new Int16Literal(value);
    }

    public static Literal<Integer> int32(Integer value) {
        return new Int32Literal(value);
    }

    public static Literal<Long> int64(Long value) {
        return new Int64Literal(value);
    }

    public static Literal<Float> float32(Float value) {
        return new Float32Literal(value);
    }

    public static Literal<Double> float64(Double value) {
        return new Float64Literal(value);
    }

    public static Literal<BigDecimal> decimal(BigDecimal value, int precision, int scale) {
        return new DecimalLiteral(value, precision, scale);
    }

    public static Literal<String> string(String value) {
        return new StringLiteral(value);
    }

    public static Literal<byte[]> bytes(byte[] value) {
        return new BytesLiteral(value);
    }

    public static Literal<Integer> timeSeconds(Integer value) {
        return new TimeSeconds(value);
    }

    public static Literal<Integer> timeMillis(Integer value) {
        return new TimeMillis(value);
    }

    public static Literal<Long> timeMicros(Long value) {
        return new TimeMicros(value);
    }

    public static Literal<Long> timeNanos(Long value) {
        return new TimeNanos(value);
    }

    public static Literal<Integer> dateDays(Integer value) {
        return new DateDays(value);
    }

    public static Literal<Long> dateMillis(Long value) {
        return new DateMillis(value);
    }

    public static Literal<Long> timestampMillis(Long value, Optional<String> timeZone) {
        return new TimestampMillis(value, timeZone);
    }

    public static Literal<Long> timestampMicros(Long value, Optional<String> timeZone) {
        return new TimestampMicros(value, timeZone);
    }

    public static Literal<Long> timestampNanos(Long value, Optional<String> timeZone) {
        return new TimestampNanos(value, timeZone);
    }

    public <R> R accept(Expression.Visitor<R> visitor) {
        return visitor.visitLiteral(this);
    }

    public abstract <U> U acceptLiteralVisitor(LiteralVisitor<U> var1);

    static final class NullLiteral
    extends Literal<Void> {
        static final NullLiteral INSTANCE = new NullLiteral();

        private NullLiteral() {
            super(null);
        }

        @Override
        public <U> U acceptLiteralVisitor(LiteralVisitor<U> visitor) {
            return visitor.visitNull();
        }
    }

    static final class BooleanLiteral
    extends Literal<Boolean> {
        BooleanLiteral(Boolean value) {
            super(value);
        }

        @Override
        public <U> U acceptLiteralVisitor(LiteralVisitor<U> visitor) {
            return visitor.visitBoolean((Boolean)this.getValue());
        }
    }

    static final class Int8Literal
    extends Literal<Byte> {
        Int8Literal(Byte value) {
            super(value);
        }

        @Override
        public <U> U acceptLiteralVisitor(LiteralVisitor<U> visitor) {
            return visitor.visitInt8((Byte)this.getValue());
        }
    }

    static final class Int16Literal
    extends Literal<Short> {
        Int16Literal(Short value) {
            super(value);
        }

        @Override
        public <U> U acceptLiteralVisitor(LiteralVisitor<U> visitor) {
            return visitor.visitInt16((Short)this.getValue());
        }
    }

    static final class Int32Literal
    extends Literal<Integer> {
        Int32Literal(Integer value) {
            super(value);
        }

        @Override
        public <U> U acceptLiteralVisitor(LiteralVisitor<U> visitor) {
            return visitor.visitInt32((Integer)this.getValue());
        }
    }

    static final class Int64Literal
    extends Literal<Long> {
        Int64Literal(Long value) {
            super(value);
        }

        @Override
        public <U> U acceptLiteralVisitor(LiteralVisitor<U> visitor) {
            return visitor.visitInt64((Long)this.getValue());
        }
    }

    static final class Float32Literal
    extends Literal<Float> {
        Float32Literal(Float value) {
            super(value);
        }

        @Override
        public <U> U acceptLiteralVisitor(LiteralVisitor<U> visitor) {
            return visitor.visitFloat32((Float)this.getValue());
        }
    }

    static final class Float64Literal
    extends Literal<Double> {
        Float64Literal(Double value) {
            super(value);
        }

        @Override
        public <U> U acceptLiteralVisitor(LiteralVisitor<U> visitor) {
            return visitor.visitFloat64((Double)this.getValue());
        }
    }

    static final class DecimalLiteral
    extends Literal<BigDecimal> {
        private final int precision;
        private final int scale;

        DecimalLiteral(BigDecimal value, int precision, int scale) {
            super(value);
            if (!Objects.isNull(value)) {
                Preconditions.checkArgument(scale == value.scale(), "scale %s \u2260 value scale %s", scale, value.scale());
            }
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        public <U> U acceptLiteralVisitor(LiteralVisitor<U> visitor) {
            return visitor.visitDecimal((BigDecimal)this.getValue(), this.precision, this.scale);
        }
    }

    static final class StringLiteral
    extends Literal<String> {
        StringLiteral(String value) {
            super(value);
        }

        @Override
        public <U> U acceptLiteralVisitor(LiteralVisitor<U> visitor) {
            return visitor.visitString((String)this.getValue());
        }
    }

    static final class BytesLiteral
    extends Literal<byte[]> {
        BytesLiteral(byte[] value) {
            super(value);
        }

        @Override
        public <U> U acceptLiteralVisitor(LiteralVisitor<U> visitor) {
            return visitor.visitBytes((byte[])this.getValue());
        }
    }

    static final class TimeSeconds
    extends Literal<Integer> {
        TimeSeconds(Integer value) {
            super(value);
        }

        @Override
        public <U> U acceptLiteralVisitor(LiteralVisitor<U> visitor) {
            return visitor.visitTimeSeconds((Integer)this.getValue());
        }
    }

    static final class TimeMillis
    extends Literal<Integer> {
        TimeMillis(Integer value) {
            super(value);
        }

        @Override
        public <U> U acceptLiteralVisitor(LiteralVisitor<U> visitor) {
            return visitor.visitTimeMillis((Integer)this.getValue());
        }
    }

    static final class TimeMicros
    extends Literal<Long> {
        TimeMicros(Long value) {
            super(value);
        }

        @Override
        public <U> U acceptLiteralVisitor(LiteralVisitor<U> visitor) {
            return visitor.visitTimeMicros((Long)this.getValue());
        }
    }

    static final class TimeNanos
    extends Literal<Long> {
        TimeNanos(Long value) {
            super(value);
        }

        @Override
        public <U> U acceptLiteralVisitor(LiteralVisitor<U> visitor) {
            return visitor.visitTimeNanos((Long)this.getValue());
        }
    }

    static final class DateDays
    extends Literal<Integer> {
        DateDays(Integer value) {
            super(value);
        }

        @Override
        public <U> U acceptLiteralVisitor(LiteralVisitor<U> visitor) {
            return visitor.visitDateDays((Integer)this.getValue());
        }
    }

    static final class DateMillis
    extends Literal<Long> {
        DateMillis(Long value) {
            super(value);
        }

        @Override
        public <U> U acceptLiteralVisitor(LiteralVisitor<U> visitor) {
            return visitor.visitDateMillis((Long)this.getValue());
        }
    }

    static final class TimestampMillis
    extends Literal<Long> {
        private final Optional<String> timeZone;

        TimestampMillis(Long value, Optional<String> timeZone) {
            super(value);
            this.timeZone = timeZone;
        }

        @Override
        public <U> U acceptLiteralVisitor(LiteralVisitor<U> visitor) {
            return visitor.visitTimestampMillis((Long)this.getValue(), this.timeZone);
        }
    }

    static final class TimestampMicros
    extends Literal<Long> {
        private final Optional<String> timeZone;

        TimestampMicros(Long value, Optional<String> timeZone) {
            super(value);
            this.timeZone = timeZone;
        }

        @Override
        public <U> U acceptLiteralVisitor(LiteralVisitor<U> visitor) {
            return visitor.visitTimestampMicros((Long)this.getValue(), this.timeZone);
        }
    }

    static final class TimestampNanos
    extends Literal<Long> {
        private final Optional<String> timeZone;

        TimestampNanos(Long value, Optional<String> timeZone) {
            super(value);
            this.timeZone = timeZone;
        }

        @Override
        public <U> U acceptLiteralVisitor(LiteralVisitor<U> visitor) {
            return visitor.visitTimestampNanos((Long)this.getValue(), this.timeZone);
        }
    }

    public static interface LiteralVisitor<U> {
        public U visitNull();

        public U visitBoolean(Boolean var1);

        public U visitInt8(Byte var1);

        public U visitInt16(Short var1);

        public U visitInt32(Integer var1);

        public U visitInt64(Long var1);

        public U visitDateDays(Integer var1);

        public U visitDateMillis(Long var1);

        public U visitTimeSeconds(Integer var1);

        public U visitTimeMillis(Integer var1);

        public U visitTimeMicros(Long var1);

        public U visitTimeNanos(Long var1);

        public U visitTimestampMillis(Long var1, Optional<String> var2);

        public U visitTimestampMicros(Long var1, Optional<String> var2);

        public U visitTimestampNanos(Long var1, Optional<String> var2);

        public U visitFloat32(Float var1);

        public U visitFloat64(Double var1);

        public U visitDecimal(BigDecimal var1, int var2, int var3);

        public U visitString(String var1);

        public U visitBytes(byte[] var1);
    }
}

