/*
 * Decompiled with CFR 0.152.
 */
package dev.vortex.api.expressions.proto;

import dev.vortex.api.Expression;
import dev.vortex.api.expressions.Binary;
import dev.vortex.api.expressions.GetItem;
import dev.vortex.api.expressions.Identity;
import dev.vortex.api.expressions.Literal;
import dev.vortex.api.expressions.Not;
import dev.vortex.api.expressions.proto.EndianUtils;
import dev.vortex.api.expressions.proto.TemporalMetadatas;
import dev.vortex.proto.DTypeProtos;
import dev.vortex.proto.ExprProtos;
import dev.vortex.proto.ScalarProtos;
import dev.vortex.relocated.com.google.common.base.Preconditions;
import dev.vortex.relocated.com.google.common.collect.Iterables;
import dev.vortex.relocated.com.google.protobuf.ByteString;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;

public final class ExpressionProtoDeserializer {
    private ExpressionProtoDeserializer() {
    }

    public static Expression deserialize(ExprProtos.Expr expr) {
        switch (expr.getKind().getKindCase()) {
            case LITERAL: {
                return ExpressionProtoDeserializer.deserializeLiteral(expr.getKind().getLiteral(), expr.getChildrenList());
            }
            case BINARY_OP: {
                return ExpressionProtoDeserializer.deserializeBinaryOp(expr.getKind().getBinaryOp(), expr.getChildrenList());
            }
            case IDENTITY: {
                return ExpressionProtoDeserializer.deserializeIdentity(expr.getKind().getIdentity());
            }
            case NOT: {
                return ExpressionProtoDeserializer.deserializeNot(expr.getKind().getNot(), expr.getChildrenList());
            }
            case GET_ITEM: {
                return ExpressionProtoDeserializer.deserializeGetItem(expr.getKind().getGetItem(), expr.getChildrenList());
            }
        }
        throw new UnsupportedOperationException("Unsupported expression type encountered: " + String.valueOf(expr.getKind().getKindCase()));
    }

    private static Expression deserializeIdentity(ExprProtos.Kind.Identity identity) {
        return Identity.INSTANCE;
    }

    private static Expression deserializeBinaryOp(ExprProtos.Kind.BinaryOp binaryOp, List<ExprProtos.Expr> children) {
        switch (binaryOp) {
            case Eq: {
                Expression left = ExpressionProtoDeserializer.deserialize(children.get(0));
                Expression right = ExpressionProtoDeserializer.deserialize(children.get(1));
                return Binary.eq(left, right);
            }
            case NotEq: {
                Expression left = ExpressionProtoDeserializer.deserialize(children.get(0));
                Expression right = ExpressionProtoDeserializer.deserialize(children.get(1));
                return Binary.notEq(left, right);
            }
            case Gt: {
                Expression left = ExpressionProtoDeserializer.deserialize(children.get(0));
                Expression right = ExpressionProtoDeserializer.deserialize(children.get(1));
                return Binary.gt(left, right);
            }
            case Gte: {
                Expression left = ExpressionProtoDeserializer.deserialize(children.get(0));
                Expression right = ExpressionProtoDeserializer.deserialize(children.get(1));
                return Binary.gtEq(left, right);
            }
            case Lt: {
                Expression left = ExpressionProtoDeserializer.deserialize(children.get(0));
                Expression right = ExpressionProtoDeserializer.deserialize(children.get(1));
                return Binary.lt(left, right);
            }
            case Lte: {
                Expression left = ExpressionProtoDeserializer.deserialize(children.get(0));
                Expression right = ExpressionProtoDeserializer.deserialize(children.get(1));
                return Binary.ltEq(left, right);
            }
            case And: {
                Expression left = ExpressionProtoDeserializer.deserialize(children.get(0));
                Expression right = ExpressionProtoDeserializer.deserialize(children.get(1));
                return Binary.and(left, right);
            }
            case Or: {
                Expression left = ExpressionProtoDeserializer.deserialize(children.get(0));
                Expression right = ExpressionProtoDeserializer.deserialize(children.get(1));
                return Binary.or(left, right);
            }
        }
        throw new UnsupportedOperationException("Unsupported BinaryOp encountered: " + String.valueOf(binaryOp));
    }

    private static Expression deserializeLiteral(ExprProtos.Kind.Literal literal, List<ExprProtos.Expr> children) {
        ScalarProtos.Scalar literalScalar = literal.getValue();
        DTypeProtos.DType dtype = literalScalar.getDtype();
        if (dtype.hasExtension()) {
            return ExpressionProtoDeserializer.deserializeExtensionLiteral(literal);
        }
        ScalarProtos.ScalarValue scalarValue = literalScalar.getValue();
        switch (scalarValue.getKindCase()) {
            case NULL_VALUE: {
                return ExpressionProtoDeserializer.nullLiteral(dtype);
            }
            case BOOL_VALUE: {
                return Literal.bool(scalarValue.getBoolValue());
            }
            case INT64_VALUE: {
                return Literal.int64(scalarValue.getInt64Value());
            }
            case UINT64_VALUE: {
                return Literal.int64(scalarValue.getUint64Value());
            }
            case F32_VALUE: {
                return Literal.float32(Float.valueOf(scalarValue.getF32Value()));
            }
            case F64_VALUE: {
                return Literal.float64(scalarValue.getF64Value());
            }
            case STRING_VALUE: {
                return Literal.string(scalarValue.getStringValue());
            }
            case BYTES_VALUE: {
                if (dtype.hasDecimal()) {
                    ByteString littleEndian = scalarValue.getBytesValue();
                    byte[] bigEndian = EndianUtils.reverse(littleEndian);
                    BigDecimal value = new BigDecimal(new BigInteger(bigEndian), dtype.getDecimal().getScale());
                    return Literal.decimal(value, dtype.getDecimal().getPrecision(), dtype.getDecimal().getScale());
                }
                return Literal.bytes(scalarValue.getBytesValue().toByteArray());
            }
        }
        throw new UnsupportedOperationException("Unsupported ScalarValue type encountered: " + String.valueOf(scalarValue));
    }

    private static Expression deserializeExtensionLiteral(ExprProtos.Kind.Literal literal) {
        String extId;
        ScalarProtos.Scalar scalar = literal.getValue();
        DTypeProtos.DType scalarType = scalar.getDtype();
        Preconditions.checkArgument(scalarType.hasExtension());
        DTypeProtos.Extension extType = scalarType.getExtension();
        switch (extId = scalarType.getExtension().getId()) {
            case "vortex.time": {
                byte timeUnit = TemporalMetadatas.getTimeUnit(extType.getMetadata().toByteArray());
                if (timeUnit == TemporalMetadatas.TIME_UNIT_SECONDS) {
                    return Literal.timeSeconds(Math.toIntExact(scalar.getValue().getInt64Value()));
                }
                if (timeUnit == TemporalMetadatas.TIME_UNIT_MILLIS) {
                    return Literal.timeMillis(Math.toIntExact(scalar.getValue().getInt64Value()));
                }
                if (timeUnit == TemporalMetadatas.TIME_UNIT_MICROS) {
                    return Literal.timeMicros(scalar.getValue().getInt64Value());
                }
                if (timeUnit == TemporalMetadatas.TIME_UNIT_NANOS) {
                    return Literal.timeNanos(scalar.getValue().getInt64Value());
                }
                throw new UnsupportedOperationException("Unsupported TIME time unit: " + timeUnit);
            }
            case "vortex.date": {
                byte timeUnit = TemporalMetadatas.getTimeUnit(extType.getMetadata().toByteArray());
                if (timeUnit == TemporalMetadatas.TIME_UNIT_DAYS) {
                    return Literal.dateDays(Math.toIntExact(scalar.getValue().getInt64Value()));
                }
                if (timeUnit == TemporalMetadatas.TIME_UNIT_MILLIS) {
                    return Literal.dateMillis(scalar.getValue().getInt64Value());
                }
                throw new UnsupportedOperationException("Unsupported DATE time unit: " + timeUnit);
            }
            case "vortex.timestamp": {
                byte timeUnit = TemporalMetadatas.getTimeUnit(extType.getMetadata().toByteArray());
                Optional<String> timeZone = TemporalMetadatas.getTimeZone(extType.getMetadata().toByteArray());
                if (timeUnit == TemporalMetadatas.TIME_UNIT_MILLIS) {
                    return Literal.timestampMillis(scalar.getValue().getInt64Value(), timeZone);
                }
                if (timeUnit == TemporalMetadatas.TIME_UNIT_MICROS) {
                    return Literal.timestampMicros(scalar.getValue().getInt64Value(), timeZone);
                }
                if (timeUnit == TemporalMetadatas.TIME_UNIT_NANOS) {
                    return Literal.timestampNanos(scalar.getValue().getInt64Value(), timeZone);
                }
                throw new UnsupportedOperationException("Unsupported TIMESTAMP time unit: " + timeUnit);
            }
        }
        throw new UnsupportedOperationException("Unsupported extension type: " + extId);
    }

    private static Expression deserializeNot(ExprProtos.Kind.Not not, List<ExprProtos.Expr> children) {
        ExprProtos.Expr child = Iterables.getOnlyElement(children);
        Expression childExpr = ExpressionProtoDeserializer.deserialize(child);
        return Not.of(childExpr);
    }

    private static Expression deserializeGetItem(ExprProtos.Kind.GetItem getItem, List<ExprProtos.Expr> children) {
        ExprProtos.Expr child = Iterables.getOnlyElement(children);
        Expression childExpr = ExpressionProtoDeserializer.deserialize(child);
        return GetItem.of(childExpr, getItem.getPath());
    }

    private static Literal<?> nullLiteral(DTypeProtos.DType type) {
        switch (type.getDtypeTypeCase()) {
            case NULL: {
                return Literal.nullLit();
            }
            case BOOL: {
                return Literal.bool(null);
            }
            case PRIMITIVE: {
                switch (type.getPrimitive().getType()) {
                    case U8: 
                    case I8: {
                        return Literal.int8(null);
                    }
                    case U16: 
                    case I16: {
                        return Literal.int16(null);
                    }
                    case U32: 
                    case I32: {
                        return Literal.int32(null);
                    }
                    case U64: 
                    case I64: {
                        return Literal.int64(null);
                    }
                    case F32: {
                        return Literal.float32(null);
                    }
                    case F64: {
                        return Literal.float64(null);
                    }
                }
                throw new UnsupportedOperationException("Unsupported ScalarValue type encountered: " + String.valueOf(type));
            }
            case DECIMAL: {
                return Literal.decimal(null, type.getDecimal().getPrecision(), type.getDecimal().getScale());
            }
            case UTF8: {
                return Literal.string(null);
            }
            case BINARY: {
                return Literal.bytes(null);
            }
        }
        throw new UnsupportedOperationException("Unsupported ScalarValue type encountered: " + String.valueOf(type));
    }
}

