/*
 * Decompiled with CFR 0.152.
 */
package dev.vortex.api.expressions.proto;

import dev.vortex.api.expressions.proto.DTypes;
import dev.vortex.api.expressions.proto.EndianUtils;
import dev.vortex.proto.ScalarProtos;
import dev.vortex.relocated.com.google.protobuf.ByteString;
import dev.vortex.relocated.com.google.protobuf.NullValue;
import java.math.BigDecimal;
import java.util.Optional;

final class Scalars {
    private Scalars() {
    }

    static ScalarProtos.Scalar nullNull() {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).setDtype(DTypes.nullType()).build();
    }

    static ScalarProtos.Scalar bool(boolean value) {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setBoolValue(value).build()).setDtype(DTypes.bool(false)).build();
    }

    static ScalarProtos.Scalar nullBool() {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).setDtype(DTypes.bool(true)).build();
    }

    static ScalarProtos.Scalar int8(byte value) {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setInt64Value(value).build()).setDtype(DTypes.int8(false)).build();
    }

    static ScalarProtos.Scalar nullInt8() {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).setDtype(DTypes.int8(true)).build();
    }

    static ScalarProtos.Scalar int16(short value) {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setInt64Value(value).build()).setDtype(DTypes.int16(false)).build();
    }

    static ScalarProtos.Scalar nullInt16() {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).setDtype(DTypes.int16(true)).build();
    }

    static ScalarProtos.Scalar int32(int value) {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setInt64Value(value).build()).setDtype(DTypes.int32(false)).build();
    }

    static ScalarProtos.Scalar nullInt32() {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).setDtype(DTypes.int32(true)).build();
    }

    static ScalarProtos.Scalar int64(long value) {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setInt64Value(value).build()).setDtype(DTypes.int64(false)).build();
    }

    static ScalarProtos.Scalar nullInt64() {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).setDtype(DTypes.int64(true)).build();
    }

    static ScalarProtos.Scalar float32(float value) {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setF32Value(value).build()).setDtype(DTypes.float32(false)).build();
    }

    static ScalarProtos.Scalar nullFloat32() {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).setDtype(DTypes.float32(true)).build();
    }

    static ScalarProtos.Scalar float64(double value) {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setF64Value(value).build()).setDtype(DTypes.float64(false)).build();
    }

    static ScalarProtos.Scalar nullFloat64() {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).setDtype(DTypes.float64(true)).build();
    }

    static ScalarProtos.Scalar string(String value) {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setStringValue(value).build()).setDtype(DTypes.string(false)).build();
    }

    static ScalarProtos.Scalar nullString() {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).setDtype(DTypes.string(true)).build();
    }

    static ScalarProtos.Scalar decimal(BigDecimal decimal, int precision, int scale) {
        byte[] littleEndian = EndianUtils.littleEndianDecimal(decimal);
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setBytesValue(ByteString.copyFrom(littleEndian)).build()).setDtype(DTypes.decimal(false, precision, scale)).build();
    }

    static ScalarProtos.Scalar nullDecimal(int precision, int scale) {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setNullValue(NullValue.NULL_VALUE)).setDtype(DTypes.decimal(true, precision, scale)).build();
    }

    static ScalarProtos.Scalar bytes(byte[] value) {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setBytesValue(ByteString.copyFrom(value)).build()).setDtype(DTypes.binary(false)).build();
    }

    static ScalarProtos.Scalar nullBytes() {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).setDtype(DTypes.binary(true)).build();
    }

    static ScalarProtos.Scalar dateDays(int value) {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setInt64Value(value).build()).setDtype(DTypes.dateDays(false)).build();
    }

    static ScalarProtos.Scalar nullDateDays() {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).setDtype(DTypes.dateDays(true)).build();
    }

    static ScalarProtos.Scalar dateMillis(long value) {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setInt64Value(value).build()).setDtype(DTypes.dateMillis(false)).build();
    }

    static ScalarProtos.Scalar nullDateMillis() {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).setDtype(DTypes.dateMillis(true)).build();
    }

    static ScalarProtos.Scalar timeSeconds(int value) {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setInt64Value(value).build()).setDtype(DTypes.timeSeconds(false)).build();
    }

    static ScalarProtos.Scalar nullTimeSeconds() {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).setDtype(DTypes.timeSeconds(true)).build();
    }

    static ScalarProtos.Scalar timeMillis(int value) {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setInt64Value(value).build()).setDtype(DTypes.timeMillis(false)).build();
    }

    static ScalarProtos.Scalar nullTimeMillis() {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).setDtype(DTypes.timeMillis(true)).build();
    }

    static ScalarProtos.Scalar timeMicros(long value) {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setInt64Value(value).build()).setDtype(DTypes.timeMicros(false)).build();
    }

    static ScalarProtos.Scalar nullTimeMicros() {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).setDtype(DTypes.timeMicros(true)).build();
    }

    static ScalarProtos.Scalar timeNanos(long value) {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setInt64Value(value).build()).setDtype(DTypes.timeNanos(false)).build();
    }

    static ScalarProtos.Scalar nullTimeNanos() {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).setDtype(DTypes.timeNanos(true)).build();
    }

    static ScalarProtos.Scalar timestampMillis(long value, Optional<String> timeZone) {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setInt64Value(value).build()).setDtype(DTypes.timestampMillis(timeZone, false)).build();
    }

    static ScalarProtos.Scalar nullTimestampMillis(Optional<String> timeZone) {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).setDtype(DTypes.timestampMillis(timeZone, true)).build();
    }

    static ScalarProtos.Scalar timestampMicros(long value, Optional<String> timeZone) {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setInt64Value(value).build()).setDtype(DTypes.timestampMicros(timeZone, false)).build();
    }

    static ScalarProtos.Scalar nullTimestampMicros(Optional<String> timeZone) {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).setDtype(DTypes.timestampMicros(timeZone, true)).build();
    }

    static ScalarProtos.Scalar timestampNanos(long value, Optional<String> timeZone) {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setInt64Value(value).build()).setDtype(DTypes.timestampNanos(timeZone, false)).build();
    }

    static ScalarProtos.Scalar nullTimestampNanos(Optional<String> timeZone) {
        return ScalarProtos.Scalar.newBuilder().setValue(ScalarProtos.ScalarValue.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).setDtype(DTypes.timestampNanos(timeZone, true)).build();
    }
}

