/*
 * Decompiled with CFR 0.152.
 */
package dev.vortex.api.expressions.proto;

import dev.vortex.relocated.com.google.common.base.Preconditions;
import dev.vortex.relocated.com.google.common.base.Supplier;
import dev.vortex.relocated.com.google.common.base.Suppliers;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

final class TemporalMetadatas {
    static byte TIME_UNIT_NANOS = 0;
    static byte TIME_UNIT_MICROS = 1;
    static byte TIME_UNIT_MILLIS = (byte)2;
    static byte TIME_UNIT_SECONDS = (byte)3;
    static byte TIME_UNIT_DAYS = (byte)4;
    static final Supplier<byte[]> DATE_DAYS = Suppliers.memoize(() -> new byte[]{TIME_UNIT_DAYS});
    static final Supplier<byte[]> DATE_MILLIS = Suppliers.memoize(() -> new byte[]{TIME_UNIT_MILLIS});
    static final Supplier<byte[]> TIME_SECONDS = Suppliers.memoize(() -> new byte[]{TIME_UNIT_SECONDS});
    static final Supplier<byte[]> TIME_MILLIS = Suppliers.memoize(() -> new byte[]{TIME_UNIT_MILLIS});
    static final Supplier<byte[]> TIME_MICROS = Suppliers.memoize(() -> new byte[]{TIME_UNIT_MICROS});
    static final Supplier<byte[]> TIME_NANOS = Suppliers.memoize(() -> new byte[]{TIME_UNIT_NANOS});

    private TemporalMetadatas() {
    }

    static byte[] timestamp(byte timeUnit, Optional<String> timeZone) {
        Preconditions.checkArgument(timeUnit >= TIME_UNIT_NANOS && timeUnit < TIME_UNIT_DAYS, "invalid timeUnit for Timestamp:" + timeUnit);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(timeUnit);
        if (timeZone.isPresent()) {
            byte[] timeZoneBytes = timeZone.get().getBytes(StandardCharsets.UTF_8);
            int lenLow = timeZoneBytes.length & 0xFF;
            int lenHigh = timeZoneBytes.length >> 8 & 0xFF;
            baos.write(lenLow);
            baos.write(lenHigh);
            baos.writeBytes(timeZoneBytes);
        } else {
            baos.write(0);
            baos.write(0);
        }
        return baos.toByteArray();
    }

    static byte getTimeUnit(byte[] serializedMetadata) {
        byte timeUnit = serializedMetadata[0];
        Preconditions.checkArgument(timeUnit >= TIME_UNIT_NANOS && timeUnit <= TIME_UNIT_DAYS, "invalid timeUnit byte: " + timeUnit);
        return timeUnit;
    }

    static Optional<String> getTimeZone(byte[] serializedMetadata) {
        byte _timeUnit = serializedMetadata[0];
        byte lenHigh = serializedMetadata[2];
        byte lenLow = serializedMetadata[1];
        int len = (lenHigh & 0xFF) << 8 | lenLow & 0xFF;
        if (len == 0) {
            return Optional.empty();
        }
        byte[] timeZoneBytes = new byte[len];
        System.arraycopy(serializedMetadata, 3, timeZoneBytes, 0, len);
        return Optional.of(new String(timeZoneBytes, StandardCharsets.UTF_8));
    }
}

