/*
 * Decompiled with CFR 0.152.
 */
package dev.vortex.jni;

import dev.vortex.api.Array;
import dev.vortex.api.ArrayIterator;
import dev.vortex.api.DType;
import dev.vortex.jni.JNIArray;
import dev.vortex.jni.JNIDType;
import dev.vortex.jni.NativeArrayIteratorMethods;
import dev.vortex.relocated.com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.OptionalLong;

public final class JNIArrayIterator
implements ArrayIterator {
    private OptionalLong pointer;
    private Optional<Array> next;

    public JNIArrayIterator(long pointer) {
        Preconditions.checkArgument(pointer > 0L, "Invalid pointer address: " + pointer);
        this.pointer = OptionalLong.of(pointer);
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.next.isPresent();
    }

    @Override
    public Array next() {
        Array array = this.next.get();
        this.advance();
        return array;
    }

    @Override
    public DType getDataType() {
        return new JNIDType(NativeArrayIteratorMethods.getDType(this.pointer.getAsLong()), false);
    }

    @Override
    public void close() {
        if (this.pointer.isEmpty()) {
            return;
        }
        NativeArrayIteratorMethods.free(this.pointer.getAsLong());
        this.pointer = OptionalLong.empty();
        this.next = Optional.empty();
    }

    private void advance() {
        long next = NativeArrayIteratorMethods.take(this.pointer.getAsLong());
        this.next = next <= 0L ? Optional.empty() : Optional.of(new JNIArray(next));
    }
}

