/*
 * Decompiled with CFR 0.152.
 */
package dev.vortex.jni;

import dev.vortex.api.DType;
import dev.vortex.jni.NativeDTypeMethods;
import dev.vortex.relocated.com.google.common.base.Preconditions;
import dev.vortex.relocated.com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;

public final class JNIDType
implements DType {
    private final boolean shouldFree;
    private OptionalLong pointer;

    public JNIDType(long pointer, boolean shouldFree) {
        Preconditions.checkArgument(pointer > 0L, "Invalid pointer address: " + pointer);
        this.pointer = OptionalLong.of(pointer);
        this.shouldFree = shouldFree;
    }

    @Override
    public DType.Variant getVariant() {
        return DType.Variant.from(NativeDTypeMethods.getVariant(this.pointer.getAsLong()));
    }

    @Override
    public boolean isNullable() {
        return NativeDTypeMethods.isNullable(this.pointer.getAsLong());
    }

    @Override
    public List<String> getFieldNames() {
        return NativeDTypeMethods.getFieldNames(this.pointer.getAsLong());
    }

    @Override
    public List<DType> getFieldTypes() {
        return Lists.transform(NativeDTypeMethods.getFieldTypes(this.pointer.getAsLong()), typePtr -> new JNIDType((long)typePtr, false));
    }

    @Override
    public DType getElementType() {
        return new JNIDType(NativeDTypeMethods.getElementType(this.pointer.getAsLong()), false);
    }

    @Override
    public boolean isDate() {
        return NativeDTypeMethods.isDate(this.pointer.getAsLong());
    }

    @Override
    public boolean isTime() {
        return NativeDTypeMethods.isTime(this.pointer.getAsLong());
    }

    @Override
    public boolean isTimestamp() {
        return NativeDTypeMethods.isTimestamp(this.pointer.getAsLong());
    }

    @Override
    public DType.TimeUnit getTimeUnit() {
        return DType.TimeUnit.from(NativeDTypeMethods.getTimeUnit(this.pointer.getAsLong()));
    }

    @Override
    public Optional<String> getTimeZone() {
        return Optional.ofNullable(NativeDTypeMethods.getTimeZone(this.pointer.getAsLong()));
    }

    @Override
    public boolean isDecimal() {
        return NativeDTypeMethods.isDecimal(this.pointer.getAsLong());
    }

    @Override
    public int getPrecision() {
        return NativeDTypeMethods.getDecimalPrecision(this.pointer.getAsLong());
    }

    @Override
    public byte getScale() {
        return NativeDTypeMethods.getDecimalScale(this.pointer.getAsLong());
    }

    @Override
    public void close() {
        if (this.shouldFree && this.pointer.isPresent()) {
            NativeDTypeMethods.free(this.pointer.getAsLong());
            this.pointer = OptionalLong.empty();
        }
    }
}

