/*
 * Decompiled with CFR 0.152.
 */
package dev.vortex.jni;

import dev.vortex.api.ArrayIterator;
import dev.vortex.api.DType;
import dev.vortex.api.File;
import dev.vortex.api.ScanOptions;
import dev.vortex.api.expressions.proto.ExpressionProtoSerializer;
import dev.vortex.jni.JNIArrayIterator;
import dev.vortex.jni.JNIDType;
import dev.vortex.jni.NativeFileMethods;
import dev.vortex.relocated.com.google.common.base.Preconditions;
import java.util.OptionalLong;

public final class JNIFile
implements File {
    private OptionalLong pointer;

    public JNIFile(long pointer) {
        Preconditions.checkArgument(pointer > 0L, "Invalid pointer address: " + pointer);
        this.pointer = OptionalLong.of(pointer);
    }

    @Override
    public DType getDType() {
        return new JNIDType(NativeFileMethods.dtype(this.pointer.getAsLong()), false);
    }

    @Override
    public long rowCount() {
        return NativeFileMethods.rowCount(this.pointer.getAsLong());
    }

    @Override
    public ArrayIterator newScan(ScanOptions options) {
        byte[] predicateProto = null;
        if (options.predicate().isPresent()) {
            predicateProto = ExpressionProtoSerializer.serialize(options.predicate().get()).toByteArray();
        }
        long[] rowIndices = options.rowIndices().orElse(null);
        long[] rowRange = options.rowRange().orElse(null);
        return new JNIArrayIterator(NativeFileMethods.scan(this.pointer.getAsLong(), options.columns(), predicateProto, rowRange, rowIndices));
    }

    @Override
    public void close() {
        if (this.pointer.isEmpty()) {
            return;
        }
        NativeFileMethods.close(this.pointer.getAsLong());
        this.pointer = OptionalLong.empty();
    }
}

