/*
 * Decompiled with CFR 0.152.
 */
package dev.vortex.jni;

import dev.vortex.relocated.com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

public final class NativeLoader {
    private static boolean loaded = false;

    private NativeLoader() {
    }

    public static synchronized void loadJni() {
        String osShortName;
        if (loaded) {
            return;
        }
        String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        String osArch = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
        Object libName = "libvortex_jni";
        if (osName.contains("win")) {
            osShortName = "win";
            libName = (String)libName + ".dll";
        } else if (osName.contains("mac")) {
            osShortName = "darwin";
            libName = (String)libName + ".dylib";
        } else if (osName.contains("nix") || osName.contains("nux")) {
            osShortName = "linux";
            libName = (String)libName + ".so";
        } else {
            throw new UnsupportedOperationException("Unsupported OS: " + osName);
        }
        String libPath = "/native/" + osShortName + "-" + osArch + "/" + (String)libName;
        try (InputStream in = NativeLoader.class.getResourceAsStream(libPath);){
            if (in == null) {
                throw new FileNotFoundException("Library not found: " + libPath);
            }
            File tempFile = File.createTempFile("libvortex_jni", ".dylib");
            tempFile.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(tempFile);){
                ByteStreams.copy(in, out);
            }
            libName = tempFile.getAbsolutePath();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load library: " + e.getMessage(), e);
        }
        System.load((String)libName);
        loaded = true;
    }
}

