/*
 * Decompiled with CFR 0.152.
 */
package dev.vortex.relocated.com.google.protobuf;

import dev.vortex.relocated.com.google.protobuf.CheckReturnValue;
import dev.vortex.relocated.com.google.protobuf.ExtensionSchema;
import dev.vortex.relocated.com.google.protobuf.ExtensionSchemaLite;
import dev.vortex.relocated.com.google.protobuf.Protobuf;

@CheckReturnValue
final class ExtensionSchemas {
    private static final ExtensionSchema<?> LITE_SCHEMA = new ExtensionSchemaLite();
    private static final ExtensionSchema<?> FULL_SCHEMA = ExtensionSchemas.loadSchemaForFullRuntime();

    private static ExtensionSchema<?> loadSchemaForFullRuntime() {
        if (Protobuf.assumeLiteRuntime) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName("dev.vortex.relocated.com.google.protobuf.ExtensionSchemaFull");
            return (ExtensionSchema)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    static ExtensionSchema<?> lite() {
        return LITE_SCHEMA;
    }

    static ExtensionSchema<?> full() {
        if (FULL_SCHEMA == null) {
            throw new IllegalStateException("Protobuf runtime is not correctly loaded.");
        }
        return FULL_SCHEMA;
    }

    private ExtensionSchemas() {
    }
}

