/*
 * Decompiled with CFR 0.152.
 */
package dev.vortex.relocated.org.apache.arrow.c;

import dev.vortex.relocated.org.apache.arrow.c.ArrayExporter;
import dev.vortex.relocated.org.apache.arrow.c.ArrayImporter;
import dev.vortex.relocated.org.apache.arrow.c.ArrayStreamExporter;
import dev.vortex.relocated.org.apache.arrow.c.ArrowArray;
import dev.vortex.relocated.org.apache.arrow.c.ArrowArrayStream;
import dev.vortex.relocated.org.apache.arrow.c.ArrowArrayStreamReader;
import dev.vortex.relocated.org.apache.arrow.c.ArrowSchema;
import dev.vortex.relocated.org.apache.arrow.c.CDataDictionaryProvider;
import dev.vortex.relocated.org.apache.arrow.c.SchemaExporter;
import dev.vortex.relocated.org.apache.arrow.c.SchemaImporter;
import dev.vortex.relocated.org.apache.arrow.c.StructVectorLoader;
import dev.vortex.relocated.org.apache.arrow.c.StructVectorUnloader;
import dev.vortex.relocated.org.apache.arrow.memory.BufferAllocator;
import dev.vortex.relocated.org.apache.arrow.vector.FieldVector;
import dev.vortex.relocated.org.apache.arrow.vector.VectorLoader;
import dev.vortex.relocated.org.apache.arrow.vector.VectorSchemaRoot;
import dev.vortex.relocated.org.apache.arrow.vector.VectorUnloader;
import dev.vortex.relocated.org.apache.arrow.vector.complex.StructVector;
import dev.vortex.relocated.org.apache.arrow.vector.dictionary.DictionaryProvider;
import dev.vortex.relocated.org.apache.arrow.vector.ipc.ArrowReader;
import dev.vortex.relocated.org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import dev.vortex.relocated.org.apache.arrow.vector.table.Table;
import dev.vortex.relocated.org.apache.arrow.vector.types.pojo.ArrowType;
import dev.vortex.relocated.org.apache.arrow.vector.types.pojo.Field;
import dev.vortex.relocated.org.apache.arrow.vector.types.pojo.FieldType;
import dev.vortex.relocated.org.apache.arrow.vector.types.pojo.Schema;

public final class Data {
    private Data() {
    }

    public static void exportField(BufferAllocator allocator, Field field, DictionaryProvider provider, ArrowSchema out) {
        SchemaExporter exporter = new SchemaExporter(allocator);
        exporter.export(out, field, provider);
    }

    public static void exportSchema(BufferAllocator allocator, Schema schema, DictionaryProvider provider, ArrowSchema out) {
        FieldType fieldType = new FieldType(false, new ArrowType.Struct(), null, schema.getCustomMetadata());
        Field field = new Field("", fieldType, schema.getFields());
        Data.exportField(allocator, field, provider, out);
    }

    public static void exportVector(BufferAllocator allocator, FieldVector vector, DictionaryProvider provider, ArrowArray out) {
        Data.exportVector(allocator, vector, provider, out, null);
    }

    public static void exportVector(BufferAllocator allocator, FieldVector vector, DictionaryProvider provider, ArrowArray out, ArrowSchema outSchema) {
        if (outSchema != null) {
            Data.exportField(allocator, vector.getField(), provider, outSchema);
        }
        ArrayExporter exporter = new ArrayExporter(allocator);
        exporter.export(out, vector, provider);
    }

    public static void exportTable(BufferAllocator allocator, Table table, ArrowArray out) {
        Data.exportTable(allocator, table, table.getDictionaryProvider(), out, null);
    }

    public static void exportTable(BufferAllocator allocator, Table table, DictionaryProvider provider, ArrowArray out) {
        Data.exportTable(allocator, table, provider, out, null);
    }

    public static void exportTable(BufferAllocator allocator, Table table, DictionaryProvider provider, ArrowArray out, ArrowSchema outSchema) {
        try (VectorSchemaRoot root = table.toVectorSchemaRoot();){
            Data.exportVectorSchemaRoot(allocator, root, provider, out, outSchema);
        }
    }

    public static void exportVectorSchemaRoot(BufferAllocator allocator, VectorSchemaRoot vsr, DictionaryProvider provider, ArrowArray out) {
        Data.exportVectorSchemaRoot(allocator, vsr, provider, out, null);
    }

    public static void exportVectorSchemaRoot(BufferAllocator allocator, VectorSchemaRoot vsr, DictionaryProvider provider, ArrowArray out, ArrowSchema outSchema) {
        if (outSchema != null) {
            Data.exportSchema(allocator, vsr.getSchema(), provider, outSchema);
        }
        VectorUnloader unloader = new VectorUnloader(vsr);
        try (ArrowRecordBatch recordBatch = unloader.getRecordBatch();){
            StructVectorLoader loader = new StructVectorLoader(vsr.getSchema());
            try (StructVector vector = loader.load(allocator, recordBatch);){
                Data.exportVector(allocator, vector, provider, out);
            }
        }
    }

    public static void exportArrayStream(BufferAllocator allocator, ArrowReader reader, ArrowArrayStream out) {
        new ArrayStreamExporter(allocator).export(out, reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Field importField(BufferAllocator allocator, ArrowSchema schema, CDataDictionaryProvider provider) {
        try {
            SchemaImporter importer = new SchemaImporter(allocator);
            Field field = importer.importField(schema, provider);
            return field;
        }
        finally {
            schema.release();
            schema.close();
        }
    }

    public static Schema importSchema(BufferAllocator allocator, ArrowSchema schema, CDataDictionaryProvider provider) {
        Field structField = Data.importField(allocator, schema, provider);
        if (structField.getType().getTypeID() != ArrowType.ArrowTypeID.Struct) {
            throw new IllegalArgumentException("Cannot import schema: ArrowSchema describes non-struct type");
        }
        return new Schema(structField.getChildren(), structField.getMetadata());
    }

    public static void importIntoVector(BufferAllocator allocator, ArrowArray array, FieldVector vector, DictionaryProvider provider) {
        ArrayImporter importer = new ArrayImporter(allocator, vector, provider);
        importer.importArray(array);
    }

    public static FieldVector importVector(BufferAllocator allocator, ArrowArray array, ArrowSchema schema, CDataDictionaryProvider provider) {
        Field field = Data.importField(allocator, schema, provider);
        FieldVector vector = field.createVector(allocator);
        Data.importIntoVector(allocator, array, vector, provider);
        return vector;
    }

    public static void importIntoVectorSchemaRoot(BufferAllocator allocator, ArrowArray array, VectorSchemaRoot root, DictionaryProvider provider) {
        try (StructVector structVector = StructVector.emptyWithDuplicates("", allocator);){
            structVector.initializeChildrenFromFields(root.getSchema().getFields());
            Data.importIntoVector(allocator, array, structVector, provider);
            StructVectorUnloader unloader = new StructVectorUnloader(structVector);
            VectorLoader loader = new VectorLoader(root);
            try (ArrowRecordBatch recordBatch = unloader.getRecordBatch();){
                loader.load(recordBatch);
            }
        }
    }

    public static VectorSchemaRoot importVectorSchemaRoot(BufferAllocator allocator, ArrowSchema schema, CDataDictionaryProvider provider) {
        return Data.importVectorSchemaRoot(allocator, null, schema, provider);
    }

    public static VectorSchemaRoot importVectorSchemaRoot(BufferAllocator allocator, ArrowArray array, ArrowSchema schema, CDataDictionaryProvider provider) {
        VectorSchemaRoot vsr = VectorSchemaRoot.create(Data.importSchema(allocator, schema, provider), allocator);
        if (array != null) {
            Data.importIntoVectorSchemaRoot(allocator, array, vsr, provider);
        }
        return vsr;
    }

    public static ArrowReader importArrayStream(BufferAllocator allocator, ArrowArrayStream stream) {
        return new ArrowArrayStreamReader(allocator, stream);
    }
}

