/*
 * Decompiled with CFR 0.152.
 */
package dev.vortex.relocated.org.apache.arrow.memory.util;

import dev.vortex.relocated.org.apache.arrow.memory.ArrowBuf;
import dev.vortex.relocated.org.apache.arrow.memory.BoundsChecking;
import dev.vortex.relocated.org.apache.arrow.memory.util.MemoryUtil;
import dev.vortex.relocated.org.apache.arrow.memory.util.hash.ArrowBufHasher;
import dev.vortex.relocated.org.apache.arrow.memory.util.hash.SimpleHasher;
import java.nio.ByteOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteFunctionHelpers {
    static final Logger logger = LoggerFactory.getLogger(ByteFunctionHelpers.class);
    private static final boolean LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;

    private ByteFunctionHelpers() {
    }

    public static int equal(ArrowBuf left, long lStart, long lEnd, ArrowBuf right, long rStart, long rEnd) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            left.checkBytes(lStart, lEnd);
            right.checkBytes(rStart, rEnd);
        }
        return ByteFunctionHelpers.memEqual(left.memoryAddress(), lStart, lEnd, right.memoryAddress(), rStart, rEnd);
    }

    private static int memEqual(long laddr, long lStart, long lEnd, long raddr, long rStart, long rEnd) {
        long n = lEnd - lStart;
        if (n == rEnd - rStart) {
            long lPos = laddr + lStart;
            long rPos = raddr + rStart;
            while (n > 63L) {
                for (int x = 0; x < 8; ++x) {
                    long rightLong;
                    long leftLong = MemoryUtil.getLong(lPos);
                    if (leftLong != (rightLong = MemoryUtil.getLong(rPos))) {
                        return 0;
                    }
                    lPos += 8L;
                    rPos += 8L;
                }
                n -= 64L;
            }
            while (n > 7L) {
                long rightLong;
                long leftLong = MemoryUtil.getLong(lPos);
                if (leftLong != (rightLong = MemoryUtil.getLong(rPos))) {
                    return 0;
                }
                lPos += 8L;
                rPos += 8L;
                n -= 8L;
            }
            if (n > 3L) {
                int rightInt;
                int leftInt = MemoryUtil.getInt(lPos);
                if (leftInt != (rightInt = MemoryUtil.getInt(rPos))) {
                    return 0;
                }
                lPos += 4L;
                rPos += 4L;
                n -= 4L;
            }
            while (n-- != 0L) {
                byte rightByte;
                byte leftByte = MemoryUtil.getByte(lPos);
                if (leftByte != (rightByte = MemoryUtil.getByte(rPos))) {
                    return 0;
                }
                ++lPos;
                ++rPos;
            }
            return 1;
        }
        return 0;
    }

    public static int compare(ArrowBuf left, long lStart, long lEnd, ArrowBuf right, long rStart, long rEnd) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            left.checkBytes(lStart, lEnd);
            right.checkBytes(rStart, rEnd);
        }
        return ByteFunctionHelpers.memcmp(left.memoryAddress(), lStart, lEnd, right.memoryAddress(), rStart, rEnd);
    }

    private static int memcmp(long laddr, long lStart, long lEnd, long raddr, long rStart, long rEnd) {
        long n;
        long lLen = lEnd - lStart;
        long rLen = rEnd - rStart;
        long lPos = laddr + lStart;
        long rPos = raddr + rStart;
        for (n = Math.min(rLen, lLen); n > 63L; n -= 64L) {
            for (int x = 0; x < 8; ++x) {
                long rightLong;
                long leftLong = MemoryUtil.getLong(lPos);
                if (leftLong != (rightLong = MemoryUtil.getLong(rPos))) {
                    if (LITTLE_ENDIAN) {
                        return ByteFunctionHelpers.unsignedLongCompare(Long.reverseBytes(leftLong), Long.reverseBytes(rightLong));
                    }
                    return ByteFunctionHelpers.unsignedLongCompare(leftLong, rightLong);
                }
                lPos += 8L;
                rPos += 8L;
            }
        }
        while (n > 7L) {
            long rightLong;
            long leftLong = MemoryUtil.getLong(lPos);
            if (leftLong != (rightLong = MemoryUtil.getLong(rPos))) {
                if (LITTLE_ENDIAN) {
                    return ByteFunctionHelpers.unsignedLongCompare(Long.reverseBytes(leftLong), Long.reverseBytes(rightLong));
                }
                return ByteFunctionHelpers.unsignedLongCompare(leftLong, rightLong);
            }
            lPos += 8L;
            rPos += 8L;
            n -= 8L;
        }
        if (n > 3L) {
            int rightInt;
            int leftInt = MemoryUtil.getInt(lPos);
            if (leftInt != (rightInt = MemoryUtil.getInt(rPos))) {
                if (LITTLE_ENDIAN) {
                    return ByteFunctionHelpers.unsignedIntCompare(Integer.reverseBytes(leftInt), Integer.reverseBytes(rightInt));
                }
                return ByteFunctionHelpers.unsignedIntCompare(leftInt, rightInt);
            }
            lPos += 4L;
            rPos += 4L;
            n -= 4L;
        }
        while (n-- != 0L) {
            byte rightByte;
            byte leftByte = MemoryUtil.getByte(lPos);
            if (leftByte != (rightByte = MemoryUtil.getByte(rPos))) {
                return (leftByte & 0xFF) - (rightByte & 0xFF) > 0 ? 1 : -1;
            }
            ++lPos;
            ++rPos;
        }
        if (lLen == rLen) {
            return 0;
        }
        return lLen > rLen ? 1 : -1;
    }

    public static int compare(ArrowBuf left, int lStart, int lEnd, byte[] right, int rStart, int rEnd) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            left.checkBytes(lStart, lEnd);
        }
        return ByteFunctionHelpers.memcmp(left.memoryAddress(), lStart, lEnd, right, rStart, rEnd);
    }

    public static int unsignedLongCompare(long a, long b) {
        return Long.compare(a ^ Long.MIN_VALUE, b ^ Long.MIN_VALUE);
    }

    public static int unsignedIntCompare(int a, int b) {
        return Integer.compare(a ^ Integer.MIN_VALUE, b ^ Integer.MIN_VALUE);
    }

    private static int memcmp(long laddr, int lStart, int lEnd, byte[] right, int rStart, int rEnd) {
        int n;
        int lLen = lEnd - lStart;
        int rLen = rEnd - rStart;
        long lPos = laddr + (long)lStart;
        int rPos = rStart;
        for (n = Math.min(rLen, lLen); n > 7; n -= 8) {
            long rightLong;
            long leftLong = MemoryUtil.getLong(lPos);
            if (leftLong != (rightLong = MemoryUtil.getLong(right, rPos))) {
                if (LITTLE_ENDIAN) {
                    return ByteFunctionHelpers.unsignedLongCompare(Long.reverseBytes(leftLong), Long.reverseBytes(rightLong));
                }
                return ByteFunctionHelpers.unsignedLongCompare(leftLong, rightLong);
            }
            lPos += 8L;
            rPos += 8;
        }
        if (n > 3) {
            int rightInt;
            int leftInt = MemoryUtil.getInt(lPos);
            if (leftInt != (rightInt = MemoryUtil.getInt(right, rPos))) {
                if (LITTLE_ENDIAN) {
                    return ByteFunctionHelpers.unsignedIntCompare(Integer.reverseBytes(leftInt), Integer.reverseBytes(rightInt));
                }
                return ByteFunctionHelpers.unsignedIntCompare(leftInt, rightInt);
            }
            lPos += 4L;
            rPos += 4;
            n -= 4;
        }
        while (n-- != 0) {
            byte rightByte;
            byte leftByte = MemoryUtil.getByte(lPos);
            if (leftByte != (rightByte = right[rPos])) {
                return (leftByte & 0xFF) - (rightByte & 0xFF) > 0 ? 1 : -1;
            }
            ++lPos;
            ++rPos;
        }
        if (lLen == rLen) {
            return 0;
        }
        return lLen > rLen ? 1 : -1;
    }

    public static int hash(ArrowBuf buf, long start, long end) {
        return ByteFunctionHelpers.hash(SimpleHasher.INSTANCE, buf, start, end);
    }

    public static final int hash(ArrowBufHasher hasher, ArrowBuf buf, long start, long end) {
        if (hasher == null) {
            hasher = SimpleHasher.INSTANCE;
        }
        return hasher.hashCode(buf, start, end - start);
    }

    public static int combineHash(int currentHash, int newHash) {
        return currentHash * 31 + newHash;
    }
}

