/*
 * Decompiled with CFR 0.152.
 */
package dev.vortex.relocated.org.apache.arrow.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.StreamSupport;

public final class AutoCloseables {
    private static final AutoCloseable noOpAutocloseable = new AutoCloseable(){

        @Override
        public void close() {
        }
    };

    private AutoCloseables() {
    }

    public static AutoCloseable all(final Collection<? extends AutoCloseable> autoCloseables) {
        return new AutoCloseable(){

            @Override
            public void close() throws Exception {
                AutoCloseables.close((Iterable<? extends AutoCloseable>)autoCloseables);
            }
        };
    }

    public static void close(Throwable t, AutoCloseable ... autoCloseables) {
        AutoCloseables.close(t, Arrays.asList(autoCloseables));
    }

    public static void close(Throwable t, Iterable<? extends AutoCloseable> autoCloseables) {
        try {
            AutoCloseables.close(autoCloseables);
        }
        catch (Exception e) {
            t.addSuppressed(e);
        }
    }

    public static void close(AutoCloseable ... autoCloseables) throws Exception {
        AutoCloseables.close(Arrays.asList(autoCloseables));
    }

    public static void close(Iterable<? extends AutoCloseable> ac) throws Exception {
        if (ac == null) {
            return;
        }
        if (ac instanceof AutoCloseable) {
            ((AutoCloseable)((Object)ac)).close();
            return;
        }
        Exception topLevelException = null;
        for (AutoCloseable autoCloseable : ac) {
            try {
                if (autoCloseable == null) continue;
                autoCloseable.close();
            }
            catch (Exception e) {
                if (topLevelException == null) {
                    topLevelException = e;
                    continue;
                }
                if (e == topLevelException) continue;
                topLevelException.addSuppressed(e);
            }
        }
        if (topLevelException != null) {
            throw topLevelException;
        }
    }

    @SafeVarargs
    public static void close(Iterable<? extends AutoCloseable> ... closeables) throws Exception {
        AutoCloseables.close(AutoCloseables.flatten(closeables));
    }

    @SafeVarargs
    private static Iterable<AutoCloseable> flatten(final Iterable<? extends AutoCloseable> ... closeables) {
        return new Iterable<AutoCloseable>(){

            @Override
            public Iterator<AutoCloseable> iterator() {
                return Arrays.stream(closeables).flatMap(i -> StreamSupport.stream(i.spliterator(), false)).iterator();
            }
        };
    }

    public static Iterable<AutoCloseable> iter(AutoCloseable ... ac) {
        if (ac.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<AutoCloseable> nonNullAc = new ArrayList<AutoCloseable>();
        for (AutoCloseable autoCloseable : ac) {
            if (autoCloseable == null) continue;
            nonNullAc.add(autoCloseable);
        }
        return nonNullAc;
    }

    public static RollbackCloseable rollbackable(AutoCloseable ... closeables) {
        return new RollbackCloseable(closeables);
    }

    public static void closeNoChecked(AutoCloseable autoCloseable) {
        if (autoCloseable != null) {
            try {
                autoCloseable.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Exception while closing: " + e.getMessage(), e);
            }
        }
    }

    public static AutoCloseable noop() {
        return noOpAutocloseable;
    }

    public static class RollbackCloseable
    implements AutoCloseable {
        private boolean commit = false;
        private List<AutoCloseable> closeables;

        public RollbackCloseable(AutoCloseable ... closeables) {
            this.closeables = new ArrayList<AutoCloseable>(Arrays.asList(closeables));
        }

        public <T extends AutoCloseable> T add(T t) {
            this.closeables.add(t);
            return t;
        }

        public void addAll(AutoCloseable ... list) {
            this.closeables.addAll(Arrays.asList(list));
        }

        public void addAll(Iterable<? extends AutoCloseable> list) {
            for (AutoCloseable autoCloseable : list) {
                this.closeables.add(autoCloseable);
            }
        }

        public void commit() {
            this.commit = true;
        }

        @Override
        public void close() throws Exception {
            if (!this.commit) {
                AutoCloseables.close(this.closeables);
            }
        }
    }
}

