/*
 * Decompiled with CFR 0.152.
 */
package dev.vortex.relocated.org.apache.arrow.vector;

import dev.vortex.relocated.org.apache.arrow.memory.ArrowBuf;
import dev.vortex.relocated.org.apache.arrow.memory.BufferAllocator;
import dev.vortex.relocated.org.apache.arrow.vector.BaseFixedWidthVector;
import dev.vortex.relocated.org.apache.arrow.vector.BitVectorHelper;
import dev.vortex.relocated.org.apache.arrow.vector.NullCheckingForGet;
import dev.vortex.relocated.org.apache.arrow.vector.types.pojo.Field;
import dev.vortex.relocated.org.apache.arrow.vector.types.pojo.FieldType;
import dev.vortex.relocated.org.apache.arrow.vector.util.TransferPair;

public abstract class TimeStampVector
extends BaseFixedWidthVector {
    public static final byte TYPE_WIDTH = 8;

    public TimeStampVector(String name, FieldType fieldType, BufferAllocator allocator) {
        this(new Field(name, fieldType, null), allocator);
    }

    public TimeStampVector(Field field, BufferAllocator allocator) {
        super(field, allocator, 8);
    }

    public long get(int index) throws IllegalStateException {
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            throw new IllegalStateException("Value at index is null");
        }
        return this.valueBuffer.getLong((long)index * 8L);
    }

    protected void setValue(int index, long value) {
        this.valueBuffer.setLong((long)index * 8L, value);
    }

    public void set(int index, long value) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void setSafe(int index, long value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void set(int index, int isSet, long value) {
        if (isSet > 0) {
            this.set(index, value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void setSafe(int index, int isSet, long value) {
        this.handleSafe(index);
        this.set(index, isSet, value);
    }

    public static long get(ArrowBuf buffer, int index) {
        return buffer.getLong((long)index * 8L);
    }

    public class TransferImpl
    implements TransferPair {
        TimeStampVector to;

        public TransferImpl(TimeStampVector to) {
            this.to = to;
        }

        @Override
        public TimeStampVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            TimeStampVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            TimeStampVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, TimeStampVector.this);
        }
    }
}

