/*
 * Decompiled with CFR 0.152.
 */
package dev.vortex.relocated.org.apache.arrow.vector;

import dev.vortex.relocated.org.apache.arrow.memory.BufferAllocator;
import dev.vortex.relocated.org.apache.arrow.util.AutoCloseables;
import dev.vortex.relocated.org.apache.arrow.util.Preconditions;
import dev.vortex.relocated.org.apache.arrow.vector.FieldVector;
import dev.vortex.relocated.org.apache.arrow.vector.Float4Vector;
import dev.vortex.relocated.org.apache.arrow.vector.Float8Vector;
import dev.vortex.relocated.org.apache.arrow.vector.ValueVector;
import dev.vortex.relocated.org.apache.arrow.vector.compare.ApproxEqualsVisitor;
import dev.vortex.relocated.org.apache.arrow.vector.compare.Range;
import dev.vortex.relocated.org.apache.arrow.vector.compare.VectorEqualsVisitor;
import dev.vortex.relocated.org.apache.arrow.vector.compare.VectorValueEqualizer;
import dev.vortex.relocated.org.apache.arrow.vector.compare.util.ValueEpsilonEqualizers;
import dev.vortex.relocated.org.apache.arrow.vector.types.pojo.Field;
import dev.vortex.relocated.org.apache.arrow.vector.types.pojo.Schema;
import dev.vortex.relocated.org.apache.arrow.vector.util.TransferPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class VectorSchemaRoot
implements AutoCloseable {
    private Schema schema;
    private int rowCount;
    private final List<FieldVector> fieldVectors;
    private final Map<Field, FieldVector> fieldVectorsMap = new LinkedHashMap<Field, FieldVector>();

    public VectorSchemaRoot(Iterable<FieldVector> vectors) {
        this(StreamSupport.stream(vectors.spliterator(), false).map(t -> t.getField()).collect(Collectors.toList()), StreamSupport.stream(vectors.spliterator(), false).collect(Collectors.toList()));
    }

    public VectorSchemaRoot(FieldVector parent) {
        this(parent.getField().getChildren(), parent.getChildrenFromFields(), parent.getValueCount());
    }

    public VectorSchemaRoot(List<Field> fields, List<FieldVector> fieldVectors) {
        this(new Schema(fields), fieldVectors, fieldVectors.size() == 0 ? 0 : fieldVectors.get(0).getValueCount());
    }

    public VectorSchemaRoot(List<Field> fields, List<FieldVector> fieldVectors, int rowCount) {
        this(new Schema(fields), fieldVectors, rowCount);
    }

    public VectorSchemaRoot(Schema schema, List<FieldVector> fieldVectors, int rowCount) {
        if (schema.getFields().size() != fieldVectors.size()) {
            throw new IllegalArgumentException("Fields must match field vectors. Found " + fieldVectors.size() + " vectors and " + schema.getFields().size() + " fields");
        }
        this.schema = schema;
        this.rowCount = rowCount;
        this.fieldVectors = fieldVectors;
        for (int i = 0; i < schema.getFields().size(); ++i) {
            Field field = schema.getFields().get(i);
            FieldVector vector = fieldVectors.get(i);
            this.fieldVectorsMap.put(field, vector);
        }
    }

    public static VectorSchemaRoot create(Schema schema, BufferAllocator allocator) {
        ArrayList<FieldVector> fieldVectors = new ArrayList<FieldVector>(schema.getFields().size());
        for (Field field : schema.getFields()) {
            FieldVector vector = field.createVector(allocator);
            fieldVectors.add(vector);
        }
        if (fieldVectors.size() != schema.getFields().size()) {
            throw new IllegalArgumentException("The root vector did not create the right number of children. found " + fieldVectors.size() + " expected " + schema.getFields().size());
        }
        return new VectorSchemaRoot(schema, fieldVectors, 0);
    }

    public static VectorSchemaRoot of(FieldVector ... vectors) {
        return new VectorSchemaRoot(Arrays.stream(vectors).collect(Collectors.toList()));
    }

    public void allocateNew() {
        for (FieldVector v : this.fieldVectors) {
            v.allocateNew();
        }
        this.rowCount = 0;
    }

    public void clear() {
        for (FieldVector v : this.fieldVectors) {
            v.clear();
        }
        this.rowCount = 0;
    }

    public List<FieldVector> getFieldVectors() {
        return Collections.unmodifiableList(this.fieldVectors);
    }

    public FieldVector getVector(String name) {
        for (Map.Entry<Field, FieldVector> entry : this.fieldVectorsMap.entrySet()) {
            if (!entry.getKey().getName().equals(name)) continue;
            return entry.getValue();
        }
        return null;
    }

    public FieldVector getVector(Field field) {
        return this.fieldVectorsMap.get(field);
    }

    public FieldVector getVector(int index) {
        Preconditions.checkArgument(index >= 0 && index < this.fieldVectors.size());
        return this.fieldVectors.get(index);
    }

    public VectorSchemaRoot addVector(int index, FieldVector vector) {
        Preconditions.checkNotNull(vector);
        Preconditions.checkArgument(index >= 0 && index < this.fieldVectors.size());
        ArrayList<FieldVector> newVectors = new ArrayList<FieldVector>();
        for (int i = 0; i < this.fieldVectors.size(); ++i) {
            if (i == index) {
                newVectors.add(vector);
            }
            newVectors.add(this.fieldVectors.get(i));
        }
        return new VectorSchemaRoot(newVectors);
    }

    public VectorSchemaRoot removeVector(int index) {
        Preconditions.checkArgument(index >= 0 && index < this.fieldVectors.size());
        ArrayList<FieldVector> newVectors = new ArrayList<FieldVector>();
        for (int i = 0; i < this.fieldVectors.size(); ++i) {
            if (i == index) continue;
            newVectors.add(this.fieldVectors.get(i));
        }
        return new VectorSchemaRoot(newVectors);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
        for (FieldVector v : this.fieldVectors) {
            v.setValueCount(rowCount);
        }
    }

    @Override
    public void close() {
        try {
            AutoCloseables.close(this.fieldVectors);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void printRow(StringBuilder sb, List<Object> row) {
        boolean first = true;
        for (Object v : row) {
            if (first) {
                first = false;
            } else {
                sb.append("\t");
            }
            sb.append(v);
        }
        sb.append("\n");
    }

    public String contentToTSVString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> row = new ArrayList<Object>(this.schema.getFields().size());
        for (Field field : this.schema.getFields()) {
            row.add(field.getName());
        }
        this.printRow(sb, row);
        for (int i = 0; i < this.rowCount; ++i) {
            row.clear();
            for (FieldVector v : this.fieldVectors) {
                row.add(v.getObject(i));
            }
            this.printRow(sb, row);
        }
        return sb.toString();
    }

    public boolean syncSchema() {
        List<Field> newFields;
        List<Field> oldFields = this.schema.getFields();
        if (!oldFields.equals(newFields = this.fieldVectors.stream().map(ValueVector::getField).collect(Collectors.toList()))) {
            this.schema = new Schema(newFields);
            return true;
        }
        return false;
    }

    public VectorSchemaRoot slice(int index) {
        return this.slice(index, this.rowCount - index);
    }

    public VectorSchemaRoot slice(int index, int length) {
        Preconditions.checkArgument(index >= 0, "expecting non-negative index");
        Preconditions.checkArgument(length >= 0, "expecting non-negative length");
        Preconditions.checkArgument(index + length <= this.rowCount, "index + length should <= rowCount");
        List<FieldVector> sliceVectors = this.fieldVectors.stream().map(v -> {
            TransferPair transferPair = v.getTransferPair(v.getAllocator());
            transferPair.splitAndTransfer(index, length);
            return (FieldVector)transferPair.getTo();
        }).collect(Collectors.toList());
        return new VectorSchemaRoot(sliceVectors);
    }

    public boolean equals(VectorSchemaRoot other) {
        if (other == null) {
            return false;
        }
        if (!this.schema.equals(other.schema)) {
            return false;
        }
        if (this.rowCount != other.rowCount) {
            return false;
        }
        for (int i = 0; i < this.fieldVectors.size(); ++i) {
            FieldVector otherVector;
            FieldVector vector = this.fieldVectors.get(i);
            if (VectorEqualsVisitor.vectorEquals(vector, otherVector = other.fieldVectors.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean approxEquals(VectorSchemaRoot other, VectorValueEqualizer<Float4Vector> floatDiffFunction, VectorValueEqualizer<Float8Vector> doubleDiffFunction) {
        Preconditions.checkNotNull(floatDiffFunction);
        Preconditions.checkNotNull(doubleDiffFunction);
        if (other == null) {
            return false;
        }
        if (!this.schema.equals(other.schema)) {
            return false;
        }
        if (this.rowCount != other.rowCount) {
            return false;
        }
        Range range = new Range(0, 0, 0);
        for (int i = 0; i < this.fieldVectors.size(); ++i) {
            FieldVector vector = this.fieldVectors.get(i);
            FieldVector otherVector = other.fieldVectors.get(i);
            if (vector.getValueCount() != otherVector.getValueCount()) {
                return false;
            }
            ApproxEqualsVisitor visitor = new ApproxEqualsVisitor((ValueVector)vector, (ValueVector)otherVector, floatDiffFunction, doubleDiffFunction);
            range.setLength(vector.getValueCount());
            if (visitor.rangeEquals(range)) continue;
            return false;
        }
        return true;
    }

    public boolean approxEquals(VectorSchemaRoot other) {
        ValueEpsilonEqualizers.Float4EpsilonEqualizer floatDiffFunction = new ValueEpsilonEqualizers.Float4EpsilonEqualizer(1.0E-6f);
        ValueEpsilonEqualizers.Float8EpsilonEqualizer doubleDiffFunction = new ValueEpsilonEqualizers.Float8EpsilonEqualizer(1.0E-6);
        return this.approxEquals(other, floatDiffFunction, doubleDiffFunction);
    }
}

