/*
 * Decompiled with CFR 0.152.
 */
package dev.vortex.relocated.org.apache.arrow.vector;

import dev.vortex.relocated.org.apache.arrow.memory.ArrowBuf;
import dev.vortex.relocated.org.apache.arrow.vector.BaseVariableWidthViewVector;
import dev.vortex.relocated.org.apache.arrow.vector.FieldVector;
import dev.vortex.relocated.org.apache.arrow.vector.TypeLayout;
import dev.vortex.relocated.org.apache.arrow.vector.VectorSchemaRoot;
import dev.vortex.relocated.org.apache.arrow.vector.compression.CompressionCodec;
import dev.vortex.relocated.org.apache.arrow.vector.compression.CompressionUtil;
import dev.vortex.relocated.org.apache.arrow.vector.compression.NoCompressionCodec;
import dev.vortex.relocated.org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import dev.vortex.relocated.org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import java.util.ArrayList;
import java.util.List;

public class VectorUnloader {
    private final VectorSchemaRoot root;
    private final boolean includeNullCount;
    private final CompressionCodec codec;
    private final boolean alignBuffers;

    public VectorUnloader(VectorSchemaRoot root) {
        this(root, true, NoCompressionCodec.INSTANCE, true);
    }

    public VectorUnloader(VectorSchemaRoot root, boolean includeNullCount, boolean alignBuffers) {
        this(root, includeNullCount, NoCompressionCodec.INSTANCE, alignBuffers);
    }

    public VectorUnloader(VectorSchemaRoot root, boolean includeNullCount, CompressionCodec codec, boolean alignBuffers) {
        this.root = root;
        this.includeNullCount = includeNullCount;
        this.codec = codec == null ? NoCompressionCodec.INSTANCE : codec;
        this.alignBuffers = alignBuffers;
    }

    public ArrowRecordBatch getRecordBatch() {
        ArrayList<ArrowFieldNode> nodes = new ArrayList<ArrowFieldNode>();
        ArrayList<ArrowBuf> buffers = new ArrayList<ArrowBuf>();
        ArrayList<Long> variadicBufferCounts = new ArrayList<Long>();
        for (FieldVector vector : this.root.getFieldVectors()) {
            this.appendNodes(vector, nodes, buffers, variadicBufferCounts);
        }
        return new ArrowRecordBatch(this.root.getRowCount(), nodes, buffers, CompressionUtil.createBodyCompression(this.codec), variadicBufferCounts, this.alignBuffers, false);
    }

    private long getVariadicBufferCount(FieldVector vector) {
        if (vector instanceof BaseVariableWidthViewVector) {
            return ((BaseVariableWidthViewVector)vector).getDataBuffers().size();
        }
        return 0L;
    }

    private void appendNodes(FieldVector vector, List<ArrowFieldNode> nodes, List<ArrowBuf> buffers, List<Long> variadicBufferCounts) {
        nodes.add(new ArrowFieldNode(vector.getValueCount(), this.includeNullCount ? (long)vector.getNullCount() : -1L));
        List<ArrowBuf> fieldBuffers = vector.getFieldBuffers();
        long variadicBufferCount = this.getVariadicBufferCount(vector);
        int expectedBufferCount = (int)((long)TypeLayout.getTypeBufferCount(vector.getField().getType()) + variadicBufferCount);
        if (vector instanceof BaseVariableWidthViewVector) {
            variadicBufferCounts.add(variadicBufferCount);
        }
        if (fieldBuffers.size() != expectedBufferCount) {
            throw new IllegalArgumentException(String.format("wrong number of buffers for field %s in vector %s. found: %s", vector.getField(), vector.getClass().getSimpleName(), fieldBuffers));
        }
        for (ArrowBuf buf : fieldBuffers) {
            buf.getReferenceManager().retain();
            buffers.add(this.codec.compress(vector.getAllocator(), buf));
        }
        for (FieldVector child : vector.getChildrenFromFields()) {
            this.appendNodes(child, nodes, buffers, variadicBufferCounts);
        }
    }
}

