/*
 * Decompiled with CFR 0.152.
 */
package dev.vortex.relocated.org.apache.arrow.vector.complex;

import dev.vortex.relocated.org.apache.arrow.memory.ArrowBuf;
import dev.vortex.relocated.org.apache.arrow.memory.BufferAllocator;
import dev.vortex.relocated.org.apache.arrow.memory.util.CommonUtil;
import dev.vortex.relocated.org.apache.arrow.memory.util.LargeMemoryUtil;
import dev.vortex.relocated.org.apache.arrow.util.Preconditions;
import dev.vortex.relocated.org.apache.arrow.vector.AddOrGetResult;
import dev.vortex.relocated.org.apache.arrow.vector.BaseFixedWidthVector;
import dev.vortex.relocated.org.apache.arrow.vector.BaseValueVector;
import dev.vortex.relocated.org.apache.arrow.vector.BaseVariableWidthVector;
import dev.vortex.relocated.org.apache.arrow.vector.DensityAwareVector;
import dev.vortex.relocated.org.apache.arrow.vector.FieldVector;
import dev.vortex.relocated.org.apache.arrow.vector.NullVector;
import dev.vortex.relocated.org.apache.arrow.vector.UInt4Vector;
import dev.vortex.relocated.org.apache.arrow.vector.ValueVector;
import dev.vortex.relocated.org.apache.arrow.vector.ZeroVector;
import dev.vortex.relocated.org.apache.arrow.vector.complex.BaseListVector;
import dev.vortex.relocated.org.apache.arrow.vector.complex.RepeatedValueVector;
import dev.vortex.relocated.org.apache.arrow.vector.types.pojo.ArrowType;
import dev.vortex.relocated.org.apache.arrow.vector.types.pojo.FieldType;
import dev.vortex.relocated.org.apache.arrow.vector.util.CallBack;
import dev.vortex.relocated.org.apache.arrow.vector.util.OversizedAllocationException;
import dev.vortex.relocated.org.apache.arrow.vector.util.SchemaChangeRuntimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;

public abstract class BaseRepeatedValueVector
extends BaseValueVector
implements RepeatedValueVector,
BaseListVector {
    public static final FieldVector DEFAULT_DATA_VECTOR = ZeroVector.INSTANCE;
    public static final String DATA_VECTOR_NAME = "$data$";
    public static final byte OFFSET_WIDTH = 4;
    protected ArrowBuf offsetBuffer;
    protected FieldVector vector;
    protected final CallBack repeatedCallBack;
    protected int valueCount;
    protected long offsetAllocationSizeInBytes = 15880L;
    private final String name;
    protected String defaultDataVectorName = "$data$";

    protected BaseRepeatedValueVector(String name, BufferAllocator allocator, CallBack callBack) {
        this(name, allocator, DEFAULT_DATA_VECTOR, callBack);
    }

    protected BaseRepeatedValueVector(String name, BufferAllocator allocator, FieldVector vector, CallBack callBack) {
        super(allocator);
        this.name = name;
        this.offsetBuffer = allocator.getEmpty();
        this.vector = Preconditions.checkNotNull(vector, "data vector cannot be null");
        this.repeatedCallBack = callBack;
        this.valueCount = 0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allocateNewSafe() {
        boolean dataAlloc = false;
        try {
            this.offsetBuffer = this.allocateOffsetBuffer(this.offsetAllocationSizeInBytes);
            dataAlloc = this.vector.allocateNewSafe();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.clear();
            boolean bl = false;
            return bl;
        }
        finally {
            if (!dataAlloc) {
                this.clear();
            }
        }
        return dataAlloc;
    }

    protected ArrowBuf allocateOffsetBuffer(long size) {
        int curSize = (int)size;
        ArrowBuf offsetBuffer = this.allocator.buffer(curSize);
        offsetBuffer.readerIndex(0L);
        this.offsetAllocationSizeInBytes = curSize;
        offsetBuffer.setZero(0L, offsetBuffer.capacity());
        return offsetBuffer;
    }

    @Override
    public void reAlloc() {
        this.reallocOffsetBuffer();
        this.vector.reAlloc();
    }

    protected void reallocOffsetBuffer() {
        long currentBufferCapacity = this.offsetBuffer.capacity();
        long newAllocationSize = currentBufferCapacity * 2L;
        if (newAllocationSize == 0L) {
            newAllocationSize = this.offsetAllocationSizeInBytes > 0L ? this.offsetAllocationSizeInBytes : 31760L;
        }
        newAllocationSize = CommonUtil.nextPowerOfTwo(newAllocationSize);
        newAllocationSize = Math.min(newAllocationSize, 0x1FFFFFFFCL);
        assert (newAllocationSize >= 1L);
        if (newAllocationSize > MAX_ALLOCATION_SIZE || newAllocationSize <= this.offsetBuffer.capacity()) {
            throw new OversizedAllocationException("Unable to expand the buffer");
        }
        ArrowBuf newBuf = this.allocator.buffer(newAllocationSize);
        newBuf.setBytes(0L, this.offsetBuffer, 0L, currentBufferCapacity);
        newBuf.setZero(currentBufferCapacity, newBuf.capacity() - currentBufferCapacity);
        this.offsetBuffer.getReferenceManager().release(1);
        this.offsetBuffer = newBuf;
        this.offsetAllocationSizeInBytes = newAllocationSize;
    }

    @Override
    @Deprecated
    public UInt4Vector getOffsetVector() {
        throw new UnsupportedOperationException("There is no inner offset vector");
    }

    @Override
    public FieldVector getDataVector() {
        return this.vector;
    }

    @Override
    public void setInitialCapacity(int numRecords) {
        this.offsetAllocationSizeInBytes = ((long)numRecords + 1L) * 4L;
        if (this.vector instanceof BaseFixedWidthVector || this.vector instanceof BaseVariableWidthVector) {
            this.vector.setInitialCapacity(numRecords * 5);
        } else {
            this.vector.setInitialCapacity(numRecords);
        }
    }

    @Override
    public void setInitialCapacity(int numRecords, double density) {
        if ((double)numRecords * density >= 2.147483647E9) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed");
        }
        this.offsetAllocationSizeInBytes = ((long)numRecords + 1L) * 4L;
        int innerValueCapacity = Math.max((int)((double)numRecords * density), 1);
        if (this.vector instanceof DensityAwareVector) {
            ((DensityAwareVector)((Object)this.vector)).setInitialCapacity(innerValueCapacity, density);
        } else {
            this.vector.setInitialCapacity(innerValueCapacity);
        }
    }

    public void setInitialTotalCapacity(int numRecords, int totalNumberOfElements) {
        this.offsetAllocationSizeInBytes = ((long)numRecords + 1L) * 4L;
        this.vector.setInitialCapacity(totalNumberOfElements);
    }

    @Override
    public int getValueCapacity() {
        int offsetValueCapacity = Math.max(this.getOffsetBufferValueCapacity() - 1, 0);
        if (this.vector == DEFAULT_DATA_VECTOR) {
            return offsetValueCapacity;
        }
        return Math.min(this.vector.getValueCapacity(), offsetValueCapacity);
    }

    protected int getOffsetBufferValueCapacity() {
        return LargeMemoryUtil.capAtMaxInt(this.offsetBuffer.capacity() / 4L);
    }

    @Override
    public int getBufferSize() {
        if (this.valueCount == 0) {
            return 0;
        }
        return (this.valueCount + 1) * 4 + this.vector.getBufferSize();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        int innerVectorValueCount = this.offsetBuffer.getInt(valueCount * 4);
        return (valueCount + 1) * 4 + this.vector.getBufferSizeFor(innerVectorValueCount);
    }

    @Override
    public Iterator<ValueVector> iterator() {
        return Collections.singleton(this.getDataVector()).iterator();
    }

    @Override
    public void clear() {
        this.offsetBuffer = this.releaseBuffer(this.offsetBuffer);
        this.vector.clear();
        this.valueCount = 0;
        super.clear();
    }

    @Override
    public void reset() {
        this.offsetBuffer.setZero(0L, this.offsetBuffer.capacity());
        this.vector.reset();
        this.valueCount = 0;
    }

    @Override
    public ArrowBuf[] getBuffers(boolean clear) {
        ArrowBuf[] buffers;
        if (this.getBufferSize() == 0) {
            buffers = new ArrowBuf[]{};
        } else {
            ArrayList<ArrowBuf> list = new ArrayList<ArrowBuf>();
            list.add(this.offsetBuffer);
            list.addAll(Arrays.asList(this.vector.getBuffers(false)));
            buffers = list.toArray(new ArrowBuf[list.size()]);
        }
        if (clear) {
            for (ArrowBuf buffer : buffers) {
                buffer.getReferenceManager().retain();
            }
            this.clear();
        }
        return buffers;
    }

    public int size() {
        return this.vector == DEFAULT_DATA_VECTOR ? 0 : 1;
    }

    public <T extends ValueVector> AddOrGetResult<T> addOrGetVector(FieldType fieldType) {
        boolean created = false;
        if (this.vector instanceof NullVector) {
            this.vector = fieldType.createNewSingleVector(this.defaultDataVectorName, this.allocator, this.repeatedCallBack);
            created = true;
            if (this.repeatedCallBack != null && fieldType.getType().getTypeID() != ArrowType.ArrowTypeID.Null) {
                this.repeatedCallBack.doWork();
            }
        }
        if (this.vector.getField().getType().getTypeID() != fieldType.getType().getTypeID()) {
            String msg = String.format("Inner vector type mismatch. Requested type: [%s], actual type: [%s]", new Object[]{fieldType.getType().getTypeID(), this.vector.getField().getType().getTypeID()});
            throw new SchemaChangeRuntimeException(msg);
        }
        return new AddOrGetResult<FieldVector>(this.vector, created);
    }

    protected void replaceDataVector(FieldVector v) {
        this.vector.clear();
        this.vector = v;
    }

    @Override
    public int getValueCount() {
        return this.valueCount;
    }

    public int getInnerValueCount() {
        return this.vector.getValueCount();
    }

    public int getInnerValueCountAt(int index) {
        return this.offsetBuffer.getInt((index + 1) * 4) - this.offsetBuffer.getInt(index * 4);
    }

    public abstract boolean isEmpty(int var1);

    public int startNewValue(int index) {
        while (index >= this.getOffsetBufferValueCapacity()) {
            this.reallocOffsetBuffer();
        }
        int offset = this.offsetBuffer.getInt(index * 4);
        this.offsetBuffer.setInt((index + 1) * 4, offset);
        this.setValueCount(index + 1);
        return offset;
    }

    @Override
    public void setValueCount(int valueCount) {
        this.valueCount = valueCount;
        while (valueCount > this.getOffsetBufferValueCapacity()) {
            this.reallocOffsetBuffer();
        }
        int childValueCount = valueCount == 0 ? 0 : this.offsetBuffer.getInt(valueCount * 4);
        this.vector.setValueCount(childValueCount);
    }
}

