/*
 * Decompiled with CFR 0.152.
 */
package dev.vortex.relocated.org.apache.arrow.vector.complex.impl;

import dev.vortex.relocated.org.apache.arrow.vector.complex.impl.AbstractFieldReader;
import dev.vortex.relocated.org.apache.arrow.vector.complex.writer.DecimalWriter;
import dev.vortex.relocated.org.apache.arrow.vector.holders.DecimalHolder;
import dev.vortex.relocated.org.apache.arrow.vector.holders.NullableDecimalHolder;
import dev.vortex.relocated.org.apache.arrow.vector.types.Types;
import java.math.BigDecimal;
import java.math.BigInteger;

public class DecimalHolderReaderImpl
extends AbstractFieldReader {
    private DecimalHolder holder;

    public DecimalHolderReaderImpl(DecimalHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.DECIMAL;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(DecimalHolder h) {
        h.start = this.holder.start;
        h.buffer = this.holder.buffer;
        h.scale = this.holder.scale;
        h.precision = this.holder.precision;
    }

    @Override
    public void read(NullableDecimalHolder h) {
        h.start = this.holder.start;
        h.buffer = this.holder.buffer;
        h.scale = this.holder.scale;
        h.precision = this.holder.precision;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public BigDecimal readBigDecimal() {
        byte[] bytes = new byte[16];
        this.holder.buffer.getBytes(this.holder.start, bytes, 0, 16);
        BigDecimal value = new BigDecimal(new BigInteger(bytes), this.holder.scale);
        return value;
    }

    @Override
    public Object readObject() {
        return this.readBigDecimal();
    }

    @Override
    public void copyAsValue(DecimalWriter writer) {
        writer.write(this.holder);
    }
}

