/*
 * Decompiled with CFR 0.152.
 */
package dev.vortex.relocated.org.apache.arrow.vector.complex.impl;

import dev.vortex.relocated.org.apache.arrow.vector.PeriodDuration;
import dev.vortex.relocated.org.apache.arrow.vector.complex.impl.AbstractFieldReader;
import dev.vortex.relocated.org.apache.arrow.vector.complex.writer.IntervalMonthDayNanoWriter;
import dev.vortex.relocated.org.apache.arrow.vector.holders.IntervalMonthDayNanoHolder;
import dev.vortex.relocated.org.apache.arrow.vector.holders.NullableIntervalMonthDayNanoHolder;
import dev.vortex.relocated.org.apache.arrow.vector.types.Types;
import java.time.Duration;
import java.time.Period;

public class IntervalMonthDayNanoHolderReaderImpl
extends AbstractFieldReader {
    private IntervalMonthDayNanoHolder holder;

    public IntervalMonthDayNanoHolderReaderImpl(IntervalMonthDayNanoHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.INTERVALMONTHDAYNANO;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(IntervalMonthDayNanoHolder h) {
        h.months = this.holder.months;
        h.days = this.holder.days;
        h.nanoseconds = this.holder.nanoseconds;
    }

    @Override
    public void read(NullableIntervalMonthDayNanoHolder h) {
        h.months = this.holder.months;
        h.days = this.holder.days;
        h.nanoseconds = this.holder.nanoseconds;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public PeriodDuration readPeriodDuration() {
        return new PeriodDuration(Period.ofMonths(this.holder.months).plusDays(this.holder.days), Duration.ofNanos(this.holder.nanoseconds));
    }

    @Override
    public Object readObject() {
        return this.readPeriodDuration();
    }

    @Override
    public void copyAsValue(IntervalMonthDayNanoWriter writer) {
        writer.write(this.holder);
    }
}

