/*
 * Decompiled with CFR 0.152.
 */
package dev.vortex.relocated.org.apache.arrow.vector.complex.impl;

import dev.vortex.relocated.org.apache.arrow.vector.FieldVector;
import dev.vortex.relocated.org.apache.arrow.vector.complex.NonNullableStructVector;
import dev.vortex.relocated.org.apache.arrow.vector.complex.impl.AbstractFieldReader;
import dev.vortex.relocated.org.apache.arrow.vector.complex.impl.NullReader;
import dev.vortex.relocated.org.apache.arrow.vector.complex.impl.SingleStructWriter;
import dev.vortex.relocated.org.apache.arrow.vector.complex.reader.FieldReader;
import dev.vortex.relocated.org.apache.arrow.vector.complex.writer.BaseWriter;
import dev.vortex.relocated.org.apache.arrow.vector.types.Types;
import dev.vortex.relocated.org.apache.arrow.vector.types.pojo.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SingleStructReaderImpl
extends AbstractFieldReader {
    private final NonNullableStructVector vector;
    private final Map<String, FieldReader> fields = new HashMap<String, FieldReader>();

    public SingleStructReaderImpl(NonNullableStructVector vector) {
        this.vector = vector;
    }

    private void setChildrenPosition(int index) {
        for (FieldReader r : this.fields.values()) {
            r.setPosition(index);
        }
    }

    @Override
    public Field getField() {
        return this.vector.getField();
    }

    @Override
    public FieldReader reader(String name) {
        FieldReader reader = this.fields.get(name);
        if (reader == null) {
            FieldVector child = this.vector.getChild(name);
            reader = child == null ? NullReader.INSTANCE : child.getReader();
            this.fields.put(name, reader);
            reader.setPosition(this.idx());
        }
        return reader;
    }

    @Override
    public void setPosition(int index) {
        super.setPosition(index);
        for (FieldReader r : this.fields.values()) {
            r.setPosition(index);
        }
    }

    @Override
    public Object readObject() {
        return this.vector.getObject(this.idx());
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.STRUCT;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public Iterator<String> iterator() {
        return this.vector.fieldNameIterator();
    }

    @Override
    public void copyAsValue(BaseWriter.StructWriter writer) {
        SingleStructWriter impl = (SingleStructWriter)writer;
        impl.container.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.StructWriter writer) {
        SingleStructWriter impl = (SingleStructWriter)writer.struct(name);
        impl.container.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }
}

