/*
 * Decompiled with CFR 0.152.
 */
package dev.vortex.relocated.org.apache.arrow.vector.dictionary;

import dev.vortex.relocated.org.apache.arrow.memory.BufferAllocator;
import dev.vortex.relocated.org.apache.arrow.memory.util.hash.ArrowBufHasher;
import dev.vortex.relocated.org.apache.arrow.memory.util.hash.SimpleHasher;
import dev.vortex.relocated.org.apache.arrow.util.AutoCloseables;
import dev.vortex.relocated.org.apache.arrow.vector.BaseIntVector;
import dev.vortex.relocated.org.apache.arrow.vector.FieldVector;
import dev.vortex.relocated.org.apache.arrow.vector.complex.BaseListVector;
import dev.vortex.relocated.org.apache.arrow.vector.dictionary.Dictionary;
import dev.vortex.relocated.org.apache.arrow.vector.dictionary.DictionaryEncoder;
import dev.vortex.relocated.org.apache.arrow.vector.dictionary.DictionaryHashTable;
import dev.vortex.relocated.org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import dev.vortex.relocated.org.apache.arrow.vector.types.pojo.Field;
import dev.vortex.relocated.org.apache.arrow.vector.types.pojo.FieldType;
import dev.vortex.relocated.org.apache.arrow.vector.util.TransferPair;
import java.util.Collections;

public class ListSubfieldEncoder {
    private final DictionaryHashTable hashTable;
    private final Dictionary dictionary;
    private final BufferAllocator allocator;

    public ListSubfieldEncoder(Dictionary dictionary, BufferAllocator allocator) {
        this(dictionary, allocator, SimpleHasher.INSTANCE);
    }

    public ListSubfieldEncoder(Dictionary dictionary, BufferAllocator allocator, ArrowBufHasher hasher) {
        this.dictionary = dictionary;
        this.allocator = allocator;
        BaseListVector dictVector = (BaseListVector)dictionary.getVector();
        this.hashTable = new DictionaryHashTable(ListSubfieldEncoder.getDataVector(dictVector), hasher);
    }

    private static FieldVector getDataVector(BaseListVector vector) {
        return vector.getChildrenFromFields().get(0);
    }

    private static BaseListVector cloneVector(BaseListVector vector, BufferAllocator allocator) {
        FieldType fieldType = vector.getField().getFieldType();
        BaseListVector cloned = (BaseListVector)fieldType.createNewSingleVector(vector.getField().getName(), allocator, null);
        ArrowFieldNode fieldNode = new ArrowFieldNode(vector.getValueCount(), vector.getNullCount());
        cloned.loadFieldBuffers(fieldNode, vector.getFieldBuffers());
        return cloned;
    }

    public BaseListVector encodeListSubField(BaseListVector vector) {
        int valueCount = vector.getValueCount();
        FieldType indexFieldType = new FieldType(vector.getField().isNullable(), this.dictionary.getEncoding().getIndexType(), this.dictionary.getEncoding(), vector.getField().getMetadata());
        Field valueField = new Field(vector.getField().getName(), indexFieldType, null);
        BaseListVector encoded = ListSubfieldEncoder.cloneVector(vector, this.allocator);
        try {
            encoded.initializeChildrenFromFields(Collections.singletonList(valueField));
            BaseIntVector indices = (BaseIntVector)ListSubfieldEncoder.getDataVector(encoded);
            FieldVector dataVector = ListSubfieldEncoder.getDataVector(vector);
            for (int i = 0; i < valueCount; ++i) {
                if (vector.isNull(i)) continue;
                int start = vector.getElementStartIndex(i);
                int end = vector.getElementEndIndex(i);
                DictionaryEncoder.buildIndexVector(dataVector, indices, this.hashTable, start, end);
            }
            return encoded;
        }
        catch (Exception e) {
            AutoCloseables.close((Throwable)e, (Iterable<? extends AutoCloseable>)encoded);
            throw e;
        }
    }

    public BaseListVector decodeListSubField(BaseListVector vector) {
        return ListSubfieldEncoder.decodeListSubField(vector, this.dictionary, this.allocator);
    }

    public static BaseListVector decodeListSubField(BaseListVector vector, Dictionary dictionary, BufferAllocator allocator) {
        int valueCount = vector.getValueCount();
        BaseListVector dictionaryVector = (BaseListVector)dictionary.getVector();
        int dictionaryValueCount = ListSubfieldEncoder.getDataVector(dictionaryVector).getValueCount();
        BaseListVector decoded = ListSubfieldEncoder.cloneVector(vector, allocator);
        try {
            Field dataVectorField = ListSubfieldEncoder.getDataVector(dictionaryVector).getField();
            decoded.initializeChildrenFromFields(Collections.singletonList(dataVectorField));
            FieldVector dataVector = ListSubfieldEncoder.getDataVector(decoded);
            TransferPair transfer = ListSubfieldEncoder.getDataVector(dictionaryVector).makeTransferPair(dataVector);
            BaseIntVector indices = (BaseIntVector)ListSubfieldEncoder.getDataVector(vector);
            for (int i = 0; i < valueCount; ++i) {
                if (vector.isNull(i)) continue;
                int start = vector.getElementStartIndex(i);
                int end = vector.getElementEndIndex(i);
                DictionaryEncoder.retrieveIndexVector(indices, transfer, dictionaryValueCount, start, end);
            }
            return decoded;
        }
        catch (Exception e) {
            AutoCloseables.close((Throwable)e, (Iterable<? extends AutoCloseable>)decoded);
            throw e;
        }
    }
}

