/*
 * Decompiled with CFR 0.152.
 */
package dev.vortex.relocated.org.apache.arrow.vector.validate;

import dev.vortex.relocated.org.apache.arrow.memory.ArrowBuf;
import dev.vortex.relocated.org.apache.arrow.vector.BaseFixedWidthVector;
import dev.vortex.relocated.org.apache.arrow.vector.BaseLargeVariableWidthVector;
import dev.vortex.relocated.org.apache.arrow.vector.BaseVariableWidthVector;
import dev.vortex.relocated.org.apache.arrow.vector.BaseVariableWidthViewVector;
import dev.vortex.relocated.org.apache.arrow.vector.ExtensionTypeVector;
import dev.vortex.relocated.org.apache.arrow.vector.FieldVector;
import dev.vortex.relocated.org.apache.arrow.vector.NullVector;
import dev.vortex.relocated.org.apache.arrow.vector.compare.VectorVisitor;
import dev.vortex.relocated.org.apache.arrow.vector.complex.DenseUnionVector;
import dev.vortex.relocated.org.apache.arrow.vector.complex.FixedSizeListVector;
import dev.vortex.relocated.org.apache.arrow.vector.complex.LargeListVector;
import dev.vortex.relocated.org.apache.arrow.vector.complex.ListVector;
import dev.vortex.relocated.org.apache.arrow.vector.complex.NonNullableStructVector;
import dev.vortex.relocated.org.apache.arrow.vector.complex.UnionVector;
import dev.vortex.relocated.org.apache.arrow.vector.types.pojo.Field;
import java.util.List;

public class ValidateVectorVisitor
implements VectorVisitor<Void, Void> {
    @Override
    public Void visit(BaseFixedWidthVector vector, Void value) {
        if (vector.getValueCount() > 0 && (vector.getDataBuffer() == null || vector.getDataBuffer().capacity() == 0L)) {
            throw new IllegalArgumentException("valueBuffer is null or capacity is 0");
        }
        return null;
    }

    @Override
    public Void visit(BaseVariableWidthVector vector, Void value) {
        if (vector.getValueCount() > 0) {
            if (vector.getDataBuffer() == null || vector.getDataBuffer().capacity() == 0L) {
                throw new IllegalArgumentException("valueBuffer is null or capacity is 0");
            }
            ArrowBuf offsetBuf = vector.getOffsetBuffer();
            int minBufferSize = (vector.getValueCount() + 1) * 4;
            if (offsetBuf.capacity() < (long)minBufferSize) {
                throw new IllegalArgumentException(String.format("offsetBuffer too small in vector of type %s and valueCount %s : expected at least %s byte(s), got %s", vector.getField().getType().toString(), vector.getValueCount(), minBufferSize, offsetBuf.capacity()));
            }
            int firstOffset = vector.getOffsetBuffer().getInt(0L);
            int lastOffset = vector.getOffsetBuffer().getInt(vector.getValueCount() * 4);
            if (firstOffset < 0 || lastOffset < 0) {
                throw new IllegalArgumentException("Negative offsets in vector");
            }
            int dataExtent = lastOffset - firstOffset;
            if (dataExtent > 0 && vector.getDataBuffer().capacity() == 0L) {
                throw new IllegalArgumentException("dataBuffer capacity is 0");
            }
            if ((long)dataExtent > vector.getDataBuffer().capacity()) {
                throw new IllegalArgumentException(String.format("Length spanned by offsets %s larger than dataBuffer capacity %s", dataExtent, vector.getValueCount()));
            }
        }
        return null;
    }

    @Override
    public Void visit(BaseLargeVariableWidthVector left, Void value) {
        return null;
    }

    @Override
    public Void visit(BaseVariableWidthViewVector left, Void value) {
        throw new UnsupportedOperationException("View vectors are not supported.");
    }

    @Override
    public Void visit(ListVector vector, Void value) {
        FieldVector dataVector = vector.getDataVector();
        if (vector.getValueCount() > 0) {
            ArrowBuf offsetBuf = vector.getOffsetBuffer();
            int minBufferSize = (vector.getValueCount() + 1) * 4;
            if (offsetBuf.capacity() < (long)minBufferSize) {
                throw new IllegalArgumentException(String.format("offsetBuffer too small in vector of type %s and valueCount %s : expected at least %s byte(s), got %s", vector.getField().getType().toString(), vector.getValueCount(), minBufferSize, offsetBuf.capacity()));
            }
            int firstOffset = vector.getOffsetBuffer().getInt(0L);
            int lastOffset = vector.getOffsetBuffer().getInt(vector.getValueCount() * 4);
            if (firstOffset < 0 || lastOffset < 0) {
                throw new IllegalArgumentException("Negative offsets in list vector");
            }
            int dataExtent = lastOffset - firstOffset;
            if (dataExtent > 0 && (dataVector.getDataBuffer() == null || dataVector.getDataBuffer().capacity() == 0L)) {
                throw new IllegalArgumentException("valueBuffer is null or capacity is 0");
            }
            if (dataExtent > dataVector.getValueCount()) {
                throw new IllegalArgumentException(String.format("Length spanned by list offsets (%s) larger than data vector valueCount (length %s)", dataExtent, dataVector.getValueCount()));
            }
        }
        return dataVector.accept(this, null);
    }

    @Override
    public Void visit(LargeListVector vector, Void value) {
        FieldVector dataVector = vector.getDataVector();
        if (vector.getValueCount() > 0) {
            ArrowBuf offsetBuf = vector.getOffsetBuffer();
            long minBufferSize = (vector.getValueCount() + 1) * 8;
            if (offsetBuf.capacity() < minBufferSize) {
                throw new IllegalArgumentException(String.format("offsetBuffer too small in vector of type %s and valueCount %s : expected at least %s byte(s), got %s", vector.getField().getType().toString(), vector.getValueCount(), minBufferSize, offsetBuf.capacity()));
            }
            long firstOffset = vector.getOffsetBuffer().getLong(0L);
            long lastOffset = vector.getOffsetBuffer().getLong(vector.getValueCount() * 8);
            if (firstOffset < 0L || lastOffset < 0L) {
                throw new IllegalArgumentException("Negative offsets in list vector");
            }
            long dataExtent = lastOffset - firstOffset;
            if (dataExtent > 0L && (dataVector.getDataBuffer() == null || dataVector.getDataBuffer().capacity() == 0L)) {
                throw new IllegalArgumentException("valueBuffer is null or capacity is 0");
            }
            if (dataExtent > (long)dataVector.getValueCount()) {
                throw new IllegalArgumentException(String.format("Length spanned by list offsets (%s) larger than data vector valueCount (length %s)", dataExtent, dataVector.getValueCount()));
            }
        }
        return dataVector.accept(this, null);
    }

    @Override
    public Void visit(FixedSizeListVector vector, Void value) {
        FieldVector dataVector = vector.getDataVector();
        int valueCount = vector.getValueCount();
        int listSize = vector.getListSize();
        if (valueCount > 0 && (dataVector.getDataBuffer() == null || dataVector.getDataBuffer().capacity() == 0L)) {
            throw new IllegalArgumentException("valueBuffer is null or capacity is 0");
        }
        if (valueCount * listSize != dataVector.getValueCount()) {
            throw new IllegalArgumentException(String.format("data vector valueCount invalid, expect %s, actual is: %s", valueCount * listSize, dataVector.getValueCount()));
        }
        return null;
    }

    @Override
    public Void visit(NonNullableStructVector vector, Void value) {
        List<Field> childFields = vector.getField().getChildren();
        int valueCount = vector.getValueCount();
        for (int i = 0; i < childFields.size(); ++i) {
            FieldVector child = vector.getChildrenFromFields().get(i);
            if (child.getValueCount() != valueCount) {
                throw new IllegalArgumentException(String.format("struct child vector #%s valueCount is not equals with struct vector, expect %s, actual %s", i, vector.getValueCount(), child.getValueCount()));
            }
            if (!childFields.get(i).getType().equals(child.getField().getType())) {
                throw new IllegalArgumentException(String.format("struct child vector #%s does not match type: %s vs %s", i, childFields.get(i).getType().toString(), child.getField().getType().toString()));
            }
            child.accept(this, null);
        }
        return null;
    }

    @Override
    public Void visit(UnionVector vector, Void value) {
        List<Field> childFields = vector.getField().getChildren();
        int valueCount = vector.getValueCount();
        for (int i = 0; i < childFields.size(); ++i) {
            FieldVector child = vector.getChildrenFromFields().get(i);
            if (child.getValueCount() != valueCount) {
                throw new IllegalArgumentException(String.format("union child vector #%s valueCount is not equals with union vector, expect %s, actual %s", i, vector.getValueCount(), child.getValueCount()));
            }
            if (!childFields.get(i).getType().equals(child.getField().getType())) {
                throw new IllegalArgumentException(String.format("union child vector #%s does not match type: %s vs %s", i, childFields.get(i).getType().toString(), child.getField().getType().toString()));
            }
            child.accept(this, null);
        }
        return null;
    }

    @Override
    public Void visit(DenseUnionVector vector, Void value) {
        List<Field> childFields = vector.getField().getChildren();
        for (int i = 0; i < childFields.size(); ++i) {
            FieldVector child = vector.getChildrenFromFields().get(i);
            if (!childFields.get(i).getType().equals(child.getField().getType())) {
                throw new IllegalArgumentException(String.format("union child vector #%s does not match type: %s vs %s", i, childFields.get(i).getType().toString(), child.getField().getType().toString()));
            }
            child.accept(this, null);
        }
        return null;
    }

    @Override
    public Void visit(NullVector vector, Void value) {
        return null;
    }

    @Override
    public Void visit(ExtensionTypeVector<?> vector, Void value) {
        vector.getUnderlyingVector().accept(this, (Void)value);
        return null;
    }
}

