/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.bigint;

import dev.whyoleg.cryptography.bigint.BigIntAsStringSerializer;
import dev.whyoleg.cryptography.bigint.BigIntKt;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=BigIntAsStringSerializer.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\u0010\n\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u001eB\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0086\u0002J\u0011\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000eH\u0086\u0002J\u0011\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0086\u0002J\u0011\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000fH\u0086\u0002J\u0011\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\bH\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\bH\u0016J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\f\u001a\u0004\u0018\u00010\u001dH\u0096\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Ldev/whyoleg/cryptography/bigint/BigInt;", "", "", "javaBigInteger", "Ljava/math/BigInteger;", "<init>", "(Ljava/math/BigInteger;)V", "sign", "", "getSign", "()I", "compareTo", "other", "", "", "", "toByte", "toShort", "toInt", "toLong", "toFloat", "", "toDouble", "", "toString", "", "hashCode", "equals", "", "", "Companion", "cryptography-bigint"})
public final class BigInt
extends Number
implements Comparable<BigInt> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final BigInteger javaBigInteger;
    @NotNull
    private static final BigInt ZERO;

    public BigInt(@NotNull BigInteger javaBigInteger) {
        Intrinsics.checkNotNullParameter((Object)javaBigInteger, (String)"javaBigInteger");
        this.javaBigInteger = javaBigInteger;
    }

    public final int getSign() {
        return this.javaBigInteger.signum();
    }

    @Override
    public final int compareTo(byte other) {
        return this.compareTo(BigIntKt.toBigInt(other));
    }

    @Override
    public final int compareTo(short other) {
        return this.compareTo(BigIntKt.toBigInt(other));
    }

    @Override
    public final int compareTo(int other) {
        return this.compareTo(BigIntKt.toBigInt(other));
    }

    @Override
    public final int compareTo(long other) {
        return this.compareTo(BigIntKt.toBigInt(other));
    }

    @Override
    public int compareTo(@NotNull BigInt other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.javaBigInteger.compareTo(other.javaBigInteger);
    }

    public byte toByte() {
        return this.javaBigInteger.byteValue();
    }

    public short toShort() {
        return this.javaBigInteger.shortValue();
    }

    public int toInt() {
        return this.javaBigInteger.intValue();
    }

    public long toLong() {
        return this.javaBigInteger.longValue();
    }

    public float toFloat() {
        return this.javaBigInteger.floatValue();
    }

    public double toDouble() {
        return this.javaBigInteger.doubleValue();
    }

    @NotNull
    public String toString() {
        String string = this.javaBigInteger.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public int hashCode() {
        return this.javaBigInteger.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof BigInt)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.javaBigInteger, (Object)((BigInt)other).javaBigInteger);
    }

    static {
        BigInteger bigInteger = BigInteger.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"ZERO");
        ZERO = new BigInt(bigInteger);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Ldev/whyoleg/cryptography/bigint/BigInt$Companion;", "", "<init>", "()V", "ZERO", "Ldev/whyoleg/cryptography/bigint/BigInt;", "getZERO", "()Ldev/whyoleg/cryptography/bigint/BigInt;", "serializer", "Lkotlinx/serialization/KSerializer;", "cryptography-bigint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BigInt getZERO() {
            return ZERO;
        }

        @NotNull
        public final KSerializer<BigInt> serializer() {
            return BigIntAsStringSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

