/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk;

import dev.whyoleg.cryptography.CryptographyAlgorithm;
import dev.whyoleg.cryptography.CryptographyAlgorithmId;
import dev.whyoleg.cryptography.CryptographyProvider;
import dev.whyoleg.cryptography.algorithms.AES;
import dev.whyoleg.cryptography.algorithms.Digest;
import dev.whyoleg.cryptography.algorithms.ECDH;
import dev.whyoleg.cryptography.algorithms.ECDSA;
import dev.whyoleg.cryptography.algorithms.HKDF;
import dev.whyoleg.cryptography.algorithms.HMAC;
import dev.whyoleg.cryptography.algorithms.MD5;
import dev.whyoleg.cryptography.algorithms.PBKDF2;
import dev.whyoleg.cryptography.algorithms.RIPEMD160;
import dev.whyoleg.cryptography.algorithms.RSA;
import dev.whyoleg.cryptography.algorithms.SHA1;
import dev.whyoleg.cryptography.algorithms.SHA224;
import dev.whyoleg.cryptography.algorithms.SHA256;
import dev.whyoleg.cryptography.algorithms.SHA384;
import dev.whyoleg.cryptography.algorithms.SHA3_224;
import dev.whyoleg.cryptography.algorithms.SHA3_256;
import dev.whyoleg.cryptography.algorithms.SHA3_384;
import dev.whyoleg.cryptography.algorithms.SHA3_512;
import dev.whyoleg.cryptography.algorithms.SHA512;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkAesCbc;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkAesCmac;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkAesCtr;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkAesEcb;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkAesGcm;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkDigest;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkEcdh;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkEcdsa;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkHkdf;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkHmac;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkPbkdf2;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkRsaOaep;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkRsaPkcs1;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkRsaPss;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkRsaRaw;
import java.security.Provider;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u0010\u001a\u0004\u0018\u0001H\u0011\"\b\b\u0000\u0010\u0011*\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u000eH\u0016\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyProvider;", "Ldev/whyoleg/cryptography/CryptographyProvider;", "provider", "Ljava/security/Provider;", "<init>", "(Ljava/security/Provider;)V", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "name", "", "getName", "()Ljava/lang/String;", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "Ldev/whyoleg/cryptography/CryptographyAlgorithmId;", "Ldev/whyoleg/cryptography/CryptographyAlgorithm;", "getOrNull", "A", "identifier", "(Ldev/whyoleg/cryptography/CryptographyAlgorithmId;)Ldev/whyoleg/cryptography/CryptographyAlgorithm;", "cryptography-provider-jdk"})
@SourceDebugExtension(value={"SMAP\nJdkCryptographyProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkCryptographyProvider.kt\ndev/whyoleg/cryptography/providers/jdk/JdkCryptographyProvider\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n72#2,2:161\n1#3:163\n*S KotlinDebug\n*F\n+ 1 JdkCryptographyProvider.kt\ndev/whyoleg/cryptography/providers/jdk/JdkCryptographyProvider\n*L\n110#1:161,2\n110#1:163\n*E\n"})
public final class JdkCryptographyProvider
extends CryptographyProvider {
    @NotNull
    private final JdkCryptographyState state;
    @NotNull
    private final String name;
    @NotNull
    private final ConcurrentHashMap<CryptographyAlgorithmId<?>, CryptographyAlgorithm> cache;

    public JdkCryptographyProvider(@Nullable Provider provider) {
        this.state = new JdkCryptographyState(provider);
        this.name = provider == null ? "JDK" : "JDK (" + provider.getName() + ')';
        this.cache = new ConcurrentHashMap();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public <A extends CryptographyAlgorithm> A getOrNull(@NotNull CryptographyAlgorithmId<A> identifier) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(identifier, (String)"identifier");
        ConcurrentMap concurrentMap = this.cache;
        CryptographyAlgorithmId<A> key$iv = identifier;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            CryptographyAlgorithmId<A> cryptographyAlgorithmId = identifier;
            CryptographyAlgorithm default$iv = Intrinsics.areEqual(cryptographyAlgorithmId, (Object)MD5.INSTANCE) ? (CryptographyAlgorithm)new JdkDigest(this.state, "MD5", (CryptographyAlgorithmId<Digest>)((CryptographyAlgorithmId)MD5.INSTANCE)) : (Intrinsics.areEqual(cryptographyAlgorithmId, (Object)SHA1.INSTANCE) ? (CryptographyAlgorithm)new JdkDigest(this.state, "SHA-1", (CryptographyAlgorithmId<Digest>)((CryptographyAlgorithmId)SHA1.INSTANCE)) : (Intrinsics.areEqual(cryptographyAlgorithmId, (Object)SHA224.INSTANCE) ? (CryptographyAlgorithm)new JdkDigest(this.state, "SHA-224", (CryptographyAlgorithmId<Digest>)((CryptographyAlgorithmId)SHA224.INSTANCE)) : (Intrinsics.areEqual(cryptographyAlgorithmId, (Object)SHA256.INSTANCE) ? (CryptographyAlgorithm)new JdkDigest(this.state, "SHA-256", (CryptographyAlgorithmId<Digest>)((CryptographyAlgorithmId)SHA256.INSTANCE)) : (Intrinsics.areEqual(cryptographyAlgorithmId, (Object)SHA384.INSTANCE) ? (CryptographyAlgorithm)new JdkDigest(this.state, "SHA-384", (CryptographyAlgorithmId<Digest>)((CryptographyAlgorithmId)SHA384.INSTANCE)) : (Intrinsics.areEqual(cryptographyAlgorithmId, (Object)SHA512.INSTANCE) ? (CryptographyAlgorithm)new JdkDigest(this.state, "SHA-512", (CryptographyAlgorithmId<Digest>)((CryptographyAlgorithmId)SHA512.INSTANCE)) : (Intrinsics.areEqual(cryptographyAlgorithmId, (Object)SHA3_224.INSTANCE) ? (CryptographyAlgorithm)new JdkDigest(this.state, "SHA3-224", (CryptographyAlgorithmId<Digest>)((CryptographyAlgorithmId)SHA3_224.INSTANCE)) : (Intrinsics.areEqual(cryptographyAlgorithmId, (Object)SHA3_256.INSTANCE) ? (CryptographyAlgorithm)new JdkDigest(this.state, "SHA3-256", (CryptographyAlgorithmId<Digest>)((CryptographyAlgorithmId)SHA3_256.INSTANCE)) : (Intrinsics.areEqual(cryptographyAlgorithmId, (Object)SHA3_384.INSTANCE) ? (CryptographyAlgorithm)new JdkDigest(this.state, "SHA3-384", (CryptographyAlgorithmId<Digest>)((CryptographyAlgorithmId)SHA3_384.INSTANCE)) : (Intrinsics.areEqual(cryptographyAlgorithmId, (Object)SHA3_512.INSTANCE) ? (CryptographyAlgorithm)new JdkDigest(this.state, "SHA3-512", (CryptographyAlgorithmId<Digest>)((CryptographyAlgorithmId)SHA3_512.INSTANCE)) : (Intrinsics.areEqual(cryptographyAlgorithmId, (Object)RIPEMD160.INSTANCE) ? (CryptographyAlgorithm)new JdkDigest(this.state, "RIPEMD160", (CryptographyAlgorithmId<Digest>)((CryptographyAlgorithmId)RIPEMD160.INSTANCE)) : (Intrinsics.areEqual(cryptographyAlgorithmId, (Object)HMAC.Companion) ? (CryptographyAlgorithm)new JdkHmac(this.state) : (Intrinsics.areEqual(cryptographyAlgorithmId, (Object)AES.CBC.Companion) ? (CryptographyAlgorithm)new JdkAesCbc(this.state) : (Intrinsics.areEqual(cryptographyAlgorithmId, (Object)AES.CMAC.Companion) ? (CryptographyAlgorithm)new JdkAesCmac(this.state) : (Intrinsics.areEqual(cryptographyAlgorithmId, (Object)AES.CTR.Companion) ? (CryptographyAlgorithm)new JdkAesCtr(this.state) : (Intrinsics.areEqual(cryptographyAlgorithmId, (Object)AES.ECB.Companion) ? (CryptographyAlgorithm)new JdkAesEcb(this.state) : (Intrinsics.areEqual(cryptographyAlgorithmId, (Object)AES.GCM.Companion) ? (CryptographyAlgorithm)new JdkAesGcm(this.state) : (Intrinsics.areEqual(cryptographyAlgorithmId, (Object)RSA.OAEP.Companion) ? (CryptographyAlgorithm)new JdkRsaOaep(this.state) : (Intrinsics.areEqual(cryptographyAlgorithmId, (Object)RSA.PSS.Companion) ? (CryptographyAlgorithm)new JdkRsaPss(this.state) : (Intrinsics.areEqual(cryptographyAlgorithmId, (Object)RSA.PKCS1.Companion) ? (CryptographyAlgorithm)new JdkRsaPkcs1(this.state) : (Intrinsics.areEqual(cryptographyAlgorithmId, (Object)RSA.RAW.Companion) ? (CryptographyAlgorithm)new JdkRsaRaw(this.state) : (Intrinsics.areEqual(cryptographyAlgorithmId, (Object)ECDSA.Companion) ? (CryptographyAlgorithm)new JdkEcdsa(this.state) : (Intrinsics.areEqual(cryptographyAlgorithmId, (Object)ECDH.Companion) ? (CryptographyAlgorithm)new JdkEcdh(this.state) : (Intrinsics.areEqual(cryptographyAlgorithmId, (Object)PBKDF2.Companion) ? (CryptographyAlgorithm)new JdkPbkdf2(this.state) : (Intrinsics.areEqual(cryptographyAlgorithmId, (Object)HKDF.Companion) ? (CryptographyAlgorithm)new JdkHkdf(this.state, this) : null))))))))))))))))))))))));
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        return (A)((CryptographyAlgorithm)object);
    }
}

