/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.bigint.BigInt;
import dev.whyoleg.cryptography.bigint.BigIntKt;
import dev.whyoleg.cryptography.operations.SignFunction;
import dev.whyoleg.cryptography.operations.SignatureGenerator;
import dev.whyoleg.cryptography.providers.base.BytesKt;
import dev.whyoleg.cryptography.providers.jdk.internal.UtilsKt;
import dev.whyoleg.cryptography.serialization.asn1.Der;
import dev.whyoleg.cryptography.serialization.asn1.modules.EcdsaSignatureValue;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/EcdsaRawSignatureGenerator;", "Ldev/whyoleg/cryptography/operations/SignatureGenerator;", "derGenerator", "curveOrderSize", "", "<init>", "(Ldev/whyoleg/cryptography/operations/SignatureGenerator;I)V", "createSignFunction", "Ldev/whyoleg/cryptography/operations/SignFunction;", "RawSignFunction", "cryptography-provider-jdk"})
final class EcdsaRawSignatureGenerator
implements SignatureGenerator {
    @NotNull
    private final SignatureGenerator derGenerator;
    private final int curveOrderSize;

    public EcdsaRawSignatureGenerator(@NotNull SignatureGenerator derGenerator, int curveOrderSize) {
        Intrinsics.checkNotNullParameter((Object)derGenerator, (String)"derGenerator");
        this.derGenerator = derGenerator;
        this.curveOrderSize = curveOrderSize;
    }

    @NotNull
    public SignFunction createSignFunction() {
        return new RawSignFunction(this.derGenerator.createSignFunction(), this.curveOrderSize);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\bH\u0016J\b\u0010\u0012\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/EcdsaRawSignatureGenerator$RawSignFunction;", "Ldev/whyoleg/cryptography/operations/SignFunction;", "derSignFunction", "curveOrderSize", "", "<init>", "(Ldev/whyoleg/cryptography/operations/SignFunction;I)V", "update", "", "source", "", "startIndex", "endIndex", "signIntoByteArray", "destination", "destinationOffset", "signToByteArray", "reset", "close", "cryptography-provider-jdk"})
    private static final class RawSignFunction
    implements SignFunction {
        @NotNull
        private final SignFunction derSignFunction;
        private final int curveOrderSize;

        public RawSignFunction(@NotNull SignFunction derSignFunction, int curveOrderSize) {
            Intrinsics.checkNotNullParameter((Object)derSignFunction, (String)"derSignFunction");
            this.derSignFunction = derSignFunction;
            this.curveOrderSize = curveOrderSize;
        }

        public void update(@NotNull byte[] source, int startIndex, int endIndex) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.derSignFunction.update(source, startIndex, endIndex);
        }

        public int signIntoByteArray(@NotNull byte[] destination, int destinationOffset) {
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            byte[] signature = this.signToByteArray();
            BytesKt.checkBounds((int)destination.length, (int)destinationOffset, (int)(destinationOffset + signature.length));
            ArraysKt.copyInto$default((byte[])signature, (byte[])destination, (int)destinationOffset, (int)destinationOffset, (int)0, (int)8, null);
            return signature.length;
        }

        @NotNull
        public byte[] signToByteArray() {
            byte[] derSignature = this.derSignFunction.signToByteArray();
            EcdsaSignatureValue signatureValue = (EcdsaSignatureValue)Der.Default.decodeFromByteArray((DeserializationStrategy)EcdsaSignatureValue.Companion.serializer(), derSignature);
            byte[] r = UtilsKt.trimLeadingZeros(BigIntKt.encodeToByteArray((BigInt)signatureValue.getR()));
            byte[] s = UtilsKt.trimLeadingZeros(BigIntKt.encodeToByteArray((BigInt)signatureValue.getS()));
            byte[] rawSignature = new byte[this.curveOrderSize * 2];
            ArraysKt.copyInto$default((byte[])r, (byte[])rawSignature, (int)(this.curveOrderSize - r.length), (int)0, (int)0, (int)12, null);
            ArraysKt.copyInto$default((byte[])s, (byte[])rawSignature, (int)(this.curveOrderSize * 2 - s.length), (int)0, (int)0, (int)12, null);
            return rawSignature;
        }

        public void reset() {
            this.derSignFunction.reset();
        }

        public void close() {
            this.derSignFunction.close();
        }
    }
}

