/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.bigint.BigIntKt;
import dev.whyoleg.cryptography.operations.SignatureVerifier;
import dev.whyoleg.cryptography.operations.VerifyFunction;
import dev.whyoleg.cryptography.providers.base.BytesKt;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkEcdsaKt;
import dev.whyoleg.cryptography.serialization.asn1.Der;
import dev.whyoleg.cryptography.serialization.asn1.modules.EcdsaSignatureValue;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/EcdsaRawSignatureVerifier;", "Ldev/whyoleg/cryptography/operations/SignatureVerifier;", "derVerifier", "curveOrderSize", "", "<init>", "(Ldev/whyoleg/cryptography/operations/SignatureVerifier;I)V", "createVerifyFunction", "Ldev/whyoleg/cryptography/operations/VerifyFunction;", "RawVerifyFunction", "cryptography-provider-jdk"})
final class EcdsaRawSignatureVerifier
implements SignatureVerifier {
    @NotNull
    private final SignatureVerifier derVerifier;
    private final int curveOrderSize;

    public EcdsaRawSignatureVerifier(@NotNull SignatureVerifier derVerifier, int curveOrderSize) {
        Intrinsics.checkNotNullParameter((Object)derVerifier, (String)"derVerifier");
        this.derVerifier = derVerifier;
        this.curveOrderSize = curveOrderSize;
    }

    @NotNull
    public VerifyFunction createVerifyFunction() {
        return new RawVerifyFunction(this.derVerifier.createVerifyFunction(), this.curveOrderSize);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0016J \u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\u0011\u001a\u00020\bH\u0016J\b\u0010\u0012\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/EcdsaRawSignatureVerifier$RawVerifyFunction;", "Ldev/whyoleg/cryptography/operations/VerifyFunction;", "derVerifyFunction", "curveOrderSize", "", "<init>", "(Ldev/whyoleg/cryptography/operations/VerifyFunction;I)V", "update", "", "source", "", "startIndex", "endIndex", "tryVerify", "", "signature", "verify", "reset", "close", "cryptography-provider-jdk"})
    @SourceDebugExtension(value={"SMAP\nJdkEcdsa.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkEcdsa.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/EcdsaRawSignatureVerifier$RawVerifyFunction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n1#2:153\n*E\n"})
    private static final class RawVerifyFunction
    implements VerifyFunction {
        @NotNull
        private final VerifyFunction derVerifyFunction;
        private final int curveOrderSize;

        public RawVerifyFunction(@NotNull VerifyFunction derVerifyFunction, int curveOrderSize) {
            Intrinsics.checkNotNullParameter((Object)derVerifyFunction, (String)"derVerifyFunction");
            this.derVerifyFunction = derVerifyFunction;
            this.curveOrderSize = curveOrderSize;
        }

        public void update(@NotNull byte[] source, int startIndex, int endIndex) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.derVerifyFunction.update(source, startIndex, endIndex);
        }

        public boolean tryVerify(@NotNull byte[] signature, int startIndex, int endIndex) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            BytesKt.checkBounds((int)signature.length, (int)startIndex, (int)endIndex);
            if (!(endIndex - startIndex == this.curveOrderSize * 2)) {
                boolean $i$a$-check-EcdsaRawSignatureVerifier$RawVerifyFunction$tryVerify$22 = false;
                String $i$a$-check-EcdsaRawSignatureVerifier$RawVerifyFunction$tryVerify$22 = "Expected signature size " + this.curveOrderSize * 2 + ", received: " + (endIndex - startIndex);
                throw new IllegalStateException($i$a$-check-EcdsaRawSignatureVerifier$RawVerifyFunction$tryVerify$22.toString());
            }
            byte[] r = JdkEcdsaKt.access$makePositive(ArraysKt.copyOfRange((byte[])signature, (int)startIndex, (int)(startIndex + this.curveOrderSize)));
            byte[] s = JdkEcdsaKt.access$makePositive(ArraysKt.copyOfRange((byte[])signature, (int)(startIndex + this.curveOrderSize), (int)endIndex));
            EcdsaSignatureValue signatureValue = new EcdsaSignatureValue(BigIntKt.decodeToBigInt((byte[])r), BigIntKt.decodeToBigInt((byte[])s));
            byte[] derSignature = Der.Default.encodeToByteArray((SerializationStrategy)EcdsaSignatureValue.Companion.serializer(), (Object)signatureValue);
            return VerifyFunction.tryVerify$default((VerifyFunction)this.derVerifyFunction, (byte[])derSignature, (int)0, (int)0, (int)6, null);
        }

        public void verify(@NotNull byte[] signature, int startIndex, int endIndex) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            if (!this.tryVerify(signature, startIndex, endIndex)) {
                boolean bl = false;
                String string = "Invalid signature";
                throw new IllegalStateException(string.toString());
            }
        }

        public void reset() {
            this.derVerifyFunction.reset();
        }

        public void close() {
            this.derVerifyFunction.close();
        }
    }
}

