/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.providers.base.algorithms.BaseAesImplicitIvDecryptFunction;
import dev.whyoleg.cryptography.providers.base.algorithms.BaseAesImplicitIvEncryptFunction;
import dev.whyoleg.cryptography.providers.base.algorithms.BaseAesIvAuthenticatedCipher;
import dev.whyoleg.cryptography.providers.base.operations.CipherFunction;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.Pooled;
import dev.whyoleg.cryptography.providers.jdk.operations.JdkCipherFunction;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u001a\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J*\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\f\u0012\b\u0012\u00060\rj\u0002`\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkAesGcmCipher;", "Ldev/whyoleg/cryptography/providers/base/algorithms/BaseAesIvAuthenticatedCipher;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "key", "Ljavax/crypto/SecretKey;", "Ldev/whyoleg/cryptography/providers/jdk/JSecretKey;", "tagSizeBits", "", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljavax/crypto/SecretKey;I)V", "cipher", "Ldev/whyoleg/cryptography/providers/jdk/Pooled;", "Ljavax/crypto/Cipher;", "Ldev/whyoleg/cryptography/providers/jdk/JCipher;", "createEncryptFunction", "Ldev/whyoleg/cryptography/providers/base/operations/CipherFunction;", "associatedData", "", "createDecryptFunction", "createEncryptFunctionWithIv", "iv", "createDecryptFunctionWithIv", "startIndex", "ivSize", "cryptography-provider-jdk"})
@SourceDebugExtension(value={"SMAP\nJdkAesGcm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkAesGcm.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/JdkAesGcmCipher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 pooling.kt\ndev/whyoleg/cryptography/providers/jdk/Pooled\n*L\n1#1,87:1\n1#2:88\n1#2:90\n1#2:92\n38#3:89\n38#3:91\n*S KotlinDebug\n*F\n+ 1 JdkAesGcm.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/JdkAesGcmCipher\n*L\n65#1:90\n77#1:92\n65#1:89\n77#1:91\n*E\n"})
final class JdkAesGcmCipher
implements BaseAesIvAuthenticatedCipher {
    @NotNull
    private final JdkCryptographyState state;
    @NotNull
    private final SecretKey key;
    private final int tagSizeBits;
    @NotNull
    private final Pooled<Cipher> cipher;

    public JdkAesGcmCipher(@NotNull JdkCryptographyState state, @NotNull SecretKey key, int tagSizeBits) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.state = state;
        this.key = key;
        this.tagSizeBits = tagSizeBits;
        this.cipher = this.state.cipher("AES/GCM/NoPadding");
    }

    @NotNull
    public CipherFunction createEncryptFunction(@Nullable byte[] associatedData) {
        byte[] byArray = new byte[12];
        SecureRandom secureRandom = this.state.getSecureRandom();
        byte[] p0 = byArray;
        boolean bl = false;
        secureRandom.nextBytes(p0);
        byte[] iv = byArray;
        return (CipherFunction)new BaseAesImplicitIvEncryptFunction(iv, this.createEncryptFunctionWithIv(iv, associatedData));
    }

    @NotNull
    public CipherFunction createDecryptFunction(@Nullable byte[] associatedData) {
        return (CipherFunction)new BaseAesImplicitIvDecryptFunction(12, (arg_0, arg_1) -> JdkAesGcmCipher.createDecryptFunction$lambda$0(this, associatedData, arg_0, arg_1));
    }

    @NotNull
    public CipherFunction createEncryptFunctionWithIv(@NotNull byte[] iv, @Nullable byte[] associatedData) {
        Pooled.Resource<Cipher> resource;
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Pooled<Cipher> this_$iv = this.cipher;
        boolean $i$f$borrowResource = false;
        Pooled.Resource<Cipher> $this$borrowResource_u24lambda_u240$iv = resource = this_$iv.borrowResource();
        boolean bl = false;
        Cipher $this$createEncryptFunctionWithIv_u24lambda_u242 = $this$borrowResource_u24lambda_u240$iv.access();
        boolean bl2 = false;
        $this$createEncryptFunctionWithIv_u24lambda_u242.init(1, (Key)this.key, new GCMParameterSpec(this.tagSizeBits, iv), this.state.getSecureRandom());
        if (associatedData != null) {
            byte[] p0 = associatedData;
            boolean bl3 = false;
            $this$createEncryptFunctionWithIv_u24lambda_u242.updateAAD(p0);
        }
        Pooled.Resource<Cipher> resource2 = resource;
        return (CipherFunction)new JdkCipherFunction(resource2);
    }

    private final CipherFunction createDecryptFunctionWithIv(byte[] iv, int startIndex, int ivSize, byte[] associatedData) {
        Pooled.Resource<Cipher> resource;
        Pooled<Cipher> this_$iv = this.cipher;
        boolean $i$f$borrowResource = false;
        Pooled.Resource<Cipher> $this$borrowResource_u24lambda_u240$iv = resource = this_$iv.borrowResource();
        boolean bl = false;
        Cipher $this$createDecryptFunctionWithIv_u24lambda_u244 = $this$borrowResource_u24lambda_u240$iv.access();
        boolean bl2 = false;
        $this$createDecryptFunctionWithIv_u24lambda_u244.init(2, (Key)this.key, new GCMParameterSpec(this.tagSizeBits, iv, startIndex, ivSize), this.state.getSecureRandom());
        if (associatedData != null) {
            byte[] p0 = associatedData;
            boolean bl3 = false;
            $this$createDecryptFunctionWithIv_u24lambda_u244.updateAAD(p0);
        }
        Pooled.Resource<Cipher> resource2 = resource;
        return (CipherFunction)new JdkCipherFunction(resource2);
    }

    @NotNull
    public CipherFunction createDecryptFunctionWithIv(@NotNull byte[] iv, @Nullable byte[] associatedData) {
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        return this.createDecryptFunctionWithIv(iv, 0, iv.length, associatedData);
    }

    private static final CipherFunction createDecryptFunction$lambda$0(JdkAesGcmCipher this$0, byte[] $associatedData, byte[] iv, int startIndex) {
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        return this$0.createDecryptFunctionWithIv(iv, startIndex, 12, $associatedData);
    }
}

