/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.algorithms.EC;
import dev.whyoleg.cryptography.materials.key.KeyDecoder;
import dev.whyoleg.cryptography.materials.key.KeyGenerator;
import dev.whyoleg.cryptography.providers.base.algorithms.EcKt;
import dev.whyoleg.cryptography.providers.base.materials.KeysKt;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.Pooled;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkEcKt;
import dev.whyoleg.cryptography.providers.jdk.internal.UtilsKt;
import dev.whyoleg.cryptography.providers.jdk.materials.JdkEncodableKey;
import dev.whyoleg.cryptography.providers.jdk.materials.JdkKeyPairGenerator;
import dev.whyoleg.cryptography.providers.jdk.materials.JdkPrivateKeyDecoder;
import dev.whyoleg.cryptography.providers.jdk.materials.JdkPublicKeyDecoder;
import dev.whyoleg.cryptography.serialization.pem.PemLabel;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\u0014\b\u0002\u0010\u0005*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00062\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050\u0007:\u0005/0123B\u0011\b\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0014\u0010\u000e\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0015\u0010\u0013\u001a\u00028\u0000*\u00060\u0014j\u0002`\u0015H$\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0013\u001a\u00028\u0001*\u00060\u0017j\u0002`\u0018H$\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u0013\u001a\u00028\u0002*\u00060\u001aj\u0002`\u001bH$\u00a2\u0006\u0002\u0010\u001cJ!\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00028\u00000\u001e2\u0006\u0010 \u001a\u00020!\u00a2\u0006\u0004\b\"\u0010#J!\u0010$\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00028\u00010\u001e2\u0006\u0010 \u001a\u00020!\u00a2\u0006\u0004\b&\u0010#J\u001b\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00020(2\u0006\u0010 \u001a\u00020!\u00a2\u0006\u0004\b)\u0010*R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0018\u0010+\u001a\u00020,*\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u0082\u0001\u000245\u00a8\u00066"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc;", "PublicK", "Ldev/whyoleg/cryptography/algorithms/EC$PublicKey;", "PrivateK", "Ldev/whyoleg/cryptography/algorithms/EC$PrivateKey;", "KP", "Ldev/whyoleg/cryptography/algorithms/EC$KeyPair;", "Ldev/whyoleg/cryptography/algorithms/EC;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;)V", "getState", "()Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "algorithmParameters", "Ljava/security/AlgorithmParameters;", "Ldev/whyoleg/cryptography/providers/jdk/JAlgorithmParameters;", "spec", "Ljava/security/spec/AlgorithmParameterSpec;", "convert", "Ljava/security/PublicKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPublicKey;", "(Ljava/security/PublicKey;)Ldev/whyoleg/cryptography/algorithms/EC$PublicKey;", "Ljava/security/PrivateKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPrivateKey;", "(Ljava/security/PrivateKey;)Ldev/whyoleg/cryptography/algorithms/EC$PrivateKey;", "Ljava/security/KeyPair;", "Ldev/whyoleg/cryptography/providers/jdk/JKeyPair;", "(Ljava/security/KeyPair;)Ldev/whyoleg/cryptography/algorithms/EC$KeyPair;", "publicKeyDecoder", "Ldev/whyoleg/cryptography/materials/key/KeyDecoder;", "Ldev/whyoleg/cryptography/algorithms/EC$PublicKey$Format;", "curve", "Ldev/whyoleg/cryptography/algorithms/EC$Curve;", "publicKeyDecoder-yfdS0HE", "(Ljava/lang/String;)Ldev/whyoleg/cryptography/materials/key/KeyDecoder;", "privateKeyDecoder", "Ldev/whyoleg/cryptography/algorithms/EC$PrivateKey$Format;", "privateKeyDecoder-yfdS0HE", "keyPairGenerator", "Ldev/whyoleg/cryptography/materials/key/KeyGenerator;", "keyPairGenerator-yfdS0HE", "(Ljava/lang/String;)Ldev/whyoleg/cryptography/materials/key/KeyGenerator;", "jdkName", "", "getJdkName-yfdS0HE", "(Ljava/lang/String;)Ljava/lang/String;", "EcKeyPairGenerator", "EcPublicKeyDecoder", "EcPrivateKeyDecoder", "BaseEcPublicKey", "BaseEcPrivateKey", "Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEcdh;", "Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEcdsa;", "cryptography-provider-jdk"})
@SourceDebugExtension(value={"SMAP\nJdkEc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkEc.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,239:1\n1#2:240\n*E\n"})
public abstract class JdkEc<PublicK extends EC.PublicKey, PrivateK extends EC.PrivateKey, KP extends EC.KeyPair<PublicK, PrivateK>>
implements EC<PublicK, PrivateK, KP> {
    @NotNull
    private final JdkCryptographyState state;

    private JdkEc(JdkCryptographyState state) {
        this.state = state;
    }

    @NotNull
    protected final JdkCryptographyState getState() {
        return this.state;
    }

    private final AlgorithmParameters algorithmParameters(AlgorithmParameterSpec spec) {
        AlgorithmParameters algorithmParameters;
        AlgorithmParameters it = algorithmParameters = this.state.algorithmParameters("EC");
        boolean bl = false;
        it.init(spec);
        return algorithmParameters;
    }

    @NotNull
    protected abstract PublicK convert(@NotNull PublicKey var1);

    @NotNull
    protected abstract PrivateK convert(@NotNull PrivateKey var1);

    @NotNull
    protected abstract KP convert(@NotNull KeyPair var1);

    @NotNull
    public final KeyDecoder<EC.PublicKey.Format, PublicK> publicKeyDecoder-yfdS0HE(@NotNull String curve) {
        Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
        return new EcPublicKeyDecoder(JdkEcKt.access$curveName(this.algorithmParameters(new ECGenParameterSpec(this.getJdkName-yfdS0HE(curve)))));
    }

    @NotNull
    public final KeyDecoder<EC.PrivateKey.Format, PrivateK> privateKeyDecoder-yfdS0HE(@NotNull String curve) {
        Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
        return new EcPrivateKeyDecoder(JdkEcKt.access$curveName(this.algorithmParameters(new ECGenParameterSpec(this.getJdkName-yfdS0HE(curve)))));
    }

    @NotNull
    public final KeyGenerator<KP> keyPairGenerator-yfdS0HE(@NotNull String curve) {
        Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
        return new EcKeyPairGenerator(new ECGenParameterSpec(this.getJdkName-yfdS0HE(curve)));
    }

    private final String getJdkName-yfdS0HE(String $this$jdkName) {
        String string = $this$jdkName;
        return EC.Curve.equals-impl0((String)string, (String)EC.Curve.Companion.getP256-pVITJAk()) ? "secp256r1" : (EC.Curve.equals-impl0((String)string, (String)EC.Curve.Companion.getP384-pVITJAk()) ? "secp384r1" : (EC.Curve.equals-impl0((String)string, (String)EC.Curve.Companion.getP521-pVITJAk()) ? "secp521r1" : $this$jdkName));
    }

    public /* synthetic */ JdkEc(JdkCryptographyState state, DefaultConstructorMarker $constructor_marker) {
        this(state);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\b$\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0013\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc$BaseEcPrivateKey;", "Ldev/whyoleg/cryptography/algorithms/EC$PrivateKey;", "Ldev/whyoleg/cryptography/providers/jdk/materials/JdkEncodableKey;", "Ldev/whyoleg/cryptography/algorithms/EC$PrivateKey$Format;", "key", "Ljava/security/PrivateKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPrivateKey;", "<init>", "(Ljava/security/PrivateKey;)V", "encodeToByteArrayBlocking", "", "format", "cryptography-provider-jdk"})
    protected static abstract class BaseEcPrivateKey
    extends JdkEncodableKey<EC.PrivateKey.Format>
    implements EC.PrivateKey {
        @NotNull
        private final PrivateKey key;

        public BaseEcPrivateKey(@NotNull PrivateKey key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super(key);
            this.key = key;
        }

        @NotNull
        public final byte[] encodeToByteArrayBlocking(@NotNull EC.PrivateKey.Format format) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            EC.PrivateKey.Format format2 = format;
            if (Intrinsics.areEqual((Object)format2, (Object)EC.PrivateKey.Format.JWK.INSTANCE)) {
                throw new IllegalStateException((format + " is not supported").toString());
            }
            if (Intrinsics.areEqual((Object)format2, (Object)EC.PrivateKey.Format.DER.Generic)) {
                byArray = this.encodeToDer();
            } else if (Intrinsics.areEqual((Object)format2, (Object)EC.PrivateKey.Format.RAW.INSTANCE)) {
                PrivateKey privateKey = this.key;
                Intrinsics.checkNotNull((Object)privateKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPrivateKey");
                ECPrivateKey cfr_ignored_0 = (ECPrivateKey)privateKey;
                ECParameterSpec eCParameterSpec = ((ECPrivateKey)this.key).getParams();
                Intrinsics.checkNotNullExpressionValue((Object)eCParameterSpec, (String)"getParams(...)");
                int fieldSize = JdkEcKt.curveOrderSize(eCParameterSpec);
                byte[] byArray2 = ((ECPrivateKey)this.key).getS().toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
                byte[] secret = UtilsKt.trimLeadingZeros(byArray2);
                byArray = ArraysKt.copyInto$default((byte[])secret, (byte[])new byte[fieldSize], (int)(fieldSize - secret.length), (int)0, (int)0, (int)12, null);
            } else if (Intrinsics.areEqual((Object)format2, (Object)EC.PrivateKey.Format.PEM.Generic)) {
                byArray = KeysKt.wrapPem-unSj4pc((String)PemLabel.Companion.getPrivateKey-2EFq_Wg(), (byte[])this.encodeToDer());
            } else if (Intrinsics.areEqual((Object)format2, (Object)EC.PrivateKey.Format.DER.SEC1.INSTANCE)) {
                byArray = EcKt.convertEcPrivateKeyFromPkcs8ToSec1((byte[])this.encodeToDer());
            } else if (Intrinsics.areEqual((Object)format2, (Object)EC.PrivateKey.Format.PEM.SEC1.INSTANCE)) {
                byArray = KeysKt.wrapPem-unSj4pc((String)PemLabel.Companion.getEcPrivateKey-2EFq_Wg(), (byte[])EcKt.convertEcPrivateKeyFromPkcs8ToSec1((byte[])this.encodeToDer()));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return byArray;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b$\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0013\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc$BaseEcPublicKey;", "Ldev/whyoleg/cryptography/algorithms/EC$PublicKey;", "Ldev/whyoleg/cryptography/providers/jdk/materials/JdkEncodableKey;", "Ldev/whyoleg/cryptography/algorithms/EC$PublicKey$Format;", "key", "Ljava/security/PublicKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPublicKey;", "<init>", "(Ljava/security/PublicKey;)V", "encodeToByteArrayBlocking", "", "format", "encodeToRaw", "compressed", "", "cryptography-provider-jdk"})
    protected static abstract class BaseEcPublicKey
    extends JdkEncodableKey<EC.PublicKey.Format>
    implements EC.PublicKey {
        @NotNull
        private final PublicKey key;

        public BaseEcPublicKey(@NotNull PublicKey key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super(key);
            this.key = key;
        }

        @NotNull
        public final byte[] encodeToByteArrayBlocking(@NotNull EC.PublicKey.Format format) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            EC.PublicKey.Format format2 = format;
            if (Intrinsics.areEqual((Object)format2, (Object)EC.PublicKey.Format.JWK.INSTANCE)) {
                throw new IllegalStateException((format + " is not supported").toString());
            }
            if (Intrinsics.areEqual((Object)format2, (Object)EC.PublicKey.Format.RAW.Uncompressed)) {
                byArray = this.encodeToRaw(false);
            } else if (Intrinsics.areEqual((Object)format2, (Object)EC.PublicKey.Format.RAW.Compressed.INSTANCE)) {
                byArray = this.encodeToRaw(true);
            } else if (Intrinsics.areEqual((Object)format2, (Object)EC.PublicKey.Format.DER.INSTANCE)) {
                byArray = this.encodeToDer();
            } else if (Intrinsics.areEqual((Object)format2, (Object)EC.PublicKey.Format.PEM.INSTANCE)) {
                byArray = KeysKt.wrapPem-unSj4pc((String)PemLabel.Companion.getPublicKey-2EFq_Wg(), (byte[])this.encodeToDer());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return byArray;
        }

        private final byte[] encodeToRaw(boolean compressed) {
            byte[] byArray;
            BaseEcPublicKey $this$encodeToRaw_u24lambda_u240 = this;
            boolean bl = false;
            PublicKey publicKey = $this$encodeToRaw_u24lambda_u240.key;
            Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
            ECPublicKey cfr_ignored_0 = (ECPublicKey)publicKey;
            ECParameterSpec eCParameterSpec = ((ECPublicKey)$this$encodeToRaw_u24lambda_u240.key).getParams();
            Intrinsics.checkNotNullExpressionValue((Object)eCParameterSpec, (String)"getParams(...)");
            int fieldSize = JdkEcKt.curveOrderSize(eCParameterSpec);
            byte[] byArray2 = ((ECPublicKey)$this$encodeToRaw_u24lambda_u240.key).getW().getAffineX().toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
            byte[] x = UtilsKt.trimLeadingZeros(byArray2);
            byte[] byArray3 = ((ECPublicKey)$this$encodeToRaw_u24lambda_u240.key).getW().getAffineY().toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"toByteArray(...)");
            byte[] y = UtilsKt.trimLeadingZeros(byArray3);
            if (!(x.length <= fieldSize && y.length <= fieldSize)) {
                throw new IllegalStateException("Check failed.");
            }
            if (compressed) {
                byte[] output = new byte[fieldSize + 1];
                output[0] = ((ECPublicKey)$this$encodeToRaw_u24lambda_u240.key).getW().getAffineY().testBit(0) ? 3 : 2;
                ArraysKt.copyInto$default((byte[])x, (byte[])output, (int)(fieldSize - x.length + 1), (int)0, (int)0, (int)12, null);
                byArray = output;
            } else {
                byte[] output = new byte[fieldSize * 2 + 1];
                output[0] = 4;
                ArraysKt.copyInto$default((byte[])x, (byte[])output, (int)(fieldSize - x.length + 1), (int)0, (int)0, (int)12, null);
                ArraysKt.copyInto$default((byte[])y, (byte[])output, (int)(fieldSize * 2 - y.length + 1), (int)0, (int)0, (int)12, null);
                byArray = output;
            }
            return byArray;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u0007*\u00060\bj\u0002`\tH\u0014J\u0015\u0010\n\u001a\u00028\u0002*\u00060\u000bj\u0002`\fH\u0014\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc$EcKeyPairGenerator;", "Ldev/whyoleg/cryptography/providers/jdk/materials/JdkKeyPairGenerator;", "keyGenParameters", "Ljava/security/spec/ECGenParameterSpec;", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc;Ljava/security/spec/ECGenParameterSpec;)V", "init", "", "Ljava/security/KeyPairGenerator;", "Ldev/whyoleg/cryptography/providers/jdk/JKeyPairGenerator;", "convert", "Ljava/security/KeyPair;", "Ldev/whyoleg/cryptography/providers/jdk/JKeyPair;", "(Ljava/security/KeyPair;)Ldev/whyoleg/cryptography/algorithms/EC$KeyPair;", "cryptography-provider-jdk"})
    @SourceDebugExtension(value={"SMAP\nJdkEc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkEc.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc$EcKeyPairGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,239:1\n1#2:240\n*E\n"})
    private final class EcKeyPairGenerator
    extends JdkKeyPairGenerator<KP> {
        @NotNull
        private final ECGenParameterSpec keyGenParameters;

        public EcKeyPairGenerator(ECGenParameterSpec keyGenParameters) {
            Intrinsics.checkNotNullParameter((Object)keyGenParameters, (String)"keyGenParameters");
            super(JdkEc.this.getState(), "EC");
            this.keyGenParameters = keyGenParameters;
        }

        @Override
        protected void init(@NotNull KeyPairGenerator $this$init) {
            Intrinsics.checkNotNullParameter((Object)$this$init, (String)"<this>");
            $this$init.initialize(this.keyGenParameters, this.getState().getSecureRandom());
        }

        @Override
        @NotNull
        protected KP convert(@NotNull KeyPair $this$convert) {
            Intrinsics.checkNotNullParameter((Object)$this$convert, (String)"<this>");
            JdkEc $this$convert_u24lambda_u240 = JdkEc.this;
            boolean bl = false;
            return $this$convert_u24lambda_u240.convert($this$convert);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00028\u00010\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0007\u001a\u00028\u0001*\u00060\bj\u0002`\tH\u0014\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u000b\u001a\u00028\u00012\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc$EcPrivateKeyDecoder;", "Ldev/whyoleg/cryptography/providers/jdk/materials/JdkPrivateKeyDecoder;", "Ldev/whyoleg/cryptography/algorithms/EC$PrivateKey$Format;", "curveName", "", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc;Ljava/lang/String;)V", "convert", "Ljava/security/PrivateKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPrivateKey;", "(Ljava/security/PrivateKey;)Ldev/whyoleg/cryptography/algorithms/EC$PrivateKey;", "decodeFromByteArrayBlocking", "format", "bytes", "", "(Ldev/whyoleg/cryptography/algorithms/EC$PrivateKey$Format;[B)Ldev/whyoleg/cryptography/algorithms/EC$PrivateKey;", "cryptography-provider-jdk"})
    @SourceDebugExtension(value={"SMAP\nJdkEc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkEc.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc$EcPrivateKeyDecoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,239:1\n1#2:240\n*E\n"})
    private final class EcPrivateKeyDecoder
    extends JdkPrivateKeyDecoder<EC.PrivateKey.Format, PrivateK> {
        @NotNull
        private final String curveName;

        public EcPrivateKeyDecoder(String curveName) {
            Intrinsics.checkNotNullParameter((Object)curveName, (String)"curveName");
            super(JdkEc.this.getState(), "EC");
            this.curveName = curveName;
        }

        @Override
        @NotNull
        protected PrivateK convert(@NotNull PrivateKey $this$convert) {
            Intrinsics.checkNotNullParameter((Object)$this$convert, (String)"<this>");
            if (!($this$convert instanceof ECPrivateKey)) {
                throw new IllegalStateException("Check failed.");
            }
            ECParameterSpec eCParameterSpec = ((ECPrivateKey)$this$convert).getParams();
            Intrinsics.checkNotNullExpressionValue((Object)eCParameterSpec, (String)"getParams(...)");
            String keyCurve = JdkEcKt.access$curveName(JdkEc.this.algorithmParameters(eCParameterSpec));
            if (!Intrinsics.areEqual((Object)this.curveName, (Object)keyCurve)) {
                boolean $i$a$-check-JdkEc$EcPrivateKeyDecoder$convert$22 = false;
                String $i$a$-check-JdkEc$EcPrivateKeyDecoder$convert$22 = "Key curve " + keyCurve + " is not equal to expected curve " + this.curveName;
                throw new IllegalStateException($i$a$-check-JdkEc$EcPrivateKeyDecoder$convert$22.toString());
            }
            JdkEc $this$convert_u24lambda_u241 = JdkEc.this;
            boolean bl = false;
            return $this$convert_u24lambda_u241.convert($this$convert);
        }

        @NotNull
        public PrivateK decodeFromByteArrayBlocking(@NotNull EC.PrivateKey.Format format, @NotNull byte[] bytes) {
            EC.PrivateKey privateKey;
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            EC.PrivateKey.Format format2 = format;
            if (Intrinsics.areEqual((Object)format2, (Object)EC.PrivateKey.Format.JWK.INSTANCE)) {
                throw new IllegalStateException((format + " is not supported").toString());
            }
            if (Intrinsics.areEqual((Object)format2, (Object)EC.PrivateKey.Format.RAW.INSTANCE)) {
                ECParameterSpec parameters = JdkEc.this.algorithmParameters(new ECGenParameterSpec(this.curveName)).getParameterSpec(ECParameterSpec.class);
                privateKey = (EC.PrivateKey)this.decode(new ECPrivateKeySpec(new BigInteger(1, bytes), parameters));
            } else if (Intrinsics.areEqual((Object)format2, (Object)EC.PrivateKey.Format.DER.Generic)) {
                privateKey = (EC.PrivateKey)this.decodeFromDer(bytes);
            } else if (Intrinsics.areEqual((Object)format2, (Object)EC.PrivateKey.Format.PEM.Generic)) {
                privateKey = (EC.PrivateKey)this.decodeFromDer(KeysKt.unwrapPem-unSj4pc((String)PemLabel.Companion.getPrivateKey-2EFq_Wg(), (byte[])bytes));
            } else if (Intrinsics.areEqual((Object)format2, (Object)EC.PrivateKey.Format.DER.SEC1.INSTANCE)) {
                privateKey = (EC.PrivateKey)this.decodeFromDer(EcKt.convertEcPrivateKeyFromSec1ToPkcs8((byte[])bytes));
            } else if (Intrinsics.areEqual((Object)format2, (Object)EC.PrivateKey.Format.PEM.SEC1.INSTANCE)) {
                privateKey = (EC.PrivateKey)this.decodeFromDer(EcKt.convertEcPrivateKeyFromSec1ToPkcs8((byte[])KeysKt.unwrapPem-unSj4pc((String)PemLabel.Companion.getEcPrivateKey-2EFq_Wg(), (byte[])bytes)));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return privateKey;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00028\u00000\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0007\u001a\u00028\u0000*\u00060\bj\u0002`\tH\u0014\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010\u0010\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc$EcPublicKeyDecoder;", "Ldev/whyoleg/cryptography/providers/jdk/materials/JdkPublicKeyDecoder;", "Ldev/whyoleg/cryptography/algorithms/EC$PublicKey$Format;", "curveName", "", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc;Ljava/lang/String;)V", "convert", "Ljava/security/PublicKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPublicKey;", "(Ljava/security/PublicKey;)Ldev/whyoleg/cryptography/algorithms/EC$PublicKey;", "decodeFromByteArrayBlocking", "format", "bytes", "", "(Ldev/whyoleg/cryptography/algorithms/EC$PublicKey$Format;[B)Ldev/whyoleg/cryptography/algorithms/EC$PublicKey;", "decodeFromRaw", "([B)Ldev/whyoleg/cryptography/algorithms/EC$PublicKey;", "cryptography-provider-jdk"})
    @SourceDebugExtension(value={"SMAP\nJdkEc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkEc.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc$EcPublicKeyDecoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 pooling.kt\ndev/whyoleg/cryptography/providers/jdk/Pooled\n*L\n1#1,239:1\n1#2:240\n41#3,5:241\n*S KotlinDebug\n*F\n+ 1 JdkEc.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc$EcPublicKeyDecoder\n*L\n85#1:241,5\n*E\n"})
    private final class EcPublicKeyDecoder
    extends JdkPublicKeyDecoder<EC.PublicKey.Format, PublicK> {
        @NotNull
        private final String curveName;

        public EcPublicKeyDecoder(String curveName) {
            Intrinsics.checkNotNullParameter((Object)curveName, (String)"curveName");
            super(JdkEc.this.getState(), "EC", null, 4, null);
            this.curveName = curveName;
        }

        @Override
        @NotNull
        protected PublicK convert(@NotNull PublicKey $this$convert) {
            Intrinsics.checkNotNullParameter((Object)$this$convert, (String)"<this>");
            if (!($this$convert instanceof ECPublicKey)) {
                throw new IllegalStateException("Check failed.");
            }
            ECParameterSpec eCParameterSpec = ((ECPublicKey)$this$convert).getParams();
            Intrinsics.checkNotNullExpressionValue((Object)eCParameterSpec, (String)"getParams(...)");
            String keyCurve = JdkEcKt.access$curveName(JdkEc.this.algorithmParameters(eCParameterSpec));
            if (!Intrinsics.areEqual((Object)this.curveName, (Object)keyCurve)) {
                boolean $i$a$-check-JdkEc$EcPublicKeyDecoder$convert$22 = false;
                String $i$a$-check-JdkEc$EcPublicKeyDecoder$convert$22 = "Key curve " + keyCurve + " is not equal to expected curve " + this.curveName;
                throw new IllegalStateException($i$a$-check-JdkEc$EcPublicKeyDecoder$convert$22.toString());
            }
            JdkEc $this$convert_u24lambda_u241 = JdkEc.this;
            boolean bl = false;
            return $this$convert_u24lambda_u241.convert($this$convert);
        }

        @NotNull
        public PublicK decodeFromByteArrayBlocking(@NotNull EC.PublicKey.Format format, @NotNull byte[] bytes) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            EC.PublicKey.Format format2 = format;
            if (Intrinsics.areEqual((Object)format2, (Object)EC.PublicKey.Format.JWK.INSTANCE)) {
                throw new IllegalStateException((format + " is not supported").toString());
            }
            if (Intrinsics.areEqual((Object)format2, (Object)EC.PublicKey.Format.RAW.Uncompressed)) {
                object = this.decodeFromRaw(bytes);
            } else if (Intrinsics.areEqual((Object)format2, (Object)EC.PublicKey.Format.RAW.Compressed.INSTANCE)) {
                object = this.decodeFromRaw(bytes);
            } else if (Intrinsics.areEqual((Object)format2, (Object)EC.PublicKey.Format.DER.INSTANCE)) {
                object = (EC.PublicKey)this.decodeFromDer(bytes);
            } else if (Intrinsics.areEqual((Object)format2, (Object)EC.PublicKey.Format.PEM.INSTANCE)) {
                object = (EC.PublicKey)this.decodeFromDer(KeysKt.unwrapPem-unSj4pc((String)PemLabel.Companion.getPublicKey-2EFq_Wg(), (byte[])bytes));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final PublicK decodeFromRaw(byte[] bytes) {
            PublicKey publicKey;
            void this_$iv;
            EcPublicKeyDecoder ecPublicKeyDecoder = this;
            JdkEc jdkEc = JdkEc.this;
            EcPublicKeyDecoder $this$decodeFromRaw_u24lambda_u244 = ecPublicKeyDecoder;
            boolean bl = false;
            if (!(!(bytes.length == 0))) {
                boolean $i$a$-check-JdkEc$EcPublicKeyDecoder$decodeFromRaw$1$22 = false;
                String $i$a$-check-JdkEc$EcPublicKeyDecoder$decodeFromRaw$1$22 = "Encoded key is empty!";
                throw new IllegalStateException($i$a$-check-JdkEc$EcPublicKeyDecoder$decodeFromRaw$1$22.toString());
            }
            ECParameterSpec parameters = jdkEc.algorithmParameters(new ECGenParameterSpec($this$decodeFromRaw_u24lambda_u244.curveName)).getParameterSpec(ECParameterSpec.class);
            Intrinsics.checkNotNull((Object)parameters);
            ECPoint point = JdkEcKt.decodePoint(parameters, bytes);
            Pooled<KeyFactory> pooled = $this$decodeFromRaw_u24lambda_u244.getKeyFactory();
            EcPublicKeyDecoder ecPublicKeyDecoder2 = $this$decodeFromRaw_u24lambda_u244;
            boolean $i$f$use = false;
            Object instance$iv = Pooled.access$borrow((Pooled)this_$iv);
            try {
                KeyFactory it = (KeyFactory)instance$iv;
                boolean bl2 = false;
                publicKey = it.generatePublic(new ECPublicKeySpec(point, parameters));
            }
            finally {
                Pooled.access$recycle((Pooled)this_$iv, instance$iv);
            }
            PublicKey publicKey2 = publicKey;
            Intrinsics.checkNotNullExpressionValue((Object)publicKey2, (String)"use(...)");
            return ecPublicKeyDecoder2.convert(publicKey2);
        }
    }
}

