/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.CryptographyAlgorithmId;
import dev.whyoleg.cryptography.algorithms.Digest;
import dev.whyoleg.cryptography.algorithms.ECDSA;
import dev.whyoleg.cryptography.operations.SignatureGenerator;
import dev.whyoleg.cryptography.operations.SignatureVerifier;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyStateKt;
import dev.whyoleg.cryptography.providers.jdk.algorithms.EcdsaRawSignatureGenerator;
import dev.whyoleg.cryptography.providers.jdk.algorithms.EcdsaRawSignatureVerifier;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkEc;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkEcKt;
import dev.whyoleg.cryptography.providers.jdk.operations.JdkSignatureGenerator;
import dev.whyoleg.cryptography.providers.jdk.operations.JdkSignatureVerifier;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECKey;
import java.security.spec.ECParameterSpec;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u00020\u0005:\u0003\u0011\u0012\u0013B\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002*\u00060\u000bj\u0002`\fH\u0014J\u0010\u0010\n\u001a\u00020\u0003*\u00060\rj\u0002`\u000eH\u0014J\u0010\u0010\n\u001a\u00020\u0004*\u00060\u000fj\u0002`\u0010H\u0014\u00a8\u0006\u0014"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEcdsa;", "Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc;", "Ldev/whyoleg/cryptography/algorithms/ECDSA$PublicKey;", "Ldev/whyoleg/cryptography/algorithms/ECDSA$PrivateKey;", "Ldev/whyoleg/cryptography/algorithms/ECDSA$KeyPair;", "Ldev/whyoleg/cryptography/algorithms/ECDSA;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;)V", "convert", "Ljava/security/PublicKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPublicKey;", "Ljava/security/PrivateKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPrivateKey;", "Ljava/security/KeyPair;", "Ldev/whyoleg/cryptography/providers/jdk/JKeyPair;", "EcdsaKeyPair", "EcdsaPublicKey", "EcdsaPrivateKey", "cryptography-provider-jdk"})
public final class JdkEcdsa
extends JdkEc<ECDSA.PublicKey, ECDSA.PrivateKey, ECDSA.KeyPair>
implements ECDSA {
    public JdkEcdsa(@NotNull JdkCryptographyState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(state, null);
    }

    @Override
    @NotNull
    protected ECDSA.PublicKey convert(@NotNull PublicKey $this$convert) {
        Intrinsics.checkNotNullParameter((Object)$this$convert, (String)"<this>");
        return new EcdsaPublicKey(this.getState(), $this$convert);
    }

    @Override
    @NotNull
    protected ECDSA.PrivateKey convert(@NotNull PrivateKey $this$convert) {
        Intrinsics.checkNotNullParameter((Object)$this$convert, (String)"<this>");
        return new EcdsaPrivateKey(this.getState(), $this$convert);
    }

    @Override
    @NotNull
    protected ECDSA.KeyPair convert(@NotNull KeyPair $this$convert) {
        Intrinsics.checkNotNullParameter((Object)$this$convert, (String)"<this>");
        PublicKey publicKey = $this$convert.getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getPublic(...)");
        ECDSA.PublicKey publicKey2 = this.convert(publicKey);
        PrivateKey privateKey = $this$convert.getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"getPrivate(...)");
        return new EcdsaKeyPair(publicKey2, this.convert(privateKey));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEcdsa$EcdsaKeyPair;", "Ldev/whyoleg/cryptography/algorithms/ECDSA$KeyPair;", "publicKey", "Ldev/whyoleg/cryptography/algorithms/ECDSA$PublicKey;", "privateKey", "Ldev/whyoleg/cryptography/algorithms/ECDSA$PrivateKey;", "<init>", "(Ldev/whyoleg/cryptography/algorithms/ECDSA$PublicKey;Ldev/whyoleg/cryptography/algorithms/ECDSA$PrivateKey;)V", "getPublicKey", "()Ldev/whyoleg/cryptography/algorithms/ECDSA$PublicKey;", "getPrivateKey", "()Ldev/whyoleg/cryptography/algorithms/ECDSA$PrivateKey;", "cryptography-provider-jdk"})
    private static final class EcdsaKeyPair
    implements ECDSA.KeyPair {
        @NotNull
        private final ECDSA.PublicKey publicKey;
        @NotNull
        private final ECDSA.PrivateKey privateKey;

        public EcdsaKeyPair(@NotNull ECDSA.PublicKey publicKey, @NotNull ECDSA.PrivateKey privateKey) {
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
            this.publicKey = publicKey;
            this.privateKey = privateKey;
        }

        @NotNull
        public ECDSA.PublicKey getPublicKey() {
            return this.publicKey;
        }

        @NotNull
        public ECDSA.PrivateKey getPrivateKey() {
            return this.privateKey;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEcdsa$EcdsaPrivateKey;", "Ldev/whyoleg/cryptography/algorithms/ECDSA$PrivateKey;", "Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc$BaseEcPrivateKey;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "key", "Ljava/security/PrivateKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPrivateKey;", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljava/security/PrivateKey;)V", "signatureGenerator", "Ldev/whyoleg/cryptography/operations/SignatureGenerator;", "digest", "Ldev/whyoleg/cryptography/CryptographyAlgorithmId;", "Ldev/whyoleg/cryptography/algorithms/Digest;", "format", "Ldev/whyoleg/cryptography/algorithms/ECDSA$SignatureFormat;", "cryptography-provider-jdk"})
    private static final class EcdsaPrivateKey
    extends JdkEc.BaseEcPrivateKey
    implements ECDSA.PrivateKey {
        @NotNull
        private final JdkCryptographyState state;
        @NotNull
        private final PrivateKey key;

        public EcdsaPrivateKey(@NotNull JdkCryptographyState state, @NotNull PrivateKey key) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super(key);
            this.state = state;
            this.key = key;
        }

        @NotNull
        public SignatureGenerator signatureGenerator(@NotNull CryptographyAlgorithmId<Digest> digest, @NotNull ECDSA.SignatureFormat format) {
            SignatureGenerator signatureGenerator;
            Intrinsics.checkNotNullParameter(digest, (String)"digest");
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            JdkSignatureGenerator generator = new JdkSignatureGenerator(this.state, this.key, JdkCryptographyStateKt.hashAlgorithmName(digest) + "withECDSA", null);
            switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
                case 1: {
                    signatureGenerator = generator;
                    break;
                }
                case 2: {
                    SignatureGenerator signatureGenerator2 = generator;
                    PrivateKey privateKey = this.key;
                    Intrinsics.checkNotNull((Object)privateKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECKey");
                    ECParameterSpec eCParameterSpec = ((ECKey)((Object)privateKey)).getParams();
                    Intrinsics.checkNotNullExpressionValue((Object)eCParameterSpec, (String)"getParams(...)");
                    signatureGenerator = new EcdsaRawSignatureGenerator(signatureGenerator2, JdkEcKt.curveOrderSize(eCParameterSpec));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return signatureGenerator;
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ECDSA.SignatureFormat.values().length];
                try {
                    nArray[ECDSA.SignatureFormat.DER.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ECDSA.SignatureFormat.RAW.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEcdsa$EcdsaPublicKey;", "Ldev/whyoleg/cryptography/algorithms/ECDSA$PublicKey;", "Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc$BaseEcPublicKey;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "key", "Ljava/security/PublicKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPublicKey;", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljava/security/PublicKey;)V", "signatureVerifier", "Ldev/whyoleg/cryptography/operations/SignatureVerifier;", "digest", "Ldev/whyoleg/cryptography/CryptographyAlgorithmId;", "Ldev/whyoleg/cryptography/algorithms/Digest;", "format", "Ldev/whyoleg/cryptography/algorithms/ECDSA$SignatureFormat;", "cryptography-provider-jdk"})
    private static final class EcdsaPublicKey
    extends JdkEc.BaseEcPublicKey
    implements ECDSA.PublicKey {
        @NotNull
        private final JdkCryptographyState state;
        @NotNull
        private final PublicKey key;

        public EcdsaPublicKey(@NotNull JdkCryptographyState state, @NotNull PublicKey key) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super(key);
            this.state = state;
            this.key = key;
        }

        @NotNull
        public SignatureVerifier signatureVerifier(@NotNull CryptographyAlgorithmId<Digest> digest, @NotNull ECDSA.SignatureFormat format) {
            SignatureVerifier signatureVerifier;
            Intrinsics.checkNotNullParameter(digest, (String)"digest");
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            JdkSignatureVerifier verifier = new JdkSignatureVerifier(this.state, this.key, JdkCryptographyStateKt.hashAlgorithmName(digest) + "withECDSA", null);
            switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
                case 1: {
                    signatureVerifier = verifier;
                    break;
                }
                case 2: {
                    SignatureVerifier signatureVerifier2 = verifier;
                    PublicKey publicKey = this.key;
                    Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECKey");
                    ECParameterSpec eCParameterSpec = ((ECKey)((Object)publicKey)).getParams();
                    Intrinsics.checkNotNullExpressionValue((Object)eCParameterSpec, (String)"getParams(...)");
                    signatureVerifier = new EcdsaRawSignatureVerifier(signatureVerifier2, JdkEcKt.curveOrderSize(eCParameterSpec));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return signatureVerifier;
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ECDSA.SignatureFormat.values().length];
                try {
                    nArray[ECDSA.SignatureFormat.DER.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ECDSA.SignatureFormat.RAW.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

