/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.operations.SecretDerivation;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.Pooled;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\f\u0012\b\u0012\u00060\u000fj\u0002`\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkPbkdf2SecretDerivation;", "Ldev/whyoleg/cryptography/operations/SecretDerivation;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "algorithm", "", "salt", "", "iterations", "", "outputSizeBits", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljava/lang/String;[BII)V", "factory", "Ldev/whyoleg/cryptography/providers/jdk/Pooled;", "Ljavax/crypto/SecretKeyFactory;", "Ldev/whyoleg/cryptography/providers/jdk/JSecretKeyFactory;", "deriveSecretToByteArrayBlocking", "input", "cryptography-provider-jdk"})
@SourceDebugExtension(value={"SMAP\nJdkPbkdf2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkPbkdf2.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/JdkPbkdf2SecretDerivation\n+ 2 pooling.kt\ndev/whyoleg/cryptography/providers/jdk/Pooled\n*L\n1#1,49:1\n41#2,5:50\n*S KotlinDebug\n*F\n+ 1 JdkPbkdf2.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/JdkPbkdf2SecretDerivation\n*L\n46#1:50,5\n*E\n"})
final class JdkPbkdf2SecretDerivation
implements SecretDerivation {
    @NotNull
    private final byte[] salt;
    private final int iterations;
    private final int outputSizeBits;
    @NotNull
    private final Pooled<SecretKeyFactory> factory;

    public JdkPbkdf2SecretDerivation(@NotNull JdkCryptographyState state, @NotNull String algorithm, @NotNull byte[] salt, int iterations, int outputSizeBits) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        this.salt = salt;
        this.iterations = iterations;
        this.outputSizeBits = outputSizeBits;
        this.factory = state.secretKeyFactory(algorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public byte[] deriveSecretToByteArrayBlocking(@NotNull byte[] input) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        char[] cArray = StringsKt.decodeToString$default((byte[])input, (int)0, (int)0, (boolean)true, (int)3, null).toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        PBEKeySpec spec = new PBEKeySpec(cArray, this.salt, this.iterations, this.outputSizeBits);
        Pooled<SecretKeyFactory> this_$iv = this.factory;
        boolean $i$f$use = false;
        Object instance$iv = Pooled.access$borrow(this_$iv);
        try {
            SecretKeyFactory it = (SecretKeyFactory)instance$iv;
            boolean bl = false;
            byArray = it.generateSecret(spec).getEncoded();
        }
        finally {
            Pooled.access$recycle(this_$iv, instance$iv);
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"use(...)");
        return byArray;
    }
}

