/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.algorithms.RSA;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.algorithms.RsaOaepPrivateKey;
import dev.whyoleg.cryptography.providers.jdk.algorithms.RsaOaepPublicKey;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/RsaOaepKeyPair;", "Ldev/whyoleg/cryptography/algorithms/RSA$OAEP$KeyPair;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "keyPair", "Ljava/security/KeyPair;", "Ldev/whyoleg/cryptography/providers/jdk/JKeyPair;", "hashAlgorithmName", "", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljava/security/KeyPair;Ljava/lang/String;)V", "publicKey", "Ldev/whyoleg/cryptography/algorithms/RSA$OAEP$PublicKey;", "getPublicKey", "()Ldev/whyoleg/cryptography/algorithms/RSA$OAEP$PublicKey;", "privateKey", "Ldev/whyoleg/cryptography/algorithms/RSA$OAEP$PrivateKey;", "getPrivateKey", "()Ldev/whyoleg/cryptography/algorithms/RSA$OAEP$PrivateKey;", "cryptography-provider-jdk"})
final class RsaOaepKeyPair
implements RSA.OAEP.KeyPair {
    @NotNull
    private final RSA.OAEP.PublicKey publicKey;
    @NotNull
    private final RSA.OAEP.PrivateKey privateKey;

    public RsaOaepKeyPair(@NotNull JdkCryptographyState state, @NotNull KeyPair keyPair, @NotNull String hashAlgorithmName) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        Intrinsics.checkNotNullParameter((Object)hashAlgorithmName, (String)"hashAlgorithmName");
        PublicKey publicKey = keyPair.getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getPublic(...)");
        this.publicKey = new RsaOaepPublicKey(state, publicKey, hashAlgorithmName);
        PrivateKey privateKey = keyPair.getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"getPrivate(...)");
        this.privateKey = new RsaOaepPrivateKey(state, privateKey, hashAlgorithmName);
    }

    @NotNull
    public RSA.OAEP.PublicKey getPublicKey() {
        return this.publicKey;
    }

    @NotNull
    public RSA.OAEP.PrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

