/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.algorithms.RSA;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.algorithms.RsaPkcs1KeyPair;
import dev.whyoleg.cryptography.providers.jdk.materials.JdkKeyPairGenerator;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.spec.RSAKeyGenParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f*\u00060\rj\u0002`\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u0002*\u00060\u0010j\u0002`\u0011H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/RsaPkcs1KeyPairGenerator;", "Ldev/whyoleg/cryptography/providers/jdk/materials/JdkKeyPairGenerator;", "Ldev/whyoleg/cryptography/algorithms/RSA$PKCS1$KeyPair;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "keyGenParameters", "Ljava/security/spec/RSAKeyGenParameterSpec;", "hashAlgorithmName", "", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljava/security/spec/RSAKeyGenParameterSpec;Ljava/lang/String;)V", "init", "", "Ljava/security/KeyPairGenerator;", "Ldev/whyoleg/cryptography/providers/jdk/JKeyPairGenerator;", "convert", "Ljava/security/KeyPair;", "Ldev/whyoleg/cryptography/providers/jdk/JKeyPair;", "cryptography-provider-jdk"})
final class RsaPkcs1KeyPairGenerator
extends JdkKeyPairGenerator<RSA.PKCS1.KeyPair> {
    @NotNull
    private final RSAKeyGenParameterSpec keyGenParameters;
    @NotNull
    private final String hashAlgorithmName;

    public RsaPkcs1KeyPairGenerator(@NotNull JdkCryptographyState state, @NotNull RSAKeyGenParameterSpec keyGenParameters, @NotNull String hashAlgorithmName) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)keyGenParameters, (String)"keyGenParameters");
        Intrinsics.checkNotNullParameter((Object)hashAlgorithmName, (String)"hashAlgorithmName");
        super(state, "RSA");
        this.keyGenParameters = keyGenParameters;
        this.hashAlgorithmName = hashAlgorithmName;
    }

    @Override
    protected void init(@NotNull KeyPairGenerator $this$init) {
        Intrinsics.checkNotNullParameter((Object)$this$init, (String)"<this>");
        $this$init.initialize(this.keyGenParameters, this.getState().getSecureRandom());
    }

    @Override
    @NotNull
    protected RSA.PKCS1.KeyPair convert(@NotNull KeyPair $this$convert) {
        Intrinsics.checkNotNullParameter((Object)$this$convert, (String)"<this>");
        return new RsaPkcs1KeyPair(this.getState(), $this$convert, this.hashAlgorithmName);
    }
}

