/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.algorithms.RSA;
import dev.whyoleg.cryptography.providers.base.materials.KeysKt;
import dev.whyoleg.cryptography.providers.jdk.materials.JdkEncodableKey;
import dev.whyoleg.cryptography.serialization.asn1.ObjectIdentifier;
import dev.whyoleg.cryptography.serialization.asn1.modules.RSAKt;
import dev.whyoleg.cryptography.serialization.pem.PemLabel;
import java.security.PrivateKey;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/RsaPrivateEncodableKey;", "Ldev/whyoleg/cryptography/providers/jdk/materials/JdkEncodableKey;", "Ldev/whyoleg/cryptography/algorithms/RSA$PrivateKey$Format;", "key", "Ljava/security/PrivateKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPrivateKey;", "<init>", "(Ljava/security/PrivateKey;)V", "encodeToByteArrayBlocking", "", "format", "cryptography-provider-jdk"})
public abstract class RsaPrivateEncodableKey
extends JdkEncodableKey<RSA.PrivateKey.Format> {
    public RsaPrivateEncodableKey(@NotNull PrivateKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        super(key);
    }

    @NotNull
    public byte[] encodeToByteArrayBlocking(@NotNull RSA.PrivateKey.Format format) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        RSA.PrivateKey.Format format2 = format;
        if (Intrinsics.areEqual((Object)format2, (Object)RSA.PrivateKey.Format.JWK.INSTANCE)) {
            throw new IllegalStateException((format + " is not supported").toString());
        }
        if (Intrinsics.areEqual((Object)format2, (Object)RSA.PrivateKey.Format.DER.Generic)) {
            byArray = this.encodeToDer();
        } else if (Intrinsics.areEqual((Object)format2, (Object)RSA.PrivateKey.Format.PEM.Generic)) {
            byArray = KeysKt.wrapPem-unSj4pc((String)PemLabel.Companion.getPrivateKey-2EFq_Wg(), (byte[])this.encodeToDer());
        } else if (Intrinsics.areEqual((Object)format2, (Object)RSA.PrivateKey.Format.DER.PKCS1.INSTANCE)) {
            byArray = KeysKt.unwrapPrivateKeyInfo-4RESAxk((String)RSAKt.getRSA((ObjectIdentifier.Companion)ObjectIdentifier.Companion), (byte[])this.encodeToDer());
        } else if (Intrinsics.areEqual((Object)format2, (Object)RSA.PrivateKey.Format.PEM.PKCS1.INSTANCE)) {
            byArray = KeysKt.wrapPem-unSj4pc((String)PemLabel.Companion.getRsaPrivateKey-2EFq_Wg(), (byte[])KeysKt.unwrapPrivateKeyInfo-4RESAxk((String)RSAKt.getRSA((ObjectIdentifier.Companion)ObjectIdentifier.Companion), (byte[])this.encodeToDer()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return byArray;
    }
}

