/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.algorithms.RSA;
import dev.whyoleg.cryptography.providers.base.materials.KeysKt;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.materials.JdkPublicKeyDecoder;
import dev.whyoleg.cryptography.serialization.asn1.modules.KeyAlgorithmIdentifier;
import dev.whyoleg.cryptography.serialization.asn1.modules.RsaKeyAlgorithmIdentifier;
import dev.whyoleg.cryptography.serialization.pem.PemLabel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\t\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/RsaPublicKeyDecoder;", "K", "Ldev/whyoleg/cryptography/algorithms/RSA$PublicKey;", "Ldev/whyoleg/cryptography/providers/jdk/materials/JdkPublicKeyDecoder;", "Ldev/whyoleg/cryptography/algorithms/RSA$PublicKey$Format;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;)V", "decodeFromByteArrayBlocking", "format", "bytes", "", "(Ldev/whyoleg/cryptography/algorithms/RSA$PublicKey$Format;[B)Ldev/whyoleg/cryptography/algorithms/RSA$PublicKey;", "cryptography-provider-jdk"})
public abstract class RsaPublicKeyDecoder<K extends RSA.PublicKey>
extends JdkPublicKeyDecoder<RSA.PublicKey.Format, K> {
    public RsaPublicKeyDecoder(@NotNull JdkCryptographyState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(state, "RSA", null, 4, null);
    }

    @NotNull
    public K decodeFromByteArrayBlocking(@NotNull RSA.PublicKey.Format format, @NotNull byte[] bytes) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        RSA.PublicKey.Format format2 = format;
        if (Intrinsics.areEqual((Object)format2, (Object)RSA.PublicKey.Format.JWK.INSTANCE)) {
            throw new IllegalStateException((format + " is not supported").toString());
        }
        if (Intrinsics.areEqual((Object)format2, (Object)RSA.PublicKey.Format.DER.Generic)) {
            byArray = bytes;
        } else if (Intrinsics.areEqual((Object)format2, (Object)RSA.PublicKey.Format.PEM.Generic)) {
            byArray = KeysKt.unwrapPem-unSj4pc((String)PemLabel.Companion.getPublicKey-2EFq_Wg(), (byte[])bytes);
        } else if (Intrinsics.areEqual((Object)format2, (Object)RSA.PublicKey.Format.DER.PKCS1.INSTANCE)) {
            byArray = KeysKt.wrapSubjectPublicKeyInfo((KeyAlgorithmIdentifier)((KeyAlgorithmIdentifier)RsaKeyAlgorithmIdentifier.INSTANCE), (byte[])bytes);
        } else if (Intrinsics.areEqual((Object)format2, (Object)RSA.PublicKey.Format.PEM.PKCS1.INSTANCE)) {
            byArray = KeysKt.wrapSubjectPublicKeyInfo((KeyAlgorithmIdentifier)((KeyAlgorithmIdentifier)RsaKeyAlgorithmIdentifier.INSTANCE), (byte[])KeysKt.unwrapPem-unSj4pc((String)PemLabel.Companion.getRsaPublicKey-2EFq_Wg(), (byte[])bytes));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (K)((RSA.PublicKey)this.decodeFromDer(byArray));
    }
}

