/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.BinarySize;
import dev.whyoleg.cryptography.providers.base.operations.BaseDecryptor;
import dev.whyoleg.cryptography.providers.base.operations.CipherFunction;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.Pooled;
import dev.whyoleg.cryptography.providers.jdk.operations.JdkCipherFunction;
import java.security.Key;
import java.security.PrivateKey;
import java.security.interfaces.RSAKey;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\f\u0012\b\u0012\u00060\u000bj\u0002`\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/RsaRawDecryptor;", "Ldev/whyoleg/cryptography/providers/base/operations/BaseDecryptor;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "key", "Ljava/security/PrivateKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPrivateKey;", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljava/security/PrivateKey;)V", "cipher", "Ldev/whyoleg/cryptography/providers/jdk/Pooled;", "Ljavax/crypto/Cipher;", "Ldev/whyoleg/cryptography/providers/jdk/JCipher;", "outputSize", "", "createDecryptFunction", "Ldev/whyoleg/cryptography/providers/base/operations/CipherFunction;", "RsaRawDecryptFunction", "cryptography-provider-jdk"})
@SourceDebugExtension(value={"SMAP\nJdkRsaRaw.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkRsaRaw.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/RsaRawDecryptor\n+ 2 pooling.kt\ndev/whyoleg/cryptography/providers/jdk/Pooled\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n38#2:159\n1#3:160\n*S KotlinDebug\n*F\n+ 1 JdkRsaRaw.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/RsaRawDecryptor\n*L\n110#1:159\n110#1:160\n*E\n"})
final class RsaRawDecryptor
implements BaseDecryptor {
    @NotNull
    private final JdkCryptographyState state;
    @NotNull
    private final PrivateKey key;
    @NotNull
    private final Pooled<Cipher> cipher;
    private final int outputSize;

    public RsaRawDecryptor(@NotNull JdkCryptographyState state, @NotNull PrivateKey key) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.state = state;
        this.key = key;
        this.cipher = this.state.cipher("RSA/ECB/NoPadding");
        PrivateKey privateKey = this.key;
        Intrinsics.checkNotNull((Object)privateKey, (String)"null cannot be cast to non-null type java.security.interfaces.RSAKey");
        this.outputSize = BinarySize.getInBytes-impl((int)BinarySize.Companion.getBits-M1VWhS4(((RSAKey)((Object)privateKey)).getModulus().bitLength()));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CipherFunction createDecryptFunction() {
        void $this$createDecryptFunction_u24lambda_u240;
        Pooled.Resource<Cipher> resource;
        Pooled<Cipher> this_$iv = this.cipher;
        boolean $i$f$borrowResource = false;
        Pooled.Resource<Cipher> $this$borrowResource_u24lambda_u240$iv = resource = this_$iv.borrowResource();
        boolean bl = false;
        Cipher cipher = $this$borrowResource_u24lambda_u240$iv.access();
        int n = this.outputSize;
        boolean bl2 = false;
        $this$createDecryptFunction_u24lambda_u240.init(2, (Key)this.key, this.state.getSecureRandom());
        Unit unit = Unit.INSTANCE;
        Pooled.Resource<Cipher> resource2 = resource;
        int n2 = n;
        return (CipherFunction)new RsaRawDecryptFunction(n2, resource2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0014J\b\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0003H\u0014J \u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0014J0\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0014J\u0014\u0010\u0016\u001a\u00020\r*\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/RsaRawDecryptor$RsaRawDecryptFunction;", "Ldev/whyoleg/cryptography/providers/jdk/operations/JdkCipherFunction;", "outputSize", "", "cipher", "Ldev/whyoleg/cryptography/providers/jdk/Pooled$Resource;", "Ljavax/crypto/Cipher;", "Ldev/whyoleg/cryptography/providers/jdk/JCipher;", "<init>", "(ILdev/whyoleg/cryptography/providers/jdk/Pooled$Resource;)V", "maxOutputSize", "inputSize", "finalizeToByteArray", "", "finalizeIntoByteArray", "destination", "destinationOffset", "transformAndFinalizeToByteArray", "source", "startIndex", "endIndex", "transformAndFinalizeIntoByteArray", "pad", "size", "cryptography-provider-jdk"})
    private static final class RsaRawDecryptFunction
    extends JdkCipherFunction {
        private final int outputSize;

        public RsaRawDecryptFunction(int outputSize, @NotNull Pooled.Resource<Cipher> cipher) {
            Intrinsics.checkNotNullParameter(cipher, (String)"cipher");
            super(cipher);
            this.outputSize = outputSize;
        }

        @Override
        protected int maxOutputSize(int inputSize) {
            return this.outputSize;
        }

        @Override
        @NotNull
        protected byte[] finalizeToByteArray() {
            return this.pad(super.finalizeToByteArray(), this.outputSize);
        }

        @Override
        protected int finalizeIntoByteArray(@NotNull byte[] destination, int destinationOffset) {
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            super.finalizeIntoByteArray(destination, destinationOffset);
            return this.outputSize;
        }

        @Override
        @NotNull
        protected byte[] transformAndFinalizeToByteArray(@NotNull byte[] source, int startIndex, int endIndex) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return this.pad(super.transformAndFinalizeToByteArray(source, startIndex, endIndex), this.outputSize);
        }

        @Override
        protected int transformAndFinalizeIntoByteArray(@NotNull byte[] source, @NotNull byte[] destination, int destinationOffset, int startIndex, int endIndex) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            super.transformAndFinalizeIntoByteArray(source, destination, destinationOffset, startIndex, endIndex);
            return this.outputSize;
        }

        private final byte[] pad(byte[] $this$pad, int size) {
            byte[] byArray;
            if ($this$pad.length == size) {
                return $this$pad;
            }
            byte[] it = byArray = new byte[size];
            boolean bl = false;
            ArraysKt.copyInto$default((byte[])$this$pad, (byte[])it, (int)(size - $this$pad.length), (int)0, (int)0, (int)12, null);
            return byArray;
        }
    }
}

