/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.providers.base.operations.BaseEncryptor;
import dev.whyoleg.cryptography.providers.base.operations.CipherFunction;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.Pooled;
import dev.whyoleg.cryptography.providers.jdk.operations.JdkCipherFunction;
import java.security.Key;
import java.security.PublicKey;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\f\u0012\b\u0012\u00060\u000bj\u0002`\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/RsaRawEncryptor;", "Ldev/whyoleg/cryptography/providers/base/operations/BaseEncryptor;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "key", "Ljava/security/PublicKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPublicKey;", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljava/security/PublicKey;)V", "cipher", "Ldev/whyoleg/cryptography/providers/jdk/Pooled;", "Ljavax/crypto/Cipher;", "Ldev/whyoleg/cryptography/providers/jdk/JCipher;", "createEncryptFunction", "Ldev/whyoleg/cryptography/providers/base/operations/CipherFunction;", "cryptography-provider-jdk"})
@SourceDebugExtension(value={"SMAP\nJdkRsaRaw.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkRsaRaw.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/RsaRawEncryptor\n+ 2 pooling.kt\ndev/whyoleg/cryptography/providers/jdk/Pooled\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n38#2:159\n1#3:160\n*S KotlinDebug\n*F\n+ 1 JdkRsaRaw.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/RsaRawEncryptor\n*L\n96#1:159\n96#1:160\n*E\n"})
final class RsaRawEncryptor
implements BaseEncryptor {
    @NotNull
    private final JdkCryptographyState state;
    @NotNull
    private final PublicKey key;
    @NotNull
    private final Pooled<Cipher> cipher;

    public RsaRawEncryptor(@NotNull JdkCryptographyState state, @NotNull PublicKey key) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.state = state;
        this.key = key;
        this.cipher = this.state.cipher("RSA/ECB/NoPadding");
    }

    @NotNull
    public CipherFunction createEncryptFunction() {
        Pooled.Resource<Cipher> resource;
        Pooled<Cipher> this_$iv = this.cipher;
        boolean $i$f$borrowResource = false;
        Pooled.Resource<Cipher> $this$borrowResource_u24lambda_u240$iv = resource = this_$iv.borrowResource();
        boolean bl = false;
        Cipher $this$createEncryptFunction_u24lambda_u240 = $this$borrowResource_u24lambda_u240$iv.access();
        boolean bl2 = false;
        $this$createEncryptFunction_u24lambda_u240.init(1, (Key)this.key, this.state.getSecureRandom());
        Pooled.Resource<Cipher> resource2 = resource;
        return (CipherFunction)new JdkCipherFunction(resource2);
    }
}

