/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.algorithms.RSA;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.algorithms.RsaRawPrivateKey;
import dev.whyoleg.cryptography.providers.jdk.algorithms.RsaRawPublicKey;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/RsaRawKeyPair;", "Ldev/whyoleg/cryptography/algorithms/RSA$RAW$KeyPair;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "keyPair", "Ljava/security/KeyPair;", "Ldev/whyoleg/cryptography/providers/jdk/JKeyPair;", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljava/security/KeyPair;)V", "publicKey", "Ldev/whyoleg/cryptography/algorithms/RSA$RAW$PublicKey;", "getPublicKey", "()Ldev/whyoleg/cryptography/algorithms/RSA$RAW$PublicKey;", "privateKey", "Ldev/whyoleg/cryptography/algorithms/RSA$RAW$PrivateKey;", "getPrivateKey", "()Ldev/whyoleg/cryptography/algorithms/RSA$RAW$PrivateKey;", "cryptography-provider-jdk"})
final class RsaRawKeyPair
implements RSA.RAW.KeyPair {
    @NotNull
    private final RSA.RAW.PublicKey publicKey;
    @NotNull
    private final RSA.RAW.PrivateKey privateKey;

    public RsaRawKeyPair(@NotNull JdkCryptographyState state, @NotNull KeyPair keyPair) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        PublicKey publicKey = keyPair.getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getPublic(...)");
        this.publicKey = new RsaRawPublicKey(state, publicKey);
        PrivateKey privateKey = keyPair.getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"getPrivate(...)");
        this.privateKey = new RsaRawPrivateKey(state, privateKey);
    }

    @NotNull
    public RSA.RAW.PublicKey getPublicKey() {
        return this.publicKey;
    }

    @NotNull
    public RSA.RAW.PrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

