/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.materials;

import dev.whyoleg.cryptography.materials.key.EncodableKey;
import dev.whyoleg.cryptography.materials.key.KeyFormat;
import java.security.Key;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0004J\b\u0010\u000b\u001a\u00020\nH\u0004R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/materials/JdkEncodableKey;", "KF", "Ldev/whyoleg/cryptography/materials/key/KeyFormat;", "Ldev/whyoleg/cryptography/materials/key/EncodableKey;", "key", "Ljava/security/Key;", "Ldev/whyoleg/cryptography/providers/jdk/JKey;", "<init>", "(Ljava/security/Key;)V", "encodeToRaw", "", "encodeToDer", "cryptography-provider-jdk"})
@SourceDebugExtension(value={"SMAP\nJdkEncodableKey.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkEncodableKey.kt\ndev/whyoleg/cryptography/providers/jdk/materials/JdkEncodableKey\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,24:1\n1#2:25\n*E\n"})
public abstract class JdkEncodableKey<KF extends KeyFormat>
implements EncodableKey<KF> {
    @NotNull
    private final Key key;

    public JdkEncodableKey(@NotNull Key key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.key = key;
    }

    @NotNull
    protected final byte[] encodeToRaw() {
        if (!Intrinsics.areEqual((Object)this.key.getFormat(), (Object)"RAW")) {
            boolean bl = false;
            String string = "Wrong JDK Key format, expected `RAW` got `" + this.key.getFormat() + '`';
            throw new IllegalStateException(string.toString());
        }
        byte[] byArray = this.key.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return byArray;
    }

    @NotNull
    protected final byte[] encodeToDer() {
        if (!(Intrinsics.areEqual((Object)this.key.getFormat(), (Object)"PKCS#8") || Intrinsics.areEqual((Object)this.key.getFormat(), (Object)"X.509"))) {
            boolean bl = false;
            String string = "Wrong JDK Key format, expected `PKCS#8` or `X.509 got `" + this.key.getFormat() + '`';
            throw new IllegalStateException(string.toString());
        }
        byte[] byArray = this.key.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return byArray;
    }
}

