/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.operations;

import dev.whyoleg.cryptography.providers.base.BytesKt;
import dev.whyoleg.cryptography.providers.base.operations.BaseCipherFunction;
import dev.whyoleg.cryptography.providers.jdk.Pooled;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\u0019\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0014J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0014J0\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0014J\b\u0010\u0016\u001a\u00020\u000fH\u0014J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\tH\u0014J \u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0014J0\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/operations/JdkCipherFunction;", "Ldev/whyoleg/cryptography/providers/base/operations/BaseCipherFunction;", "cipher", "Ldev/whyoleg/cryptography/providers/jdk/Pooled$Resource;", "Ljavax/crypto/Cipher;", "Ldev/whyoleg/cryptography/providers/jdk/JCipher;", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/Pooled$Resource;)V", "blockSize", "", "getBlockSize", "()I", "maxOutputSize", "inputSize", "transformToByteArray", "", "source", "startIndex", "endIndex", "transformIntoByteArray", "destination", "destinationOffset", "finalizeToByteArray", "finalizeIntoByteArray", "transformAndFinalizeToByteArray", "transformAndFinalizeIntoByteArray", "close", "", "cryptography-provider-jdk"})
public class JdkCipherFunction
extends BaseCipherFunction {
    @NotNull
    private final Pooled.Resource<Cipher> cipher;

    public JdkCipherFunction(@NotNull Pooled.Resource<Cipher> cipher) {
        Intrinsics.checkNotNullParameter(cipher, (String)"cipher");
        this.cipher = cipher;
    }

    protected int getBlockSize() {
        return this.cipher.access().getBlockSize();
    }

    protected int maxOutputSize(int inputSize) {
        return this.cipher.access().getOutputSize(inputSize);
    }

    @NotNull
    protected byte[] transformToByteArray(@NotNull byte[] source, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        BytesKt.checkBounds((int)source.length, (int)startIndex, (int)endIndex);
        Cipher cipher = this.cipher.access();
        byte[] byArray = cipher.update(source, startIndex, endIndex - startIndex);
        if (byArray == null) {
            byArray = BytesKt.getEmptyByteArray();
        }
        return byArray;
    }

    protected int transformIntoByteArray(@NotNull byte[] source, @NotNull byte[] destination, int destinationOffset, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        BytesKt.checkBounds((int)source.length, (int)startIndex, (int)endIndex);
        BytesKt.checkBounds((int)destination.length, (int)destinationOffset, (int)(destinationOffset + this.maxOutputSize(endIndex - startIndex)));
        Cipher cipher = this.cipher.access();
        return cipher.update(source, startIndex, endIndex - startIndex, destination, destinationOffset);
    }

    @NotNull
    protected byte[] finalizeToByteArray() {
        Cipher cipher = this.cipher.access();
        byte[] byArray = cipher.doFinal();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
        return byArray;
    }

    protected int finalizeIntoByteArray(@NotNull byte[] destination, int destinationOffset) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        BytesKt.checkBounds((int)destination.length, (int)destinationOffset, (int)(destinationOffset + this.maxOutputSize(0)));
        Cipher cipher = this.cipher.access();
        return cipher.doFinal(destination, destinationOffset);
    }

    @NotNull
    protected byte[] transformAndFinalizeToByteArray(@NotNull byte[] source, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        BytesKt.checkBounds((int)source.length, (int)startIndex, (int)endIndex);
        Cipher cipher = this.cipher.access();
        byte[] byArray = cipher.doFinal(source, startIndex, endIndex - startIndex);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
        return byArray;
    }

    protected int transformAndFinalizeIntoByteArray(@NotNull byte[] source, @NotNull byte[] destination, int destinationOffset, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        BytesKt.checkBounds((int)source.length, (int)startIndex, (int)endIndex);
        BytesKt.checkBounds((int)destination.length, (int)destinationOffset, (int)(destinationOffset + this.maxOutputSize(endIndex - startIndex)));
        Cipher cipher = this.cipher.access();
        return cipher.doFinal(source, startIndex, endIndex - startIndex, destination, destinationOffset);
    }

    public void close() {
        this.cipher.close();
    }
}

