/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.serialization.asn1.internal;

import dev.whyoleg.cryptography.serialization.asn1.internal.ByteArrayInputKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0005J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0005J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Ldev/whyoleg/cryptography/serialization/asn1/internal/ByteArrayInput;", "", "array", "", "startIndex", "", "endIndex", "<init>", "([BII)V", "position", "available", "getAvailable", "()I", "eof", "", "getEof", "()Z", "toString", "", "peak", "", "read", "length", "readSlice", "ensureAvailableBytes", "", "count", "cryptography-serialization-asn1"})
@SourceDebugExtension(value={"SMAP\nByteArrayInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteArrayInput.kt\ndev/whyoleg/cryptography/serialization/asn1/internal/ByteArrayInput\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public final class ByteArrayInput {
    @NotNull
    private final byte[] array;
    private final int endIndex;
    private int position;

    public ByteArrayInput(@NotNull byte[] array, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.array = array;
        this.endIndex = endIndex;
        this.position = startIndex;
    }

    public /* synthetic */ ByteArrayInput(byte[] byArray, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        this(byArray, n, n2);
    }

    private final int getAvailable() {
        return this.endIndex - this.position;
    }

    public final boolean getEof() {
        return this.getAvailable() == 0;
    }

    @NotNull
    public String toString() {
        return "ByteArrayInput(size=" + this.array.length + ", endIndex=" + this.endIndex + ", position=" + this.position + ", available=" + this.getAvailable() + ')';
    }

    public final byte peak() {
        this.ensureAvailableBytes(1);
        return this.array[this.position];
    }

    public final byte read() {
        this.ensureAvailableBytes(1);
        int n = this.position;
        this.position = n + 1;
        return this.array[n];
    }

    @NotNull
    public final byte[] read(int length) {
        this.ensureAvailableBytes(length);
        if (length == 0) {
            return ByteArrayInputKt.access$getEmptyArray$p();
        }
        byte[] byArray = this.array;
        int n = this.position;
        int n2 = this.position + length;
        byte[] it = byArray = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
        boolean bl = false;
        this.position += length;
        return byArray;
    }

    @NotNull
    public final ByteArrayInput readSlice(int length) {
        ByteArrayInput byteArrayInput;
        this.ensureAvailableBytes(length);
        if (length == 0) {
            return new ByteArrayInput(ByteArrayInputKt.access$getEmptyArray$p(), 0, 0, 6, null);
        }
        ByteArrayInput it = byteArrayInput = new ByteArrayInput(this.array, this.position, this.position + length);
        boolean bl = false;
        this.position += length;
        return byteArrayInput;
    }

    private final void ensureAvailableBytes(int count) {
        if (!(this.getAvailable() >= count)) {
            boolean bl = false;
            String string = "Unexpected EOF, available " + this.getAvailable() + " bytes, requested: " + count;
            throw new IllegalStateException(string.toString());
        }
    }
}

