/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.serialization.asn1.internal;

import dev.whyoleg.cryptography.serialization.asn1.ContextSpecificTag;
import dev.whyoleg.cryptography.serialization.asn1.internal.ByteArrayInput;
import dev.whyoleg.cryptography.serialization.asn1.internal.DerTagKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001aG\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u00010\t\u00a2\u0006\u0002\b\nH\u0082\b\u00a2\u0006\u0002\u0010\u000b\u001a\u0018\u0010\f\u001a\u00020\r*\u00020\u00022\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0002\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0002H\u0002\u001a\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0002H\u0002\u001a\f\u0010\u0012\u001a\u00020\u000f*\u00020\u0002H\u0002\u00a8\u0006\u0013"}, d2={"readTagWithOverride", "T", "Ldev/whyoleg/cryptography/serialization/asn1/internal/ByteArrayInput;", "tagOverride", "Ldev/whyoleg/cryptography/serialization/asn1/ContextSpecificTag;", "tag", "", "Ldev/whyoleg/cryptography/serialization/asn1/internal/DerTag;", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Ldev/whyoleg/cryptography/serialization/asn1/internal/ByteArrayInput;Ldev/whyoleg/cryptography/serialization/asn1/ContextSpecificTag;BLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "readRequestedTag", "", "readLength", "", "readOidElements", "", "readOidElement", "cryptography-serialization-asn1"})
@SourceDebugExtension(value={"SMAP\nDerInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DerInput.kt\ndev/whyoleg/cryptography/serialization/asn1/internal/DerInputKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1#2:135\n*E\n"})
public final class DerInputKt {
    private static final <T> T readTagWithOverride(ByteArrayInput $this$readTagWithOverride, ContextSpecificTag tagOverride, byte tag, Function1<? super ByteArrayInput, ? extends T> block) {
        Object object;
        boolean $i$f$readTagWithOverride = false;
        if (tagOverride == null) {
            DerInputKt.readRequestedTag($this$readTagWithOverride, tag);
            return (T)block.invoke((Object)$this$readTagWithOverride);
        }
        DerInputKt.readRequestedTag($this$readTagWithOverride, DerTagKt.getTag(tagOverride));
        switch (WhenMappings.$EnumSwitchMapping$0[tagOverride.type().ordinal()]) {
            case 1: {
                object = block.invoke((Object)$this$readTagWithOverride);
                break;
            }
            case 2: {
                int length = DerInputKt.readLength($this$readTagWithOverride);
                ByteArrayInput explicitInput = $this$readTagWithOverride.readSlice(length);
                DerInputKt.readRequestedTag(explicitInput, tag);
                object = block.invoke((Object)explicitInput);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (T)object;
    }

    private static final void readRequestedTag(ByteArrayInput $this$readRequestedTag, byte tag) {
        byte currentTag = $this$readRequestedTag.read();
        if (!(currentTag == tag)) {
            boolean bl = false;
            String string = "Requested tag '" + DerTagKt.DerTag_name(tag) + "', received: '" + DerTagKt.DerTag_name(currentTag) + '\'';
            throw new IllegalStateException(string.toString());
        }
    }

    private static final int readLength(ByteArrayInput $this$readLength) {
        byte first = $this$readLength.read();
        if (first >= 0) {
            return first;
        }
        int numberOfLengthBytes = first & 0x7F;
        if (!(numberOfLengthBytes <= 4)) {
            boolean bl = false;
            String string = "Supported number of bytes for tag length are in range 1..4, but was: " + numberOfLengthBytes + ' ';
            throw new IllegalStateException(string.toString());
        }
        int length = 0;
        int n = 0;
        while (n < numberOfLengthBytes) {
            int it = n++;
            boolean bl = false;
            length = (length << 8) + ($this$readLength.read() & 0xFF);
        }
        if (!(length > 0)) {
            boolean bl = false;
            String string = "length overflow: " + length;
            throw new IllegalStateException(string.toString());
        }
        return length;
    }

    private static final String readOidElements(ByteArrayInput $this$readOidElements) {
        StringBuilder stringBuilder;
        StringBuilder $this$readOidElements_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int first = DerInputKt.readOidElement($this$readOidElements);
        StringBuilder stringBuilder2 = first < 40 ? $this$readOidElements_u24lambda_u244.append('0').append('.').append(first) : (first < 80 ? $this$readOidElements_u24lambda_u244.append('1').append('.').append(first - 40) : $this$readOidElements_u24lambda_u244.append('2').append('.').append(first - 80));
        while (!$this$readOidElements.getEof()) {
            $this$readOidElements_u24lambda_u244.append('.').append(DerInputKt.readOidElement($this$readOidElements));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final int readOidElement(ByteArrayInput $this$readOidElement) {
        byte b;
        int element = 0;
        do {
            b = $this$readOidElement.read();
            element = (element << 7) + (b & 0x7F);
        } while ((b & 0x80) == 128);
        if (!(element >= 0)) {
            boolean bl = false;
            String string = "element overflow: " + element;
            throw new IllegalStateException(string.toString());
        }
        return element;
    }

    public static final /* synthetic */ String access$readOidElements(ByteArrayInput $receiver) {
        return DerInputKt.readOidElements($receiver);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ContextSpecificTag.TagType.values().length];
            try {
                nArray[ContextSpecificTag.TagType.IMPLICIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ContextSpecificTag.TagType.EXPLICIT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

