/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.serialization.asn1.internal;

import dev.whyoleg.cryptography.serialization.asn1.ContextSpecificTag;
import dev.whyoleg.cryptography.serialization.asn1.internal.ByteArrayOutput;
import dev.whyoleg.cryptography.serialization.asn1.internal.DerTagKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\u001a<\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00010\t\u00a2\u0006\u0002\b\nH\u0082\b\u001a\u0014\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0014\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0002\u001a&\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00010\t\u00a2\u0006\u0002\b\nH\u0082\b\u001a\u0014\u0010\u000e\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001a\u0010\u0011\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002\u001a\u0014\u0010\u0015\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0010H\u0002\u00a8\u0006\u0017"}, d2={"writeTagWithOverride", "", "Ldev/whyoleg/cryptography/serialization/asn1/internal/ByteArrayOutput;", "tagOverride", "Ldev/whyoleg/cryptography/serialization/asn1/ContextSpecificTag;", "tag", "", "Ldev/whyoleg/cryptography/serialization/asn1/internal/DerTag;", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "writeBytes", "bytes", "", "writeLength", "length", "", "writeOidElements", "elements", "", "", "writeOidElement", "element", "cryptography-serialization-asn1"})
@SourceDebugExtension(value={"SMAP\nDerOutput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DerOutput.kt\ndev/whyoleg/cryptography/serialization/asn1/internal/DerOutputKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n84#1,2:115\n1#2:117\n*S KotlinDebug\n*F\n+ 1 DerOutput.kt\ndev/whyoleg/cryptography/serialization/asn1/internal/DerOutputKt\n*L\n66#1:115,2\n*E\n"})
public final class DerOutputKt {
    /*
     * WARNING - void declaration
     */
    private static final void writeTagWithOverride(ByteArrayOutput $this$writeTagWithOverride, ContextSpecificTag tagOverride, byte tag, Function1<? super ByteArrayOutput, Unit> block) {
        boolean $i$f$writeTagWithOverride = false;
        if (tagOverride == null) {
            $this$writeTagWithOverride.write(tag);
            block.invoke((Object)$this$writeTagWithOverride);
            return;
        }
        $this$writeTagWithOverride.write(DerTagKt.getTag(tagOverride));
        switch (WhenMappings.$EnumSwitchMapping$0[tagOverride.type().ordinal()]) {
            case 1: {
                block.invoke((Object)$this$writeTagWithOverride);
                break;
            }
            case 2: {
                void $this$writeTagWithOverride_u24lambda_u240;
                ByteArrayOutput byteArrayOutput;
                ByteArrayOutput $this$writeBytes$iv = $this$writeTagWithOverride;
                boolean $i$f$writeBytes = false;
                ByteArrayOutput byteArrayOutput2 = byteArrayOutput = new ByteArrayOutput();
                ByteArrayOutput byteArrayOutput3 = $this$writeBytes$iv;
                boolean bl = false;
                $this$writeTagWithOverride_u24lambda_u240.write(tag);
                block.invoke((Object)$this$writeTagWithOverride_u24lambda_u240);
                DerOutputKt.writeBytes(byteArrayOutput3, byteArrayOutput);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private static final void writeBytes(ByteArrayOutput $this$writeBytes, byte[] bytes) {
        DerOutputKt.writeLength($this$writeBytes, bytes.length);
        $this$writeBytes.write(bytes);
    }

    private static final void writeBytes(ByteArrayOutput $this$writeBytes, ByteArrayOutput bytes) {
        DerOutputKt.writeLength($this$writeBytes, bytes.getSize());
        $this$writeBytes.write(bytes);
    }

    private static final void writeBytes(ByteArrayOutput $this$writeBytes, Function1<? super ByteArrayOutput, Unit> block) {
        boolean $i$f$writeBytes = false;
        ByteArrayOutput byteArrayOutput = new ByteArrayOutput();
        block.invoke((Object)byteArrayOutput);
        DerOutputKt.writeBytes($this$writeBytes, byteArrayOutput);
    }

    private static final void writeLength(ByteArrayOutput $this$writeLength, int length) {
        if (length < 128) {
            $this$writeLength.write(length);
            return;
        }
        int numberOfLengthBytes = 4 - Integer.numberOfLeadingZeros(length) / 8;
        $this$writeLength.write(numberOfLengthBytes | 0x80);
        int n = 0;
        while (n < numberOfLengthBytes) {
            int it = n++;
            boolean bl = false;
            $this$writeLength.write(length >>> 8 * (numberOfLengthBytes - 1 - it));
        }
    }

    private static final void writeOidElements(ByteArrayOutput $this$writeOidElements, List<String> elements) {
        if (!(elements.size() >= 2)) {
            boolean bl = false;
            String string = "at least 2 components expected but was " + elements.size();
            throw new IllegalStateException(string.toString());
        }
        DerOutputKt.writeOidElement($this$writeOidElements, DerOutputKt.writeOidElements$element(elements, 0) * 40 + DerOutputKt.writeOidElements$element(elements, 1));
        int n = elements.size() - 2;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            DerOutputKt.writeOidElement($this$writeOidElements, DerOutputKt.writeOidElements$element(elements, it + 2));
        }
    }

    private static final void writeOidElement(ByteArrayOutput $this$writeOidElement, int element) {
        if (element < 128) {
            $this$writeOidElement.write(element);
            return;
        }
        int l = (32 - Integer.numberOfLeadingZeros(element)) / 7;
        for (int i = 0; i < l; ++i) {
            int it = i;
            boolean bl = false;
            int value = element >>> (l - it) * 7;
            if (value == 0) continue;
            $this$writeOidElement.write(value & 0x7F | 0x80);
        }
        $this$writeOidElement.write(element & 0x7F);
    }

    private static final int writeOidElements$element(List<String> $elements, int index) {
        return Integer.parseInt($elements.get(index));
    }

    public static final /* synthetic */ void access$writeLength(ByteArrayOutput $receiver, int length) {
        DerOutputKt.writeLength($receiver, length);
    }

    public static final /* synthetic */ void access$writeBytes(ByteArrayOutput $receiver, byte[] bytes) {
        DerOutputKt.writeBytes($receiver, bytes);
    }

    public static final /* synthetic */ void access$writeOidElements(ByteArrayOutput $receiver, List elements) {
        DerOutputKt.writeOidElements($receiver, elements);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ContextSpecificTag.TagType.values().length];
            try {
                nArray[ContextSpecificTag.TagType.IMPLICIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ContextSpecificTag.TagType.EXPLICIT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

