/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.serialization.asn1.internal;

import dev.whyoleg.cryptography.bigint.BigInt;
import dev.whyoleg.cryptography.bigint.BigIntKt;
import dev.whyoleg.cryptography.serialization.asn1.BitArray;
import dev.whyoleg.cryptography.serialization.asn1.ContextSpecificTag;
import dev.whyoleg.cryptography.serialization.asn1.Der;
import dev.whyoleg.cryptography.serialization.asn1.ObjectIdentifier;
import dev.whyoleg.cryptography.serialization.asn1.internal.ByteArrayOutput;
import dev.whyoleg.cryptography.serialization.asn1.internal.DerOutput;
import dev.whyoleg.cryptography.serialization.asn1.internal.DerTagKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0002J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0014H\u0016J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020#H\u0016J)\u0010$\u001a\u00020\u001a\"\u0004\b\u0000\u0010%2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0'2\u0006\u0010\u001d\u001a\u0002H%H\u0016\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u00101\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0010H\u0016J\u0010\u00106\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020;H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Ldev/whyoleg/cryptography/serialization/asn1/internal/DerEncoder;", "Lkotlinx/serialization/encoding/AbstractEncoder;", "der", "Ldev/whyoleg/cryptography/serialization/asn1/Der;", "byteArrayOutput", "Ldev/whyoleg/cryptography/serialization/asn1/internal/ByteArrayOutput;", "parentOutput", "Ldev/whyoleg/cryptography/serialization/asn1/internal/DerOutput;", "<init>", "(Ldev/whyoleg/cryptography/serialization/asn1/Der;Ldev/whyoleg/cryptography/serialization/asn1/internal/ByteArrayOutput;Ldev/whyoleg/cryptography/serialization/asn1/internal/DerOutput;)V", "output", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "shouldEncodeElementDefault", "", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "index", "", "tagOverride", "Ldev/whyoleg/cryptography/serialization/asn1/ContextSpecificTag;", "getAndResetTagOverride", "encodeElement", "encodeNotNullMark", "", "encodeNull", "encodeByte", "value", "", "encodeShort", "", "encodeInt", "encodeLong", "", "encodeSerializableValue", "T", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "beginStructure", "Lkotlinx/serialization/encoding/CompositeEncoder;", "endStructure", "encodeInline", "Lkotlinx/serialization/encoding/Encoder;", "encodeEnum", "", "enumDescriptor", "encodeString", "", "encodeChar", "", "encodeBoolean", "encodeFloat", "", "encodeDouble", "", "encodeValue", "", "cryptography-serialization-asn1"})
@SourceDebugExtension(value={"SMAP\nDerEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DerEncoder.kt\ndev/whyoleg/cryptography/serialization/asn1/internal/DerEncoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class DerEncoder
extends AbstractEncoder {
    @NotNull
    private final Der der;
    @Nullable
    private final DerOutput parentOutput;
    @NotNull
    private final DerOutput output;
    @Nullable
    private ContextSpecificTag tagOverride;

    public DerEncoder(@NotNull Der der, @NotNull ByteArrayOutput byteArrayOutput, @Nullable DerOutput parentOutput) {
        Intrinsics.checkNotNullParameter((Object)der, (String)"der");
        Intrinsics.checkNotNullParameter((Object)byteArrayOutput, (String)"byteArrayOutput");
        this.der = der;
        this.parentOutput = parentOutput;
        this.output = new DerOutput(byteArrayOutput);
    }

    public /* synthetic */ DerEncoder(Der der, ByteArrayOutput byteArrayOutput, DerOutput derOutput, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            derOutput = null;
        }
        this(der, byteArrayOutput, derOutput);
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.der.getSerializersModule();
    }

    public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return false;
    }

    private final ContextSpecificTag getAndResetTagOverride() {
        ContextSpecificTag tag = this.tagOverride;
        this.tagOverride = null;
        return tag;
    }

    public boolean encodeElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.tagOverride = DerTagKt.getElementContextSpecificTag(descriptor, index);
        return true;
    }

    public void encodeNotNullMark() {
    }

    public void encodeNull() {
        this.output.writeNull();
    }

    public void encodeByte(byte value) {
        this.output.writeInteger(this.getAndResetTagOverride(), BigIntKt.toBigInt((byte)value));
    }

    public void encodeShort(short value) {
        this.output.writeInteger(this.getAndResetTagOverride(), BigIntKt.toBigInt((short)value));
    }

    public void encodeInt(int value) {
        this.output.writeInteger(this.getAndResetTagOverride(), BigIntKt.toBigInt((int)value));
    }

    public void encodeLong(long value) {
        this.output.writeInteger(this.getAndResetTagOverride(), BigIntKt.toBigInt((long)value));
    }

    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer2, T value) {
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        SerialDescriptor serialDescriptor = serializer2.getDescriptor();
        if (Intrinsics.areEqual((Object)serialDescriptor, (Object)BuiltinSerializersKt.ByteArraySerializer().getDescriptor())) {
            ContextSpecificTag contextSpecificTag = this.getAndResetTagOverride();
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.ByteArray");
            this.output.writeOctetString(contextSpecificTag, (byte[])value);
        } else if (Intrinsics.areEqual((Object)serialDescriptor, (Object)BitArray.Companion.serializer().getDescriptor())) {
            ContextSpecificTag contextSpecificTag = this.getAndResetTagOverride();
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type dev.whyoleg.cryptography.serialization.asn1.BitArray");
            this.output.writeBitString(contextSpecificTag, (BitArray)value);
        } else if (Intrinsics.areEqual((Object)serialDescriptor, (Object)ObjectIdentifier.Companion.serializer().getDescriptor())) {
            ContextSpecificTag contextSpecificTag = this.getAndResetTagOverride();
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type dev.whyoleg.cryptography.serialization.asn1.ObjectIdentifier");
            this.output.writeObjectIdentifier-IHeWLgs(contextSpecificTag, ((ObjectIdentifier)value).unbox-impl());
        } else if (Intrinsics.areEqual((Object)serialDescriptor, (Object)BigInt.Companion.serializer().getDescriptor())) {
            ContextSpecificTag contextSpecificTag = this.getAndResetTagOverride();
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type dev.whyoleg.cryptography.bigint.BigInt");
            this.output.writeInteger(contextSpecificTag, (BigInt)value);
        } else {
            serializer2.serialize((Encoder)this, value);
        }
    }

    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        if (!Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE) && !(serialKind instanceof PolymorphicKind)) {
            throw new SerializationException("This serial kind is not supported as structure: " + descriptor);
        }
        return (CompositeEncoder)new DerEncoder(this.der, new ByteArrayOutput(), this.output);
    }

    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        DerOutput derOutput = this.parentOutput;
        if (derOutput == null) {
            boolean bl = false;
            String string = "Should be called after beginStructure";
            throw new IllegalStateException(string.toString());
        }
        derOutput.writeSequence(this.getAndResetTagOverride(), this.output);
    }

    @NotNull
    public Encoder encodeInline(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return (Encoder)this;
    }

    @NotNull
    public Void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        throw new IllegalStateException("Enum encoding is not supported".toString());
    }

    public void encodeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        throw new IllegalStateException("String encoding is not supported".toString());
    }

    public void encodeChar(char value) {
        throw new IllegalStateException("Char encoding is not supported".toString());
    }

    public void encodeBoolean(boolean value) {
        throw new IllegalStateException("Boolean encoding is not supported".toString());
    }

    public void encodeFloat(float value) {
        throw new IllegalStateException("Float encoding is not supported".toString());
    }

    public void encodeDouble(double value) {
        throw new IllegalStateException("Double encoding is not supported".toString());
    }

    public void encodeValue(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        throw new IllegalStateException("should not be called".toString());
    }
}

