/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.serialization.asn1.internal;

import dev.whyoleg.cryptography.bigint.BigInt;
import dev.whyoleg.cryptography.bigint.BigIntKt;
import dev.whyoleg.cryptography.serialization.asn1.BitArray;
import dev.whyoleg.cryptography.serialization.asn1.ContextSpecificTag;
import dev.whyoleg.cryptography.serialization.asn1.ObjectIdentifier;
import dev.whyoleg.cryptography.serialization.asn1.internal.ByteArrayInput;
import dev.whyoleg.cryptography.serialization.asn1.internal.DerInputKt;
import dev.whyoleg.cryptography.serialization.asn1.internal.DerTagKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\n\u001a\u00060\u000bj\u0002`\fJ\u0006\u0010\r\u001a\u00020\u0007J\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0010\u0010\u0016\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0017\u0010\u0018\u001a\u00020\u00192\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Ldev/whyoleg/cryptography/serialization/asn1/internal/DerInput;", "", "input", "Ldev/whyoleg/cryptography/serialization/asn1/internal/ByteArrayInput;", "<init>", "(Ldev/whyoleg/cryptography/serialization/asn1/internal/ByteArrayInput;)V", "eof", "", "getEof", "()Z", "peakTag", "", "Ldev/whyoleg/cryptography/serialization/asn1/internal/DerTag;", "isNotNull", "readNull", "", "readInteger", "Ldev/whyoleg/cryptography/bigint/BigInt;", "tagOverride", "Ldev/whyoleg/cryptography/serialization/asn1/ContextSpecificTag;", "readBitString", "Ldev/whyoleg/cryptography/serialization/asn1/BitArray;", "readOctetString", "", "readObjectIdentifier", "Ldev/whyoleg/cryptography/serialization/asn1/ObjectIdentifier;", "readObjectIdentifier-iVrrli8", "(Ldev/whyoleg/cryptography/serialization/asn1/ContextSpecificTag;)Ljava/lang/String;", "readSequence", "cryptography-serialization-asn1"})
@SourceDebugExtension(value={"SMAP\nDerInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DerInput.kt\ndev/whyoleg/cryptography/serialization/asn1/internal/DerInput\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 DerInput.kt\ndev/whyoleg/cryptography/serialization/asn1/internal/DerInputKt\n*L\n1#1,134:1\n1#2:135\n74#3,13:136\n74#3,13:149\n74#3,13:162\n74#3,13:175\n74#3,13:188\n*S KotlinDebug\n*F\n+ 1 DerInput.kt\ndev/whyoleg/cryptography/serialization/asn1/internal/DerInput\n*L\n25#1:136,13\n31#1:149,13\n52#1:162,13\n57#1:175,13\n63#1:188,13\n*E\n"})
public final class DerInput {
    @NotNull
    private final ByteArrayInput input;

    public DerInput(@NotNull ByteArrayInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = input;
    }

    public final boolean getEof() {
        return this.input.getEof();
    }

    public final byte peakTag() {
        return this.input.peak();
    }

    public final boolean isNotNull() {
        return this.peakTag() != 5;
    }

    @Nullable
    public final Void readNull() {
        DerInputKt.access$readRequestedTag(this.input, (byte)5);
        int length = DerInputKt.access$readLength(this.input);
        if (!(length == 0)) {
            boolean bl = false;
            String string = "NULL tag length should be zero, but was: " + length;
            throw new IllegalStateException(string.toString());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BigInt readInteger(@Nullable ContextSpecificTag tagOverride) {
        BigInt bigInt;
        void $this$readTagWithOverride$iv;
        void tagOverride$iv;
        ByteArrayInput byteArrayInput = this.input;
        ContextSpecificTag contextSpecificTag = tagOverride;
        byte tag$iv = 2;
        boolean $i$f$readTagWithOverride = false;
        if (tagOverride$iv == null) {
            DerInputKt.access$readRequestedTag((ByteArrayInput)$this$readTagWithOverride$iv, tag$iv);
            void $this$readInteger_u24lambda_u241 = $this$readTagWithOverride$iv;
            boolean bl = false;
            int length = DerInputKt.access$readLength((ByteArrayInput)$this$readInteger_u24lambda_u241);
            byte[] bytes = $this$readInteger_u24lambda_u241.read(length);
            bigInt = BigIntKt.decodeToBigInt((byte[])bytes);
        } else {
            DerInputKt.access$readRequestedTag((ByteArrayInput)$this$readTagWithOverride$iv, DerTagKt.getTag((ContextSpecificTag)tagOverride$iv));
            switch (DerInputKt.WhenMappings.$EnumSwitchMapping$0[tagOverride$iv.type().ordinal()]) {
                case 1: {
                    void $this$readInteger_u24lambda_u241 = $this$readTagWithOverride$iv;
                    boolean bl = false;
                    int length = DerInputKt.access$readLength((ByteArrayInput)$this$readInteger_u24lambda_u241);
                    byte[] bytes = $this$readInteger_u24lambda_u241.read(length);
                    bigInt = BigIntKt.decodeToBigInt((byte[])bytes);
                    break;
                }
                case 2: {
                    int length$iv = DerInputKt.access$readLength((ByteArrayInput)$this$readTagWithOverride$iv);
                    ByteArrayInput explicitInput$iv = $this$readTagWithOverride$iv.readSlice(length$iv);
                    DerInputKt.access$readRequestedTag(explicitInput$iv, tag$iv);
                    ByteArrayInput $this$readInteger_u24lambda_u241 = explicitInput$iv;
                    boolean bl = false;
                    int length = DerInputKt.access$readLength($this$readInteger_u24lambda_u241);
                    byte[] bytes = $this$readInteger_u24lambda_u241.read(length);
                    bigInt = BigIntKt.decodeToBigInt((byte[])bytes);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return bigInt;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BitArray readBitString(@Nullable ContextSpecificTag tagOverride) {
        BitArray bitArray;
        void $this$readTagWithOverride$iv;
        void tagOverride$iv;
        ByteArrayInput byteArrayInput = this.input;
        ContextSpecificTag contextSpecificTag = tagOverride;
        byte tag$iv = 3;
        boolean $i$f$readTagWithOverride = false;
        if (tagOverride$iv == null) {
            DerInputKt.access$readRequestedTag((ByteArrayInput)$this$readTagWithOverride$iv, tag$iv);
            void $this$readBitString_u24lambda_u244 = $this$readTagWithOverride$iv;
            boolean bl = false;
            int length = DerInputKt.access$readLength((ByteArrayInput)$this$readBitString_u24lambda_u244);
            byte unusedBits = $this$readBitString_u24lambda_u244.read();
            byte[] bytes = $this$readBitString_u24lambda_u244.read(length - 1);
            if (bytes.length == 0) {
                if (!(unusedBits == 0)) {
                    boolean $i$a$-check-DerInput$readBitString$1$32 = false;
                    String $i$a$-check-DerInput$readBitString$1$32 = "wrong number of unused bits, expected 0, received: " + unusedBits;
                    throw new IllegalStateException($i$a$-check-DerInput$readBitString$1$32.toString());
                }
            } else {
                int trailingZeros = Integer.numberOfTrailingZeros(ArraysKt.last((byte[])bytes) | 0x100);
                if (!(unusedBits <= trailingZeros)) {
                    boolean $i$a$-check-DerInput$readBitString$1$42 = false;
                    String $i$a$-check-DerInput$readBitString$1$42 = "Not all unused bits are zeros, expected at least " + unusedBits + " trailing zeros, received " + trailingZeros;
                    throw new IllegalStateException($i$a$-check-DerInput$readBitString$1$42.toString());
                }
            }
            bitArray = new BitArray(unusedBits, bytes);
        } else {
            DerInputKt.access$readRequestedTag((ByteArrayInput)$this$readTagWithOverride$iv, DerTagKt.getTag((ContextSpecificTag)tagOverride$iv));
            switch (DerInputKt.WhenMappings.$EnumSwitchMapping$0[tagOverride$iv.type().ordinal()]) {
                case 1: {
                    void $this$readBitString_u24lambda_u244 = $this$readTagWithOverride$iv;
                    boolean bl = false;
                    int length = DerInputKt.access$readLength((ByteArrayInput)$this$readBitString_u24lambda_u244);
                    byte unusedBits = $this$readBitString_u24lambda_u244.read();
                    byte[] bytes = $this$readBitString_u24lambda_u244.read(length - 1);
                    if (bytes.length == 0) {
                        if (!(unusedBits == 0)) {
                            boolean $i$a$-check-DerInput$readBitString$1$52 = false;
                            String $i$a$-check-DerInput$readBitString$1$52 = "wrong number of unused bits, expected 0, received: " + unusedBits;
                            throw new IllegalStateException($i$a$-check-DerInput$readBitString$1$52.toString());
                        }
                    } else {
                        int trailingZeros = Integer.numberOfTrailingZeros(ArraysKt.last((byte[])bytes) | 0x100);
                        if (!(unusedBits <= trailingZeros)) {
                            boolean $i$a$-check-DerInput$readBitString$1$62 = false;
                            String $i$a$-check-DerInput$readBitString$1$62 = "Not all unused bits are zeros, expected at least " + unusedBits + " trailing zeros, received " + trailingZeros;
                            throw new IllegalStateException($i$a$-check-DerInput$readBitString$1$62.toString());
                        }
                    }
                    bitArray = new BitArray(unusedBits, bytes);
                    break;
                }
                case 2: {
                    int length$iv = DerInputKt.access$readLength((ByteArrayInput)$this$readTagWithOverride$iv);
                    ByteArrayInput explicitInput$iv = $this$readTagWithOverride$iv.readSlice(length$iv);
                    DerInputKt.access$readRequestedTag(explicitInput$iv, tag$iv);
                    ByteArrayInput $this$readBitString_u24lambda_u244 = explicitInput$iv;
                    boolean bl = false;
                    int length = DerInputKt.access$readLength($this$readBitString_u24lambda_u244);
                    byte unusedBits = $this$readBitString_u24lambda_u244.read();
                    byte[] bytes = $this$readBitString_u24lambda_u244.read(length - 1);
                    if (bytes.length == 0) {
                        if (!(unusedBits == 0)) {
                            boolean bl2 = false;
                            String string = "wrong number of unused bits, expected 0, received: " + unusedBits;
                            throw new IllegalStateException(string.toString());
                        }
                    } else {
                        int trailingZeros = Integer.numberOfTrailingZeros(ArraysKt.last((byte[])bytes) | 0x100);
                        if (!(unusedBits <= trailingZeros)) {
                            boolean bl3 = false;
                            String string = "Not all unused bits are zeros, expected at least " + unusedBits + " trailing zeros, received " + trailingZeros;
                            throw new IllegalStateException(string.toString());
                        }
                    }
                    bitArray = new BitArray(unusedBits, bytes);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return bitArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] readOctetString(@Nullable ContextSpecificTag tagOverride) {
        byte[] byArray;
        void $this$readTagWithOverride$iv;
        void tagOverride$iv;
        ByteArrayInput byteArrayInput = this.input;
        ContextSpecificTag contextSpecificTag = tagOverride;
        byte tag$iv = 4;
        boolean $i$f$readTagWithOverride = false;
        if (tagOverride$iv == null) {
            DerInputKt.access$readRequestedTag((ByteArrayInput)$this$readTagWithOverride$iv, tag$iv);
            void $this$readOctetString_u24lambda_u245 = $this$readTagWithOverride$iv;
            boolean bl = false;
            int length = DerInputKt.access$readLength((ByteArrayInput)$this$readOctetString_u24lambda_u245);
            byArray = $this$readOctetString_u24lambda_u245.read(length);
        } else {
            DerInputKt.access$readRequestedTag((ByteArrayInput)$this$readTagWithOverride$iv, DerTagKt.getTag((ContextSpecificTag)tagOverride$iv));
            switch (DerInputKt.WhenMappings.$EnumSwitchMapping$0[tagOverride$iv.type().ordinal()]) {
                case 1: {
                    void $this$readOctetString_u24lambda_u245 = $this$readTagWithOverride$iv;
                    boolean bl = false;
                    int length = DerInputKt.access$readLength((ByteArrayInput)$this$readOctetString_u24lambda_u245);
                    byArray = $this$readOctetString_u24lambda_u245.read(length);
                    break;
                }
                case 2: {
                    int length$iv = DerInputKt.access$readLength((ByteArrayInput)$this$readTagWithOverride$iv);
                    ByteArrayInput explicitInput$iv = $this$readTagWithOverride$iv.readSlice(length$iv);
                    DerInputKt.access$readRequestedTag(explicitInput$iv, tag$iv);
                    ByteArrayInput $this$readOctetString_u24lambda_u245 = explicitInput$iv;
                    boolean bl = false;
                    int length = DerInputKt.access$readLength($this$readOctetString_u24lambda_u245);
                    byArray = $this$readOctetString_u24lambda_u245.read(length);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String readObjectIdentifier-iVrrli8(@Nullable ContextSpecificTag tagOverride) {
        String string;
        void $this$readTagWithOverride$iv;
        void tagOverride$iv;
        ByteArrayInput byteArrayInput = this.input;
        ContextSpecificTag contextSpecificTag = tagOverride;
        byte tag$iv = 6;
        boolean $i$f$readTagWithOverride = false;
        if (tagOverride$iv == null) {
            DerInputKt.access$readRequestedTag((ByteArrayInput)$this$readTagWithOverride$iv, tag$iv);
            void $this$readObjectIdentifier_iVrrli8_u24lambda_u246 = $this$readTagWithOverride$iv;
            boolean bl = false;
            int length = DerInputKt.access$readLength((ByteArrayInput)$this$readObjectIdentifier_iVrrli8_u24lambda_u246);
            ByteArrayInput slice = $this$readObjectIdentifier_iVrrli8_u24lambda_u246.readSlice(length);
            string = ObjectIdentifier.constructor-impl(DerInputKt.access$readOidElements(slice));
        } else {
            DerInputKt.access$readRequestedTag((ByteArrayInput)$this$readTagWithOverride$iv, DerTagKt.getTag((ContextSpecificTag)tagOverride$iv));
            switch (DerInputKt.WhenMappings.$EnumSwitchMapping$0[tagOverride$iv.type().ordinal()]) {
                case 1: {
                    void $this$readObjectIdentifier_iVrrli8_u24lambda_u246 = $this$readTagWithOverride$iv;
                    boolean bl = false;
                    int length = DerInputKt.access$readLength((ByteArrayInput)$this$readObjectIdentifier_iVrrli8_u24lambda_u246);
                    ByteArrayInput slice = $this$readObjectIdentifier_iVrrli8_u24lambda_u246.readSlice(length);
                    string = ObjectIdentifier.constructor-impl(DerInputKt.access$readOidElements(slice));
                    break;
                }
                case 2: {
                    int length$iv = DerInputKt.access$readLength((ByteArrayInput)$this$readTagWithOverride$iv);
                    ByteArrayInput explicitInput$iv = $this$readTagWithOverride$iv.readSlice(length$iv);
                    DerInputKt.access$readRequestedTag(explicitInput$iv, tag$iv);
                    ByteArrayInput $this$readObjectIdentifier_iVrrli8_u24lambda_u246 = explicitInput$iv;
                    boolean bl = false;
                    int length = DerInputKt.access$readLength($this$readObjectIdentifier_iVrrli8_u24lambda_u246);
                    ByteArrayInput slice = $this$readObjectIdentifier_iVrrli8_u24lambda_u246.readSlice(length);
                    string = ObjectIdentifier.constructor-impl(DerInputKt.access$readOidElements(slice));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteArrayInput readSequence(@Nullable ContextSpecificTag tagOverride) {
        ByteArrayInput byteArrayInput;
        void $this$readTagWithOverride$iv;
        void tagOverride$iv;
        ByteArrayInput byteArrayInput2 = this.input;
        ContextSpecificTag contextSpecificTag = tagOverride;
        byte tag$iv = 48;
        boolean $i$f$readTagWithOverride = false;
        if (tagOverride$iv == null) {
            DerInputKt.access$readRequestedTag((ByteArrayInput)$this$readTagWithOverride$iv, tag$iv);
            void $this$readSequence_u24lambda_u247 = $this$readTagWithOverride$iv;
            boolean bl = false;
            int length = DerInputKt.access$readLength((ByteArrayInput)$this$readSequence_u24lambda_u247);
            byteArrayInput = $this$readSequence_u24lambda_u247.readSlice(length);
        } else {
            DerInputKt.access$readRequestedTag((ByteArrayInput)$this$readTagWithOverride$iv, DerTagKt.getTag((ContextSpecificTag)tagOverride$iv));
            switch (DerInputKt.WhenMappings.$EnumSwitchMapping$0[tagOverride$iv.type().ordinal()]) {
                case 1: {
                    void $this$readSequence_u24lambda_u247 = $this$readTagWithOverride$iv;
                    boolean bl = false;
                    int length = DerInputKt.access$readLength((ByteArrayInput)$this$readSequence_u24lambda_u247);
                    byteArrayInput = $this$readSequence_u24lambda_u247.readSlice(length);
                    break;
                }
                case 2: {
                    int length$iv = DerInputKt.access$readLength((ByteArrayInput)$this$readTagWithOverride$iv);
                    ByteArrayInput explicitInput$iv = $this$readTagWithOverride$iv.readSlice(length$iv);
                    DerInputKt.access$readRequestedTag(explicitInput$iv, tag$iv);
                    ByteArrayInput $this$readSequence_u24lambda_u247 = explicitInput$iv;
                    boolean bl = false;
                    int length = DerInputKt.access$readLength($this$readSequence_u24lambda_u247);
                    byteArrayInput = $this$readSequence_u24lambda_u247.readSlice(length);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return byteArrayInput;
    }
}

