/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.serialization.asn1.modules;

import dev.whyoleg.cryptography.serialization.asn1.ObjectIdentifier;
import dev.whyoleg.cryptography.serialization.asn1.modules.AlgorithmIdentifierSerializer;
import dev.whyoleg.cryptography.serialization.asn1.modules.ECKt;
import dev.whyoleg.cryptography.serialization.asn1.modules.EcKeyAlgorithmIdentifier;
import dev.whyoleg.cryptography.serialization.asn1.modules.EcParameters;
import dev.whyoleg.cryptography.serialization.asn1.modules.KeyAlgorithmIdentifier;
import dev.whyoleg.cryptography.serialization.asn1.modules.RSAKt;
import dev.whyoleg.cryptography.serialization.asn1.modules.RsaKeyAlgorithmIdentifier;
import dev.whyoleg.cryptography.serialization.asn1.modules.UnknownKeyAlgorithmIdentifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0014J\u001b\u0010\t\u001a\u00020\u0002*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Ldev/whyoleg/cryptography/serialization/asn1/modules/KeyAlgorithmIdentifierSerializer;", "Ldev/whyoleg/cryptography/serialization/asn1/modules/AlgorithmIdentifierSerializer;", "Ldev/whyoleg/cryptography/serialization/asn1/modules/KeyAlgorithmIdentifier;", "<init>", "()V", "encodeParameters", "", "Lkotlinx/serialization/encoding/CompositeEncoder;", "value", "decodeParameters", "Lkotlinx/serialization/encoding/CompositeDecoder;", "algorithm", "Ldev/whyoleg/cryptography/serialization/asn1/ObjectIdentifier;", "decodeParameters-IHeWLgs", "(Lkotlinx/serialization/encoding/CompositeDecoder;Ljava/lang/String;)Ldev/whyoleg/cryptography/serialization/asn1/modules/KeyAlgorithmIdentifier;", "cryptography-serialization-asn1-modules"})
public final class KeyAlgorithmIdentifierSerializer
extends AlgorithmIdentifierSerializer<KeyAlgorithmIdentifier> {
    @NotNull
    public static final KeyAlgorithmIdentifierSerializer INSTANCE = new KeyAlgorithmIdentifierSerializer();

    private KeyAlgorithmIdentifierSerializer() {
    }

    @Override
    protected void encodeParameters(@NotNull CompositeEncoder $this$encodeParameters, @NotNull KeyAlgorithmIdentifier value) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeParameters, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        KeyAlgorithmIdentifier keyAlgorithmIdentifier = value;
        if (keyAlgorithmIdentifier instanceof RsaKeyAlgorithmIdentifier) {
            this.encodeParameters($this$encodeParameters, BuiltinSerializersKt.NothingSerializer(), RsaKeyAlgorithmIdentifier.INSTANCE.getParameters());
        } else if (keyAlgorithmIdentifier instanceof EcKeyAlgorithmIdentifier) {
            String string = ((EcKeyAlgorithmIdentifier)value).getParameters-g4m2kjQ();
            this.encodeParameters($this$encodeParameters, EcParameters.Companion.serializer(), string != null ? EcParameters.box-impl(string) : null);
        } else if (keyAlgorithmIdentifier instanceof UnknownKeyAlgorithmIdentifier) {
            this.encodeParameters($this$encodeParameters, BuiltinSerializersKt.NothingSerializer(), ((UnknownKeyAlgorithmIdentifier)value).getParameters());
        } else {
            this.encodeParameters($this$encodeParameters, BuiltinSerializersKt.NothingSerializer(), null);
        }
    }

    @Override
    @NotNull
    protected KeyAlgorithmIdentifier decodeParameters-IHeWLgs(@NotNull CompositeDecoder $this$decodeParameters_u2dIHeWLgs, @NotNull String algorithm) {
        KeyAlgorithmIdentifier keyAlgorithmIdentifier;
        Intrinsics.checkNotNullParameter((Object)$this$decodeParameters_u2dIHeWLgs, (String)"$this$decodeParameters");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        String string = algorithm;
        if (ObjectIdentifier.equals-impl0((String)string, (String)RSAKt.getRSA(ObjectIdentifier.Companion))) {
            this.decodeParameters($this$decodeParameters_u2dIHeWLgs, BuiltinSerializersKt.NothingSerializer());
            keyAlgorithmIdentifier = RsaKeyAlgorithmIdentifier.INSTANCE;
        } else if (ObjectIdentifier.equals-impl0((String)string, (String)ECKt.getEC(ObjectIdentifier.Companion))) {
            EcParameters ecParameters = this.decodeParameters($this$decodeParameters_u2dIHeWLgs, EcParameters.Companion.serializer());
            keyAlgorithmIdentifier = new EcKeyAlgorithmIdentifier(ecParameters != null ? ecParameters.unbox-impl() : null, null);
        } else {
            keyAlgorithmIdentifier = new UnknownKeyAlgorithmIdentifier(algorithm, null);
        }
        return keyAlgorithmIdentifier;
    }
}

