/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.serialization.pem;

import dev.whyoleg.cryptography.serialization.pem.PemContent;
import dev.whyoleg.cryptography.serialization.pem.PemLabel;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.io.bytestring.ByteString;
import kotlinx.io.bytestring.ByteStringKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/whyoleg/cryptography/serialization/pem/Pem;", "", "<init>", "()V", "BEGIN_PREFIX", "", "END_PREFIX", "SUFFIX", "encodeToByteString", "Lkotlinx/io/bytestring/ByteString;", "content", "Ldev/whyoleg/cryptography/serialization/pem/PemContent;", "encodeToByteArray", "", "encode", "decode", "byteString", "bytes", "string", "cryptography-serialization-pem"})
@SourceDebugExtension(value={"SMAP\nPem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pem.kt\ndev/whyoleg/cryptography/serialization/pem/Pem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n360#2,7:51\n360#2,7:59\n1#3:58\n*S KotlinDebug\n*F\n+ 1 Pem.kt\ndev/whyoleg/cryptography/serialization/pem/Pem\n*L\n30#1:51,7\n32#1:59,7\n*E\n"})
public final class Pem {
    @NotNull
    public static final Pem INSTANCE = new Pem();
    @NotNull
    private static final String BEGIN_PREFIX = "-----BEGIN ";
    @NotNull
    private static final String END_PREFIX = "-----END ";
    @NotNull
    private static final String SUFFIX = "-----";

    private Pem() {
    }

    @NotNull
    public final ByteString encodeToByteString(@NotNull PemContent content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return ByteStringKt.encodeToByteString((String)this.encode(content));
    }

    @NotNull
    public final byte[] encodeToByteArray(@NotNull PemContent content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return StringsKt.encodeToByteArray((String)this.encode(content));
    }

    @NotNull
    public final String encode(@NotNull PemContent content) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        StringBuilder $this$encode_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$encode_u24lambda_u240.append(BEGIN_PREFIX).append(content.getLabel-2EFq_Wg());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append(SUFFIX).append('\n');
        CollectionsKt.joinTo$default((Iterable)StringsKt.chunked((CharSequence)Base64.encode$default((Base64)((Base64)Base64.Default), (byte[])content.getBytes(), (int)0, (int)0, (int)6, null), (int)64), (Appendable)$this$encode_u24lambda_u240, (CharSequence)"\n", null, (CharSequence)"\n", (int)0, null, null, (int)116, null);
        StringBuilder stringBuilder4 = $this$encode_u24lambda_u240.append(END_PREFIX).append(content.getLabel-2EFq_Wg());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        stringBuilder3 = stringBuilder4;
        stringBuilder3.append(SUFFIX).append('\n');
        return stringBuilder.toString();
    }

    @NotNull
    public final PemContent decode(@NotNull ByteString byteString) {
        Intrinsics.checkNotNullParameter((Object)byteString, (String)"byteString");
        return this.decode(ByteStringKt.decodeToString((ByteString)byteString));
    }

    @NotNull
    public final PemContent decode(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return this.decode(StringsKt.decodeToString((byte[])bytes));
    }

    @NotNull
    public final PemContent decode(@NotNull String string) {
        int endLine;
        int beginLine;
        List lines;
        block10: {
            int n;
            block9: {
                int n2;
                Intrinsics.checkNotNullParameter((Object)string, (String)"string");
                String[] stringArray = new String[]{"\n"};
                List $this$indexOfFirst$iv = lines = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    String it = (String)item$iv;
                    boolean bl = false;
                    if (StringsKt.startsWith$default((String)it, (String)BEGIN_PREFIX, (boolean)false, (int)2, null)) {
                        n2 = index$iv;
                        break block9;
                    }
                    ++index$iv;
                }
                n2 = beginLine = -1;
            }
            if (!(beginLine != -1)) {
                boolean $i$a$-check-Pem$decode$62 = false;
                String $i$a$-check-Pem$decode$62 = "Invalid PEM format: missing BEGIN label";
                throw new IllegalStateException($i$a$-check-Pem$decode$62.toString());
            }
            List $this$indexOfFirst$iv = lines;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                String it = (String)item$iv;
                boolean bl = false;
                if (StringsKt.startsWith$default((String)it, (String)END_PREFIX, (boolean)false, (int)2, null)) {
                    n = index$iv;
                    break block10;
                }
                ++index$iv;
            }
            n = endLine = -1;
        }
        if (!(endLine != -1)) {
            boolean $i$a$-check-Pem$decode$72 = false;
            String $i$a$-check-Pem$decode$72 = "Invalid PEM format: missing END label";
            throw new IllegalStateException($i$a$-check-Pem$decode$72.toString());
        }
        String beginLabel = ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)((String)lines.get(beginLine)), (String)BEGIN_PREFIX, null, (int)2, null), (String)SUFFIX, null, (int)2, null))).toString();
        if (!(!StringsKt.isBlank((CharSequence)beginLabel))) {
            boolean $i$a$-check-Pem$decode$82 = false;
            String $i$a$-check-Pem$decode$82 = "Invalid PEM format: BEGIN label is empty";
            throw new IllegalStateException($i$a$-check-Pem$decode$82.toString());
        }
        String endLabel = ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)((String)lines.get(endLine)), (String)END_PREFIX, null, (int)2, null), (String)SUFFIX, null, (int)2, null))).toString();
        if (!(!StringsKt.isBlank((CharSequence)endLabel))) {
            boolean $i$a$-check-Pem$decode$92 = false;
            String $i$a$-check-Pem$decode$92 = "Invalid PEM format: BEGIN label is empty";
            throw new IllegalStateException($i$a$-check-Pem$decode$92.toString());
        }
        if (!Intrinsics.areEqual((Object)beginLabel, (Object)endLabel)) {
            boolean bl = false;
            String string2 = "Invalid PEM format: BEGIN=`" + beginLabel + "`, END=`" + endLabel + '`';
            throw new IllegalStateException(string2.toString());
        }
        String contentText = CollectionsKt.joinToString$default((Iterable)lines.subList(beginLine + 1, endLine), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        return new PemContent(PemLabel.constructor-impl(beginLabel), Base64.decode$default((Base64)((Base64)Base64.Default), (CharSequence)contentText, (int)0, (int)0, (int)6, null), null);
    }
}

