/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.yavin.ws;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@SpringBootApplication
@EntityScan(basePackages={"com.yahoo.navi.ws.models", "com.yahoo.yavin.ws.models"})
@EnableJpaRepositories
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0012X\u0093D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/yahoo/yavin/ws/App;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "serverPort", "", "startApp", "", "event", "Lorg/springframework/boot/context/event/ApplicationReadyEvent;", "ws"})
public class App {
    private final Logger LOGGER;
    @Value(value="${server.port}")
    private final int serverPort;

    @EventListener(value={ApplicationReadyEvent.class})
    public void startApp(@NotNull ApplicationReadyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.LOGGER.info(StringsKt.trimIndent((String)("\n            \n        =========================================================\n                 \n          Yavin App Serving On Port: " + this.serverPort + " (e.g. localhost:" + this.serverPort + ")\n         \n        =========================================================\n            ")));
    }

    public App() {
        Logger logger = LoggerFactory.getLogger(App.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(App::class.java)");
        this.LOGGER = logger;
    }
}

