/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.yavin.ws.config;

import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideSettingsBuilder;
import com.yahoo.elide.core.audit.AuditLogger;
import com.yahoo.elide.core.audit.Slf4jLogger;
import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.filter.dialect.RSQLFilterDialect;
import com.yahoo.elide.core.filter.dialect.jsonapi.JoinFilterDialect;
import com.yahoo.elide.core.filter.dialect.jsonapi.SubqueryFilterDialect;
import com.yahoo.elide.spring.config.AsyncProperties;
import com.yahoo.elide.spring.config.ControllerProperties;
import com.yahoo.elide.spring.config.ElideConfigProperties;
import com.yahoo.elide.spring.config.ExportControllerProperties;
import com.yahoo.elide.spring.config.JsonApiControllerProperties;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017\u00a8\u0006\u000b"}, d2={"Lcom/yahoo/yavin/ws/config/ElideConfig;", "", "()V", "initializeElide", "Lcom/yahoo/elide/Elide;", "dictionary", "Lcom/yahoo/elide/core/dictionary/EntityDictionary;", "dataStore", "Lcom/yahoo/elide/core/datastore/DataStore;", "settings", "Lcom/yahoo/elide/spring/config/ElideConfigProperties;", "ws"})
public class ElideConfig {
    @Bean
    @NotNull
    public Elide initializeElide(@NotNull EntityDictionary dictionary, @NotNull DataStore dataStore, @NotNull ElideConfigProperties settings) {
        Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
        Intrinsics.checkNotNullParameter((Object)dataStore, (String)"dataStore");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        ElideSettingsBuilder elideSettingsBuilder = new ElideSettingsBuilder(dataStore).withEntityDictionary(dictionary).withDefaultMaxPageSize(settings.getMaxPageSize()).withDefaultPageSize(settings.getPageSize()).withJoinFilterDialect((JoinFilterDialect)new RSQLFilterDialect(dictionary)).withSubqueryFilterDialect((SubqueryFilterDialect)new RSQLFilterDialect(dictionary)).withAuditLogger((AuditLogger)new Slf4jLogger()).withISO8601Dates("yyyy-MM-dd HH:mm:ss", TimeZone.getTimeZone("UTC"));
        JsonApiControllerProperties jsonApiControllerProperties = settings.getJsonApi();
        Intrinsics.checkNotNullExpressionValue((Object)jsonApiControllerProperties, (String)"settings.jsonApi");
        ElideSettingsBuilder elideSettingsBuilder2 = elideSettingsBuilder.withJsonApiPath(jsonApiControllerProperties.getPath());
        ControllerProperties controllerProperties = settings.getGraphql();
        Intrinsics.checkNotNullExpressionValue((Object)controllerProperties, (String)"settings.graphql");
        ElideSettingsBuilder elideSettingsBuilder3 = elideSettingsBuilder2.withGraphQLApiPath(controllerProperties.getPath());
        AsyncProperties asyncProperties = settings.getAsync();
        Intrinsics.checkNotNullExpressionValue((Object)asyncProperties, (String)"settings.async");
        ExportControllerProperties exportControllerProperties = asyncProperties.getExport();
        Intrinsics.checkNotNullExpressionValue((Object)exportControllerProperties, (String)"settings.async.export");
        ElideSettingsBuilder builder = elideSettingsBuilder3.withExportApiPath(exportControllerProperties.getPath());
        return new Elide(builder.build());
    }
}

