/*
 * Decompiled with CFR 0.152.
 */
package dev.youshallnotpass.inspection;

import dev.youshallnotpass.inspection.InspectionException;
import dev.youshallnotpass.inspection.Violation;
import dev.youshallnotpass.inspection.Violations;
import dev.youshallnotpass.inspection.badge.Badge;
import dev.youshallnotpass.plugin.Failures;
import dev.youshallnotpass.plugin.Ui;
import dev.youshallnotpass.plugin.YsnpException;
import java.net.URL;

public final class InspectionFailures<T extends Violation>
implements Failures {
    private final Violations<T> nulls;
    private final Badge badge;

    public InspectionFailures(Violations<T> nulls, Badge badge) {
        this.nulls = nulls;
        this.badge = badge;
    }

    @Override
    public void failIfRed() throws YsnpException {
        try {
            this.badge.failIfRed();
        }
        catch (InspectionException e) {
            throw new YsnpException("Inspection failed. ", e);
        }
    }

    @Override
    public void show(Ui ui) throws YsnpException {
        try {
            for (Violation violation : this.nulls.asList()) {
                ui.println(violation.description());
            }
        }
        catch (InspectionException e) {
            throw new YsnpException("Could not show the violations.", e);
        }
    }

    @Override
    public void publish(URL url) throws YsnpException {
        try {
            this.badge.send(url);
        }
        catch (InspectionException e) {
            throw new YsnpException("Could not publish the violations.", e);
        }
    }
}

